/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.endpoints;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.core.Server;
import org.mobicents.media.core.naming.EndpointNameGenerator;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointInstaller;

public class VirtualEndpointInstaller
implements EndpointInstaller {
    private static final Logger logger = Logger.getLogger(VirtualEndpointInstaller.class);
    private String namePattern;
    private String endpointClass;
    protected Integer initialSize;
    protected final EndpointNameGenerator nameParser;
    protected Server server;
    protected AtomicInteger lastEndpointID = new AtomicInteger(1);

    public VirtualEndpointInstaller() {
        this.nameParser = new EndpointNameGenerator();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public String getEndpointClass() {
        return this.endpointClass;
    }

    public void setEndpointClass(String endpointClass) {
        this.endpointClass = endpointClass;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public void install() {
        for (int i = 0; i < this.initialSize; ++i) {
            this.newEndpoint();
        }
    }

    public void newEndpoint() {
        ClassLoader loader = Server.class.getClassLoader();
        this.nameParser.setPattern(this.namePattern);
        try {
            Constructor<?> constructor = loader.loadClass(this.endpointClass).getConstructor(String.class);
            Endpoint endpoint = (Endpoint)constructor.newInstance(this.namePattern + this.lastEndpointID.getAndIncrement());
            this.server.install(endpoint, this);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't instantiate endpoint", (Throwable)e);
        }
    }

    public boolean canExpand() {
        return true;
    }

    public void uninstall() {
    }
}

