/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.endpoints;

import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.mobicents.media.core.Server;
import org.mobicents.media.core.endpoints.BaseSS7EndpointImpl;
import org.mobicents.media.core.endpoints.VirtualEndpointInstaller;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.spi.dsp.DspFactory;

public class VirtualSS7EndpointInstaller
extends VirtualEndpointInstaller {
    private static final Logger logger = Logger.getLogger(VirtualSS7EndpointInstaller.class);
    private ChannelsManager channelsManager;
    private DspFactory dsp;
    private int startChannelID = 1;
    private boolean isALaw = true;

    public boolean getIsALaw() {
        return this.isALaw;
    }

    public void setIsALaw(boolean isALaw) {
        this.isALaw = isALaw;
    }

    public int getStartChannelID() {
        return this.startChannelID;
    }

    public void setStartChannelID(int startChannelID) {
        this.startChannelID = startChannelID;
    }

    public ChannelsManager getChannelsManager() {
        return this.channelsManager;
    }

    public void setChannelsManager(ChannelsManager channelsManager) {
        this.channelsManager = channelsManager;
    }

    public void setDsp(DspFactory dsp) {
        this.dsp = dsp;
    }

    @Override
    public void install() {
        int index = this.startChannelID;
        for (int i = 0; i < this.initialSize; ++i) {
            this.newEndpoint(index++);
        }
    }

    @Override
    public void newEndpoint() {
    }

    private void newEndpoint(int index) {
        ClassLoader loader = Server.class.getClassLoader();
        try {
            Constructor<?> constructor = loader.loadClass(this.getEndpointClass()).getConstructor(String.class, ChannelsManager.class, Integer.TYPE, Boolean.TYPE);
            BaseSS7EndpointImpl endpoint = (BaseSS7EndpointImpl)constructor.newInstance(this.getNamePattern() + this.lastEndpointID.getAndIncrement(), this.channelsManager, index, this.isALaw, this.dsp);
            this.server.install(endpoint, this);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't instantiate endpoint", (Throwable)e);
        }
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public void uninstall() {
    }
}

