/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.configuration;

public enum CodecType {
    L16("l16", "org.mobicents.media.server.impl.dsp.audio.l16.Encoder", "org.mobicents.media.server.impl.dsp.audio.l16.Decoder"),
    PCMU("pcmu", "org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Encoder", "org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Decoder"),
    PCMA("pcma", "org.mobicents.media.server.impl.dsp.audio.g711.alaw.Encoder", "org.mobicents.media.server.impl.dsp.audio.g711.alaw.Decoder"),
    GSM("gsm", "org.mobicents.media.server.impl.dsp.audio.gsm.Encoder", "org.mobicents.media.server.impl.dsp.audio.gsm.Decoder"),
    G729("g729", "org.mobicents.media.server.impl.dsp.audio.g729.Encoder", "org.mobicents.media.server.impl.dsp.audio.g729.Decoder");

    private final String name;
    private final String encoder;
    private final String decoder;

    private CodecType(String name, String encoder, String decoder) {
        this.name = name;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoder() {
        return this.encoder;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public static final CodecType fromName(String name) {
        if (name != null && !name.isEmpty()) {
            for (CodecType codec : CodecType.values()) {
                if (!codec.name.equalsIgnoreCase(name)) continue;
                return codec;
            }
        }
        return null;
    }
}

