/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.ControlProtocol;
import org.mobicents.media.server.spi.MediaServer;
import org.mobicents.media.server.spi.ServerManager;

@Deprecated
public class Server
implements MediaServer {
    private static final Logger log = Logger.getLogger(Server.class);
    private Clock clock;
    private PriorityQueueScheduler scheduler;
    private UdpManager udpManager;
    private HeartBeat heartbeat;
    private int heartbeatTime = 0;
    private volatile long ttl;
    private final Map<ControlProtocol, ServerManager> managers = new HashMap<ControlProtocol, ServerManager>(2);
    private boolean started = false;

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setScheduler(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setUdpManager(UdpManager udpManager) {
        this.udpManager = udpManager;
    }

    public void setHeartBeatTime(int heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public void start() throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("Media Server already started");
        }
        if (this.clock == null) {
            log.error((Object)"Timing clock is not defined");
            return;
        }
        this.started = true;
        for (ServerManager controller : this.managers.values()) {
            log.info((Object)("Activating controller " + controller.getControlProtocol().name()));
            controller.activate();
        }
        if (this.heartbeatTime > 0) {
            this.heartbeat = new HeartBeat();
            this.heartbeat.restart();
        }
    }

    public void stop() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("Media Server already stopped");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Stopping UDP Manager");
        }
        this.udpManager.stop();
        if (this.heartbeat != null) {
            this.heartbeat.cancel();
        }
        for (ServerManager controller : this.managers.values()) {
            log.info((Object)("Deactivating controller " + controller.getControlProtocol().name()));
            controller.deactivate();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Stopping scheduler");
        }
        this.scheduler.stop();
        if (log.isInfoEnabled()) {
            log.info((Object)"Stopped media server instance ");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public void addManager(ServerManager manager) {
        this.managers.put(manager.getControlProtocol(), manager);
    }

    public void removeManager(ServerManager manager) {
        this.managers.remove(manager);
    }

    private final class HeartBeat
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        public void restart() {
            Server.this.ttl = Server.this.heartbeatTime * 600;
            Server.this.scheduler.submitHeatbeat((Task)this);
        }

        public long perform() {
            Server.this.ttl--;
            if (Server.this.ttl == 0L) {
                log.info((Object)"Global hearbeat is still alive");
                this.restart();
            } else {
                Server.this.scheduler.submitHeatbeat((Task)this);
            }
            return 0L;
        }
    }
}

