/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.configuration;

import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.mobicents.media.server.impl.rtp.crypto.CipherSuite;

public class DtlsConfiguration {
    public static final String MIN_VERSION = "1.0";
    public static final String MAX_VERSION = "1.2";
    public static final String CIPHER_SUITES = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_GCM_SHA384, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
    private ProtocolVersion minVersion;
    private ProtocolVersion maxVersion;
    private CipherSuite[] cipherSuites;

    public DtlsConfiguration() {
        this.setMinVersion(MIN_VERSION);
        this.setMaxVersion(MAX_VERSION);
        this.setCipherSuites(CIPHER_SUITES.split(","));
    }

    public ProtocolVersion getMinVersion() {
        return this.minVersion;
    }

    public ProtocolVersion getMaxVersion() {
        return this.maxVersion;
    }

    public CipherSuite[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = this.getVersionFromString(minVersion);
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = this.getVersionFromString(maxVersion);
    }

    private ProtocolVersion getVersionFromString(String version) {
        if (MIN_VERSION.equals(version)) {
            return ProtocolVersion.DTLSv10;
        }
        if (MAX_VERSION.equals(version)) {
            return ProtocolVersion.DTLSv12;
        }
        throw new IllegalArgumentException("Invalid DTLS version");
    }

    public void setCipherSuites(String[] values) {
        CipherSuite[] cipherSuiteTemp = new CipherSuite[values.length];
        for (int i = 0; i < values.length; ++i) {
            cipherSuiteTemp[i] = CipherSuite.valueOf((String)values[i].trim());
        }
        if (cipherSuiteTemp.length > 0) {
            this.cipherSuites = cipherSuiteTemp;
        }
    }
}

