/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.configuration;

public enum CodecType {
    PCMU(0, "pcmu", "org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Encoder", "org.mobicents.media.server.impl.dsp.audio.g711.ulaw.Decoder"),
    PCMA(8, "pcma", "org.mobicents.media.server.impl.dsp.audio.g711.alaw.Encoder", "org.mobicents.media.server.impl.dsp.audio.g711.alaw.Decoder"),
    GSM(3, "gsm", "org.mobicents.media.server.impl.dsp.audio.gsm.Encoder", "org.mobicents.media.server.impl.dsp.audio.gsm.Decoder"),
    L16(97, "l16", "org.mobicents.media.server.impl.dsp.audio.l16.Encoder", "org.mobicents.media.server.impl.dsp.audio.l16.Decoder"),
    G729(18, "g729", "org.mobicents.media.server.impl.dsp.audio.g729.Encoder", "org.mobicents.media.server.impl.dsp.audio.g729.Decoder"),
    ILBC(102, "ilbc", "org.mobicents.media.server.impl.dsp.audio.ilbc.Encoder", "org.mobicents.media.server.impl.dsp.audio.ilbc.Decoder"),
    DTMF(101, "telephone-event", "", "");

    private final int payloadType;
    private final String name;
    private final String encoder;
    private final String decoder;

    private CodecType(int payloadType, String name, String encoder, String decoder) {
        this.payloadType = payloadType;
        this.name = name;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoder() {
        return this.encoder;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public static final CodecType fromName(String name) {
        if (name != null && !name.isEmpty()) {
            for (CodecType codec : CodecType.values()) {
                if (!codec.name.equalsIgnoreCase(name)) continue;
                return codec;
            }
        }
        return null;
    }
}

