/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.core.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mobicents.media.core.configuration.MgcpEndpointConfiguration;

public class MgcpControllerConfiguration {
    public static final String ADDRESS = "127.0.0.1";
    public static final int PORT = 2427;
    public static final int POOL_SIZE = 25;
    public static final String CONFIGURATION = "mgcp-conf.xml";
    private String address = "127.0.0.1";
    private int port = 2427;
    private int poolSize = 25;
    private String configuration = "mgcp-conf.xml";
    private final Map<String, MgcpEndpointConfiguration> endpoints = new HashMap<String, MgcpEndpointConfiguration>(5);

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (address == null || address.isEmpty()) {
            throw new IllegalArgumentException("MGCP address cannot be empty");
        }
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal MGCP port value: 0 < " + port + " < 65536");
        }
        this.port = port;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        if (poolSize < 0) {
            throw new IllegalArgumentException("Pool size cannot be negative.");
        }
        this.poolSize = poolSize;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            throw new IllegalArgumentException("Configuration file path cannot be empty.");
        }
        this.configuration = configuration;
    }

    public int countEndpoints() {
        return this.endpoints.size();
    }

    public Iterator<MgcpEndpointConfiguration> getEndpoints() {
        return this.endpoints.values().iterator();
    }

    public MgcpEndpointConfiguration getEndpoint(String type) {
        return this.endpoints.get(type);
    }

    public MgcpEndpointConfiguration addEndpoint(MgcpEndpointConfiguration endpoint) {
        return this.endpoints.put(endpoint.getName(), endpoint);
    }

    public MgcpEndpointConfiguration removeEndpoint(String type) {
        return this.endpoints.remove(type);
    }

    public void removeAllEndpoints() {
        this.endpoints.clear();
    }
}

