/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.dtmf.DetectorImpl;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEventImpl;
import org.mobicents.media.server.scheduler.ConcurrentLinkedList;

public class DtmfBuffer
implements Serializable {
    public int interdigitInterval = 160;
    private ConcurrentLinkedList<DtmfEventImpl> queue = new ConcurrentLinkedList();
    private int size = 20;
    private long lastActivity = System.currentTimeMillis();
    private String lastSymbol;
    private DetectorImpl detector;
    private static final Logger logger = Logger.getLogger(DtmfBuffer.class);

    public DtmfBuffer(DetectorImpl detector) {
        this.detector = detector;
    }

    public void setInterdigitInterval(int silence) {
        this.interdigitInterval = silence;
    }

    public int getInterdigitInterval() {
        return this.interdigitInterval;
    }

    public void push(String symbol) {
        long now = System.currentTimeMillis();
        if (!symbol.equals(this.lastSymbol) || now - this.lastActivity > (long)this.interdigitInterval) {
            this.lastActivity = now;
            this.lastSymbol = symbol;
            this.detector.fireEvent(symbol);
        }
    }

    public void updateTime() {
        this.lastActivity = System.currentTimeMillis();
    }

    protected void queue(DtmfEventImpl evt) {
        if (this.queue.size() == this.size) {
            this.queue.poll();
        }
        this.queue.offer((Object)evt);
        logger.info((Object)String.format("(%s) Buffer size: %d", this.detector.getName(), this.queue.size()));
    }

    public void flush() {
        logger.info((Object)String.format("(%s) Flush, buffer size: %d", this.detector.getName(), this.queue.size()));
        while (this.queue.size() > 0) {
            this.detector.fireEvent((DtmfEventImpl)this.queue.poll());
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

