/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;
import org.mobicents.media.server.spi.resource.DtmfGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorImpl
extends AbstractSource
implements DtmfGenerator {
    private static final AudioFormat linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    public static final String[][] events;
    private int[] lowFreq = new int[]{697, 770, 852, 941};
    private int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private String digit = null;
    private int duration = 50;
    private short A = (short)16383;
    private int volume = 0;
    private int f1;
    private int f2;
    private double dt = 1.0 / (double)linear.getSampleRate();
    private int pSize;
    private double time = 0.0;

    public GeneratorImpl(String name, Scheduler scheduler) {
        super(name, scheduler, Scheduler.SPLITTER_OUTPUT_QUEUE.intValue());
    }

    public void start() {
        if (this.digit == null) {
            return;
        }
        this.time = 0.0;
        super.start();
    }

    public void setDigit(String digit) {
        this.digit = digit;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!events[i][j].equalsIgnoreCase(digit)) continue;
                this.f1 = this.lowFreq[i];
                this.f2 = this.highFreq[j];
            }
        }
    }

    public String getDigit() {
        return this.digit;
    }

    public void setToneDuration(int duration) {
        if (duration < 40) {
            throw new IllegalArgumentException("Duration cannot be less than 40ms");
        }
        this.duration = duration;
    }

    public int getToneDuration() {
        return this.duration;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (volume > 0) {
            throw new IllegalArgumentException("Volume has to be negative value expressed in dBm0");
        }
        this.volume = volume;
        this.A = (short)(Math.pow(Math.pow(10.0, volume), 0.1) * 16383.0);
    }

    private short getValue(double t) {
        return (short)((double)this.A * (Math.sin(Math.PI * 2 * (double)this.f1 * t) + Math.sin(Math.PI * 2 * (double)this.f2 * t)));
    }

    public Formats getNativeFormats() {
        return formats;
    }

    public Frame evolve(long timestamp) {
        int k = 0;
        int frameSize = (int)(0.02 / this.dt);
        Frame frame = Memory.allocate((int)(2 * frameSize));
        byte[] data = frame.getData();
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        frame.setOffset(0);
        frame.setLength(2 * frameSize);
        frame.setTimestamp(this.getMediaTime());
        frame.setDuration(20000000L);
        if (this.time == 0.0) {
            // empty if block
        }
        this.time += 0.02;
        frame.setEOM(this.time > (double)this.duration / 1000.0);
        return frame;
    }

    public void stop() {
        super.stop();
    }

    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(DtmfGenerator.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    static {
        formats.add((Format)linear);
        events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    }
}

