/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.CompoundOutput;
import org.mobicents.media.server.component.audio.GoertzelFilter;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.dtmf.DtmfBuffer;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEventImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.memory.Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorImpl
extends AbstractSink
implements DtmfDetector {
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    private static final int TONE_DURATION = 80;
    public static final String[][] events;
    private static final String[] evtID;
    private static final int[] lowFreq;
    private static final int[] highFreq;
    private GoertzelFilter[] lowFreqFilters = new GoertzelFilter[4];
    private GoertzelFilter[] highFreqFilters = new GoertzelFilter[4];
    private double threshold = 0.0;
    private int level;
    private int offset = 0;
    private int toneDuration = 80;
    private int N = 8 * this.toneDuration;
    private double scale = (double)this.toneDuration / 1000.0;
    private double[] p = new double[4];
    private double[] P = new double[4];
    private double[] signal;
    private double maxAmpl;
    private DtmfBuffer dtmfBuffer;
    private Listeners<DtmfDetectorListener> listeners = new Listeners();
    private EventSender eventSender;
    private Scheduler scheduler;
    private CompoundOutput output;
    private static final Logger logger;

    public DetectorImpl(String name, Scheduler scheduler) {
        super(name);
        this.scheduler = scheduler;
        this.dtmfBuffer = new DtmfBuffer(this);
        this.eventSender = new EventSender(scheduler);
        this.signal = new double[this.N];
        for (int i = 0; i < 4; ++i) {
            this.lowFreqFilters[i] = new GoertzelFilter(lowFreq[i], this.N, this.scale);
            this.highFreqFilters[i] = new GoertzelFilter(highFreq[i], this.N, this.scale);
        }
        this.level = -30;
        this.output = new CompoundOutput(scheduler, ComponentType.RECORDER.getType());
        this.output.join((AbstractSink)this);
    }

    public CompoundOutput getCompoundOutput() {
        return this.output;
    }

    public void activate() {
        this.offset = 0;
        this.maxAmpl = 0.0;
        this.dtmfBuffer.clear();
        this.output.start();
    }

    public void deactivate() {
        this.output.stop();
    }

    public void setDuration(int duartion) {
        this.toneDuration = duartion;
    }

    public int getDuration() {
        return this.toneDuration;
    }

    public void setVolume(int level) {
        this.level = level;
        this.threshold = Math.pow(Math.pow(10.0, level), 0.1) * 32767.0;
    }

    public void setLasy(boolean isLazy) {
    }

    public int getVolume() {
        return this.level;
    }

    public void onMediaTransfer(Frame buffer) throws IOException {
        byte[] data = buffer.getData();
        int M = buffer.getLength();
        int k = 0;
        while (k < M) {
            while (this.offset < this.N && k < M - 1) {
                int n = k++;
                int n2 = k++;
                double s = data[n] & 0xFF | data[n2] << 8;
                double sa = Math.abs(s);
                if (sa > this.maxAmpl) {
                    this.maxAmpl = sa;
                }
                this.signal[this.offset++] = s;
            }
            if (this.offset != this.N) continue;
            this.offset = 0;
            if (!(this.maxAmpl >= this.threshold)) continue;
            this.maxAmpl = 0.0;
            this.getPower(this.lowFreqFilters, this.signal, 0, this.p);
            this.getPower(this.highFreqFilters, this.signal, 0, this.P);
            String tone = this.getTone(this.p, this.P);
            if (tone == null) continue;
            this.dtmfBuffer.push(tone);
        }
    }

    private void getPower(GoertzelFilter[] filters, double[] data, int offset, double[] power) {
        for (int i = 0; i < 4; ++i) {
            power[i] = filters[i].getPower(data, offset);
        }
    }

    private int getMax(double[] data) {
        int idx = 0;
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(max < data[i])) continue;
            max = data[i];
            idx = i;
        }
        return idx;
    }

    private String getTone(double[] f, double[] F) {
        int fm = this.getMax(f);
        boolean fd = true;
        for (int i = 0; i < f.length; ++i) {
            double r;
            if (fm == i || !((r = f[fm] / (f[i] + 1.0E-15)) < this.threshold)) continue;
            fd = false;
            break;
        }
        if (!fd) {
            return null;
        }
        int Fm = this.getMax(F);
        boolean Fd = true;
        for (int i = 0; i < F.length; ++i) {
            double r;
            if (Fm == i || !((r = F[Fm] / (F[i] + 1.0E-15)) < this.threshold)) continue;
            Fd = false;
            break;
        }
        if (!Fd) {
            return null;
        }
        return events[fm][Fm];
    }

    public Formats getNativeFormats() {
        return formats;
    }

    public String getMask() {
        return null;
    }

    public void setMask(String mask) {
    }

    public void setInterdigitInterval(int interval) {
        this.dtmfBuffer.setInterdigitInterval(interval);
    }

    public int getInterdigitInterval() {
        return this.dtmfBuffer.getInterdigitInterval();
    }

    protected void fireEvent(String tone) {
        this.eventSender.events.add(new DtmfEventImpl(this, tone, 0));
        this.scheduler.submit((Task)this.eventSender, Scheduler.INPUT_QUEUE);
    }

    protected void fireEvent(DtmfEventImpl evt) {
        this.eventSender.events.add(evt);
        this.scheduler.submit((Task)this.eventSender, Scheduler.INPUT_QUEUE);
    }

    protected void fireEvent(Collection<DtmfEventImpl> evts) {
        this.eventSender.events.addAll(evts);
        this.scheduler.submit((Task)this.eventSender, Scheduler.INPUT_QUEUE);
    }

    public void flushBuffer() {
        this.dtmfBuffer.flush();
    }

    public void clearBuffer() {
        this.dtmfBuffer.clear();
    }

    public void addListener(DtmfDetectorListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(DtmfDetectorListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public void clearDigits() {
        this.dtmfBuffer.clear();
    }

    static {
        formats.add(linear);
        events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
        evtID = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "#", "*"};
        lowFreq = new int[]{697, 770, 852, 941};
        highFreq = new int[]{1209, 1336, 1477, 1633};
        logger = Logger.getLogger(DetectorImpl.class);
    }

    public class EventSender
    extends Task {
        protected ArrayList<DtmfEventImpl> events;

        public EventSender(Scheduler scheduler) {
            super(scheduler);
            this.events = new ArrayList();
        }

        public int getQueueNumber() {
            return Scheduler.INPUT_QUEUE;
        }

        public long perform() {
            for (DtmfEventImpl evt : this.events) {
                if (!DetectorImpl.this.listeners.dispatch((Event)evt)) {
                    DetectorImpl.this.dtmfBuffer.queue(evt);
                    if (DetectorImpl.this.getEndpoint() == null) {
                        logger.info((Object)String.format("(%s) Buffered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
                        continue;
                    }
                    logger.info((Object)String.format("(" + DetectorImpl.this.getEndpoint().getLocalName() + ") (%s) Buffered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
                    continue;
                }
                if (DetectorImpl.this.getEndpoint() == null) {
                    logger.info((Object)String.format("(%s) Delivered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
                    continue;
                }
                logger.info((Object)String.format("(" + DetectorImpl.this.getEndpoint().getLocalName() + ") (%s) Delivered '%s' tone", DetectorImpl.this.getName(), evt.getTone()));
            }
            this.events.clear();
            return 0L;
        }
    }
}

