/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.CompoundInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;
import org.mobicents.media.server.spi.resource.DtmfGenerator;

public class GeneratorImpl
extends AbstractSource
implements DtmfGenerator {
    private static final AudioFormat linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * linear.getSampleRate() / 1000 * linear.getSampleSize() / 8;
    private static final Formats formats = new Formats();
    public static final String[][] events;
    private int[] lowFreq = new int[]{697, 770, 852, 941};
    private int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private String digit = null;
    private int duration = 50;
    private short A = (short)16383;
    private int volume = 0;
    private int f1;
    private int f2;
    private double dt = 1.0 / (double)linear.getSampleRate();
    private int pSize;
    private double time = 0.0;
    private CompoundInput input = new CompoundInput(ComponentType.DTMF_GENERATOR.getType(), this.packetSize);

    public GeneratorImpl(String name, Scheduler scheduler) {
        super(name, scheduler, Scheduler.INPUT_QUEUE.intValue());
        this.connect((AbstractSink)this.input);
    }

    public CompoundInput getCompoundInput() {
        return this.input;
    }

    public void activate() {
        if (this.digit == null) {
            return;
        }
        this.time = 0.0;
        this.start();
    }

    public void setDigit(String digit) {
        this.digit = digit;
        this.time = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!events[i][j].equalsIgnoreCase(digit)) continue;
                this.f1 = this.lowFreq[i];
                this.f2 = this.highFreq[j];
            }
        }
    }

    public String getDigit() {
        return this.digit;
    }

    public void setToneDuration(int duration) {
        if (duration < 40) {
            throw new IllegalArgumentException("Duration cannot be less than 40ms");
        }
        this.duration = duration;
    }

    public int getToneDuration() {
        return this.duration;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (volume > 0) {
            throw new IllegalArgumentException("Volume has to be negative value expressed in dBm0");
        }
        this.volume = volume;
        this.A = (short)(Math.pow(Math.pow(10.0, volume), 0.1) * 16383.0);
    }

    private short getValue(double t) {
        return (short)((double)this.A * (Math.sin(Math.PI * 2 * (double)this.f1 * t) + Math.sin(Math.PI * 2 * (double)this.f2 * t)));
    }

    public Formats getNativeFormats() {
        return formats;
    }

    public Frame evolve(long timestamp) {
        if (this.time > (double)this.duration / 1000.0) {
            return null;
        }
        int k = 0;
        int frameSize = (int)(0.02 / this.dt);
        Frame frame = Memory.allocate((int)(2 * frameSize));
        byte[] data = frame.getData();
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        frame.setOffset(0);
        frame.setLength(2 * frameSize);
        frame.setTimestamp(this.getMediaTime());
        frame.setDuration(20000000L);
        if (this.time == 0.0) {
            // empty if block
        }
        this.time += 0.02;
        return frame;
    }

    public void deactivate() {
        this.stop();
    }

    static {
        formats.add((Format)linear);
        events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    }
}

