/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.component.oob.OOBInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.spi.dtmf.DtmfGenerator;
import org.mobicents.media.server.spi.dtmf.DtmfGeneratorEvent;
import org.mobicents.media.server.spi.dtmf.DtmfGeneratorListener;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;
import org.mobicents.media.server.spi.pooling.PooledObject;

public class GeneratorImpl
extends AbstractSource
implements DtmfGenerator,
PooledObject {
    private static final AudioFormat linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * linear.getSampleRate() / 1000 * linear.getSampleSize() / 8;
    private static final Formats formats = new Formats();
    public static final String[][] events;
    private int[] lowFreq = new int[]{697, 770, 852, 941};
    private int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private String digit = null;
    private String oobDigit = null;
    private int oobDigitValue = -1;
    private int toneDuration = 50;
    private short A = (short)16383;
    private int volume = 0;
    private int f1;
    private int f2;
    private double dt;
    private int pSize;
    private double time = 0.0;
    private AudioInput input;
    private OOBInput oobInput;
    private OOBGenerator oobGenerator;
    private final Listeners<DtmfGeneratorListener> listeners;
    DtmfGeneratorEvent event = new DtmfGeneratorEvent((DtmfGenerator)this, 1);

    public GeneratorImpl(String name, PriorityQueueScheduler scheduler) {
        super(name, scheduler, PriorityQueueScheduler.INPUT_QUEUE.intValue());
        this.dt = 1.0 / (double)linear.getSampleRate();
        this.input = new AudioInput(ComponentType.DTMF_GENERATOR.getType(), this.packetSize);
        this.connect((AbstractSink)this.input);
        this.oobInput = new OOBInput(ComponentType.DTMF_GENERATOR.getType());
        this.oobGenerator = new OOBGenerator(scheduler, this.oobInput);
        this.listeners = new Listeners();
    }

    public void addListener(DtmfGeneratorListener listener) {
        try {
            this.listeners.add((Listener)listener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void removeListener(DtmfGeneratorListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void clearAllListeners() {
        this.listeners.clear();
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public OOBInput getOOBInput() {
        return this.oobInput;
    }

    public void activate() {
        if (this.oobDigit != null) {
            this.oobGenerator.index = 0;
            this.oobGenerator.activate();
        }
        if (this.digit != null) {
            this.time = 0.0;
            this.start();
        }
    }

    public void setOOBDigit(String digit) {
        if (digit.charAt(0) >= '0' && digit.charAt(0) <= '9') {
            this.oobDigitValue = digit.charAt(0) - 48;
        } else if (digit.charAt(0) == '*') {
            this.oobDigitValue = 10;
        } else if (digit.charAt(0) == '#') {
            this.oobDigitValue = 11;
        } else if (digit.charAt(0) >= 'A' && digit.charAt(0) <= 'D') {
            this.oobDigitValue = 12 + digit.charAt(0) - 65;
        } else if (digit.charAt(0) >= 'a' && digit.charAt(0) <= 'd') {
            this.oobDigitValue = 12 + digit.charAt(0) - 97;
        } else {
            return;
        }
        this.oobGenerator.index = 0;
        this.oobDigit = digit;
        this.digit = null;
    }

    public void setDigit(String digit) {
        this.oobDigit = null;
        this.digit = digit;
        this.time = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!events[i][j].equalsIgnoreCase(digit)) continue;
                this.f1 = this.lowFreq[i];
                this.f2 = this.highFreq[j];
            }
        }
    }

    public void completed() {
        super.completed();
        this.listeners.dispatch((Event)this.event);
    }

    public String getDigit() {
        return this.digit;
    }

    public String getOOBDigit() {
        return this.oobDigit;
    }

    public void setToneDuration(int duration) {
        if (duration < 40) {
            throw new IllegalArgumentException("Duration cannot be less than 40ms");
        }
        this.toneDuration = duration;
    }

    public int getToneDuration() {
        return this.toneDuration;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        if (volume > 0) {
            throw new IllegalArgumentException("Volume has to be negative value expressed in dBm0");
        }
        this.volume = volume;
        this.A = (short)(Math.pow(Math.pow(10.0, volume), 0.1) * 16383.0);
    }

    private short getValue(double t) {
        return (short)((double)this.A * (Math.sin(Math.PI * 2 * (double)this.f1 * t) + Math.sin(Math.PI * 2 * (double)this.f2 * t)));
    }

    public Formats getNativeFormats() {
        return formats;
    }

    public Frame evolve(long timestamp) {
        if (this.time > (double)this.toneDuration / 1000.0) {
            return null;
        }
        int k = 0;
        int frameSize = (int)(0.02 / this.dt);
        Frame frame = Memory.allocate((int)(2 * frameSize));
        byte[] data = frame.getData();
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        frame.setOffset(0);
        frame.setLength(2 * frameSize);
        frame.setTimestamp(this.getMediaTime());
        frame.setDuration(20000000L);
        this.time += 0.02;
        if (this.time >= (double)this.toneDuration / 1000.0) {
            this.listeners.dispatch((Event)this.event);
        }
        return frame;
    }

    public void deactivate() {
        this.stop();
        this.oobGenerator.deactivate();
    }

    public void wakeup() {
        if (this.oobDigit != null) {
            this.oobGenerator.wakeup();
        } else if (this.digit != null) {
            super.wakeup();
        }
    }

    public void checkIn() {
    }

    public void checkOut() {
    }

    static {
        formats.add((Format)linear);
        events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    }

    private class OOBGenerator
    extends AbstractSource {
        int index;
        int eventDuration;
        int oobVolume;

        public OOBGenerator(PriorityQueueScheduler scheduler, OOBInput input) {
            super("oob generator", scheduler, PriorityQueueScheduler.INPUT_QUEUE.intValue());
            this.index = 0;
            this.eventDuration = 0;
            this.connect((AbstractSink)input);
        }

        public Frame evolve(long timestamp) {
            if (this.index > GeneratorImpl.this.toneDuration / 20 + 2) {
                return null;
            }
            Frame frame = Memory.allocate((int)4);
            byte[] data = frame.getData();
            data[0] = (byte)GeneratorImpl.this.oobDigitValue;
            this.oobVolume = 0 - GeneratorImpl.this.volume;
            data[1] = this.index > GeneratorImpl.this.toneDuration / 20 ? (byte)(0xBF & this.oobVolume) : (byte)(0x3F & this.oobVolume);
            this.eventDuration = (short)(160 * this.index);
            data[2] = (byte)(this.eventDuration >> 8 & 0xFF);
            data[3] = (byte)(this.eventDuration & 0xFF);
            frame.setOffset(0);
            frame.setLength(4);
            frame.setTimestamp(this.getMediaTime());
            frame.setDuration(20000000L);
            ++this.index;
            if (this.index == GeneratorImpl.this.toneDuration / 20 + 2) {
                GeneratorImpl.this.listeners.dispatch((Event)GeneratorImpl.this.event);
            }
            return frame;
        }

        public void activate() {
            this.start();
        }

        public void deactivate() {
            this.stop();
        }
    }
}

