/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.phone;

import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.CompoundInput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class PhoneSignalGenerator
extends AbstractSource {
    private AudioFormat LINEAR_AUDIO = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    int frameSize = (int)((double)(20.0f * (float)this.LINEAR_AUDIO.getSampleRate()) / 1000.0);
    private int[] f;
    private short A = Short.MAX_VALUE;
    private double dt;
    private int pSize;
    private double time;
    private double elapsed;
    private double duration;
    private double value = 1.0;
    private int seqNumber = 1;
    private int[] T = new int[]{1, 1};
    private CompoundInput input;

    public PhoneSignalGenerator(String name, Scheduler scheduler) {
        super(name, scheduler, Scheduler.INPUT_QUEUE.intValue());
        this.init();
        this.input = new CompoundInput(ComponentType.SIGNAL_GENERATOR.getType(), this.frameSize);
        this.connect((AbstractSink)this.input);
    }

    public CompoundInput getCompoundInput() {
        return this.input;
    }

    private void init() {
        this.dt = 1.0f / (float)this.LINEAR_AUDIO.getSampleRate();
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public short getAmplitude() {
        return this.A;
    }

    public void setFrequency(int[] f) {
        this.f = f;
    }

    public int[] getFrequency() {
        return this.f;
    }

    public void setPeriods(int[] T) {
        this.T = T;
        this.duration = T[0];
    }

    public int[] getPeriods() {
        return this.T;
    }

    private short getValue(double t) {
        this.elapsed += this.dt;
        if (this.elapsed > this.duration) {
            if (this.value == 0.0) {
                this.value = 1.0;
                this.duration = this.T[0];
            } else {
                this.value = 0.0;
                this.duration = this.T[1];
            }
            this.elapsed = 0.0;
        }
        if (this.value == 0.0) {
            return 0;
        }
        double v = 0.0;
        for (int i = 0; i < this.f.length; ++i) {
            v += Math.sin(Math.PI * 2 * (double)this.f[i] * t);
        }
        return (short)(v * (double)this.A);
    }

    public Frame evolve(long timestamp) {
        Frame currFrame = Memory.allocate((int)(this.frameSize * 2));
        byte[] data = currFrame.getData();
        int k = 0;
        this.pSize = (int)(0.02 / this.dt);
        for (int i = 0; i < this.frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        currFrame.setHeader(null);
        currFrame.setSequenceNumber((long)this.seqNumber++);
        currFrame.setTimestamp(System.currentTimeMillis());
        currFrame.setOffset(0);
        currFrame.setLength(data.length);
        currFrame.setDuration(20000000L);
        currFrame.setFormat((Format)this.LINEAR_AUDIO);
        this.time += 0.02;
        return currFrame;
    }
}

