/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.format;

import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.EncodingName;
import org.mobicents.media.server.spi.format.VideoFormat;
import org.mobicents.media.server.spi.format.audio.DTMFFormat;
import org.mobicents.media.server.utils.Text;

public class FormatFactory {
    private static Text DTMF = new Text("telephone-event");

    public static AudioFormat createAudioFormat(EncodingName name) {
        if (name.equals(DTMF)) {
            return new DTMFFormat();
        }
        return new AudioFormat(name);
    }

    public static AudioFormat createAudioFormat(EncodingName name, int sampleRate, int sampleSize, int channels) {
        AudioFormat fmt = FormatFactory.createAudioFormat(name);
        fmt.setSampleRate(sampleRate);
        fmt.setSampleSize(sampleSize);
        fmt.setChannels(channels);
        return fmt;
    }

    public static AudioFormat createAudioFormat(String name, int sampleRate, int sampleSize, int channels) {
        AudioFormat fmt = FormatFactory.createAudioFormat(new EncodingName(name));
        fmt.setSampleRate(sampleRate);
        fmt.setSampleSize(sampleSize);
        fmt.setChannels(channels);
        return fmt;
    }

    public static AudioFormat createAudioFormat(String name, int sampleRate) {
        AudioFormat fmt = FormatFactory.createAudioFormat(new EncodingName(name));
        fmt.setSampleRate(sampleRate);
        return fmt;
    }

    public static VideoFormat createVideoFormat(EncodingName name, int frameRate) {
        return new VideoFormat(name, frameRate);
    }

    public static VideoFormat createVideoFormat(EncodingName name) {
        return new VideoFormat(name);
    }

    public static VideoFormat createVideoFormat(String name) {
        return new VideoFormat(name);
    }

    public static VideoFormat createVideoFormat(String name, int frameRate) {
        return new VideoFormat(name, frameRate);
    }
}

