/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.format;

import java.util.ArrayList;
import org.mobicents.media.server.spi.format.Format;

public class Formats {
    public static final int DEFAULT_SIZE = 15;
    private ArrayList<Format> list;

    public Formats() {
        this.list = new ArrayList(15);
    }

    public Formats(int size) {
        this.list = new ArrayList(size);
    }

    public void add(Format format) {
        this.list.add(format);
    }

    public void addAll(Formats other) {
        this.list.addAll(other.list);
    }

    public void remove(Format format) {
        this.list.remove(format);
    }

    public Format get(int i) {
        return this.list.get(i);
    }

    public boolean contains(Format format) {
        for (Format f : this.list) {
            if (!f.matches(format)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clean() {
        this.list.clear();
    }

    public void intersection(Formats other, Formats intersection) {
        intersection.list.clear();
        for (Format f1 : this.list) {
            for (Format f2 : other.list) {
                if (!f1.matches(f2)) continue;
                intersection.list.add(f2);
            }
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Formats{");
        for (int i = 0; i < this.list.size(); ++i) {
            buff.append(this.list.get(i));
            if (i == this.list.size() - 1) continue;
            buff.append(",");
        }
        buff.append("}");
        return buff.toString();
    }
}

