/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.pooling;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.spi.pooling.PooledObject;
import org.mobicents.media.server.spi.pooling.ResourcePool;

public abstract class AbstractResourcePool<T extends PooledObject>
implements ResourcePool<T> {
    private final Queue<T> resources;
    private int initialCapacity;
    private final AtomicInteger size;

    protected AbstractResourcePool(Queue<T> resources, int initialCapacity) {
        this.resources = resources;
        this.initialCapacity = initialCapacity;
        this.size = new AtomicInteger(initialCapacity);
    }

    protected void populate() {
        for (int index = 0; index < this.initialCapacity; ++index) {
            this.resources.offer(this.createResource());
        }
    }

    @Override
    public T poll() {
        PooledObject resource = (PooledObject)this.resources.poll();
        if (resource == null) {
            resource = this.createResource();
            this.size.incrementAndGet();
        }
        resource.checkOut();
        return (T)resource;
    }

    @Override
    public void offer(T resource) {
        if (resource != null) {
            resource.checkIn();
            this.resources.offer(resource);
        }
    }

    @Override
    public void release() {
        this.resources.clear();
    }

    @Override
    public int count() {
        return this.resources.size();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    protected abstract T createResource();
}

