/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.memory;

import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.spi.memory.Frame;

public class Partition {
    protected int size;
    private ConcurrentCyclicFIFO<Frame> heap = new ConcurrentCyclicFIFO();

    protected Partition(int size) {
        this.size = size;
    }

    protected Frame allocate() {
        Frame result = (Frame)this.heap.poll();
        if (result == null) {
            return new Frame(this, new byte[this.size]);
        }
        result.inPartition.set(false);
        return result;
    }

    protected void recycle(Frame frame) {
        if (frame.inPartition.getAndSet(true)) {
            return;
        }
        frame.setHeader(null);
        frame.setDuration(Long.MAX_VALUE);
        frame.setEOM(false);
        this.heap.offer((Object)frame);
    }
}

