/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.annotations.examples.sbb;

import javax.slee.ActivityContextInterface;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.SbbExt;
import org.mobicents.slee.annotations.CMPField;
import org.mobicents.slee.annotations.Sbb;
import org.mobicents.slee.annotations.SbbContextExtField;
import org.mobicents.slee.annotations.Service;
import org.mobicents.slee.annotations.ServiceStartedEventHandler;
import org.mobicents.slee.annotations.TimerEventHandler;
import org.mobicents.slee.annotations.TracerField;

@Service(name="ExampleSbb", vendor="javax.slee", version="1.0", rootSbb=SimpleExampleAnnotatedSbb.class)
@Sbb(name="ExampleSbb", vendor="javax.slee", version="1.0")
public abstract class SimpleExampleAnnotatedSbb
implements SbbExt {
    private static final long TIMER_DURATION = 1000L;
    @TracerField
    private Tracer tracer;
    @SbbContextExtField
    private SbbContextExt sbbContextExt;
    @CMPField
    private Long startTime;

    @ServiceStartedEventHandler
    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        this.tracer.info("service started");
        this.sbbContextExt.getTimerFacility().setTimer(aci, null, 1000L, new TimerOptions());
        this.startTime = System.currentTimeMillis();
    }

    @TimerEventHandler
    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        long delay = System.currentTimeMillis() - 1000L - this.startTime;
        this.tracer.info("timer expired, delay = " + delay + " ms.");
    }
}

