/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class ConfigProperties
implements Serializable,
Cloneable {
    private final HashMap properties = new HashMap();

    public ConfigProperties() {
    }

    public ConfigProperties(Property[] properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        for (int i = 0; i < properties.length; ++i) {
            this.addProperty(properties[i]);
        }
    }

    public Property[] getProperties() {
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    public Property getProperty(String name) {
        return (Property)this.properties.get(name);
    }

    public void addProperty(Property property) {
        if (property == null) {
            throw new NullPointerException("property is null");
        }
        if (this.properties.containsKey(property.getName())) {
            throw new IllegalArgumentException("A property with the name " + property.getName() + " is already present");
        }
        this.properties.put(property.getName(), property);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Iterator i = this.properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            buf.append('(').append(property.getName()).append(':').append(property.getType()).append('=').append(property.getValue()).append(')');
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    public Object clone() {
        ConfigProperties clone = new ConfigProperties();
        for (Property property : this.properties.values()) {
            clone.addProperty(new Property(property.getName(), property.getType(), property.getValue()));
        }
        return clone;
    }

    public static final class Property
    implements Serializable {
        private final String name;
        private final String type;
        private Object value;

        public Property(String name, String type, Object value) throws IllegalArgumentException {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            this.name = name;
            this.type = type;
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) throws IllegalArgumentException {
            if (value == null) {
                this.value = null;
                return;
            }
            if (!this.isAssignable(value.getClass(), this.type)) {
                throw new IllegalArgumentException("Value is of type " + value.getClass().getName() + ", required type is " + this.type);
            }
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property that = (Property)obj;
            return this.name.equals(that.name) && this.type.equals(that.type) && this.value == null ? that.value == null : this.value.equals(that.value);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Property[").append(this.name).append(':').append(this.type).append('=').append(this.value).append(']');
            return buf.toString();
        }

        public static Object toObject(String type, String value) throws IllegalArgumentException {
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            try {
                if (type.equals("java.lang.Integer")) {
                    return new Integer(value);
                }
                if (type.equals("java.lang.Long")) {
                    return new Long(value);
                }
                if (type.equals("java.lang.Double")) {
                    return new Double(value);
                }
                if (type.equals("java.lang.Float")) {
                    return new Float(value);
                }
                if (type.equals("java.lang.Short")) {
                    return new Short(value);
                }
                if (type.equals("java.lang.Byte")) {
                    return new Byte(value);
                }
                if (type.equals("java.lang.Character")) {
                    if (value.length() != 1) {
                        throw new IllegalArgumentException("Invalid value for java.lang.Character type: " + value);
                    }
                    return new Character(value.charAt(0));
                }
                if (type.equals("java.lang.Boolean")) {
                    if (value.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (value.equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                    throw new IllegalArgumentException("Invalid value for java.lang.Boolean type: " + value);
                }
                if (type.equals("java.lang.String")) {
                    return value;
                }
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid value for " + type + " type: " + value);
            }
        }

        private boolean isAssignable(Class c, String type) {
            if (c.getName().equals(type)) {
                return true;
            }
            ArrayList<Class> checked = new ArrayList<Class>();
            ArrayList toCheck = new ArrayList();
            toCheck.add(c);
            while (!toCheck.isEmpty()) {
                c = (Class)toCheck.remove(0);
                if (c.getName().equals(type)) {
                    return true;
                }
                if (!checked.add(c)) continue;
                Class superclass = c.getSuperclass();
                if (superclass != null && !superclass.equals(Object.class)) {
                    toCheck.add(superclass);
                }
                toCheck.addAll(Arrays.asList(c.getInterfaces()));
            }
            return false;
        }
    }
}

