/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.hssclient.example;

import java.io.IOException;
import java.util.Arrays;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.enabler.hssclient.HSSClientChildSbbLocalObject;
import org.mobicents.slee.enabler.hssclient.HSSClientParent;

public abstract class HSSClientParentSbb
implements Sbb,
HSSClientParent {
    private static Tracer tracer;
    private static final String PUBLIC_IDENTITY_PSI = "sip:alice@open-ims.test";
    private static final String PUBLIC_IDENTITY_IMS_USER_STATE = "sip:bob@open-ims.test";
    private static final String DESTINATION_HOST;
    private static final String DESTINATION_REALM = "open-ims.test";
    protected SbbContext sbbContext;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(HSSClientParentSbb.class.getSimpleName());
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public abstract void setNotifyCount(int var1);

    public abstract int getNotifyCount();

    public abstract ChildRelationExt getHSSClientChildSbbChildRelation();

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            HSSClientChildSbbLocalObject child = (HSSClientChildSbbLocalObject)this.getHSSClientChildSbbChildRelation().create("0");
            try {
                child.getPSIActivation(PUBLIC_IDENTITY_PSI, DESTINATION_REALM, DESTINATION_HOST);
                if (tracer.isInfoEnabled()) {
                    tracer.info("###### STEP 1 # Sent User-Data-Request to HSS for 'sip:alice@open-ims.test'");
                }
            }
            catch (IOException ioe) {
                tracer.severe("Unable to send UDR.", (Throwable)ioe);
            }
        }
        catch (CreateException ce) {
            tracer.severe("Failed to create Child Relation.", (Throwable)ce);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        ServiceActivity sa;
        if (tracer.isFineEnabled()) {
            tracer.fine("Received Activtiy End: " + aci.getActivity());
        }
        if (!(aci.getActivity() instanceof ServiceActivity) || (sa = (ServiceActivity)aci.getActivity()).getService().equals((Object)this.sbbContext.getService())) {
            // empty if block
        }
    }

    public void deliverRepositoryData(String publicIdentity, byte[][] serviceIndications, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Repository Data";
            String serviceIndicationsString = "";
            for (byte[] serviceIndication : serviceIndications) {
                serviceIndicationsString = serviceIndicationsString + new String(serviceIndication);
            }
            tracer.info(publicIdentity + "/" + serviceIndicationsString + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverIMSPublicIdentity(String publicIdentity, byte[] msisdn, int[] identitySets, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "IMS Public Identity";
            tracer.info((publicIdentity != null ? publicIdentity : new String(msisdn)) + "/" + Arrays.asList(new int[][]{identitySets}) + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverIMSUserState(String publicIdentity, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "IMS User State";
            tracer.info(publicIdentity + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverSCSCFName(String publicIdentity, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "S-CSCF Name";
            tracer.info(publicIdentity + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverInitialFilterCriteria(String publicIdentity, String serverName, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "S-CSCF Name";
            tracer.info(publicIdentity + "/" + serverName + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverLocationInformation(byte[] msisdn, int requestedDomain, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Location Information";
            tracer.info(new String(msisdn) + "/" + requestedDomain + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverUserState(byte[] msisdn, int requestedDomain, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "User State";
            tracer.info(new String(msisdn) + "/" + requestedDomain + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverChargingInformation(String publicIdentity, byte[] msisdn, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Charging Information";
            tracer.info((publicIdentity != null ? publicIdentity : new String(msisdn)) + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverMSISDN(String publicIdentity, byte[] msisdn, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "MSISDN";
            tracer.info((publicIdentity != null ? publicIdentity : new String(msisdn)) + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
    }

    public void deliverPSIActivation(String publicIdentity, long resultCode, String data) {
        if (tracer.isInfoEnabled()) {
            String dataType = "S-CSCF Name";
            tracer.info(publicIdentity + " '" + dataType + "' delivery: Result-Code = '" + resultCode + "'");
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("###### STEP 2 # Received User-Data-Answer from HSS for 'sip:alice@open-ims.test'");
        }
        HSSClientChildSbbLocalObject child = (HSSClientChildSbbLocalObject)this.getHSSClientChildSbbChildRelation().get("0");
        try {
            if (data.contains("<PSIActivation>0</PSIActivation>")) {
                if (tracer.isInfoEnabled()) {
                    tracer.info("###### STEP 3 # Setting PSI Activation from INACTIVE to ACTIVE in User-Data ...");
                }
                data = data.replaceAll("<PSIActivation>0</PSIActivation>", "<PSIActivation>1</PSIActivation>");
            } else {
                if (tracer.isInfoEnabled()) {
                    tracer.info("###### STEP 3 # Setting PSI Activation from ACTIVE to INACTIVE in User-Data ...");
                }
                data = data.replaceAll("<PSIActivation>1</PSIActivation>", "<PSIActivation>0</PSIActivation>");
            }
            child.updatePSIActivation(PUBLIC_IDENTITY_PSI, data, DESTINATION_REALM, DESTINATION_HOST);
            if (tracer.isInfoEnabled()) {
                tracer.info("###### STEP 4 # Sent Profile-Update-Request to HSS for 'sip:alice@open-ims.test'");
            }
        }
        catch (IOException ioe) {
            tracer.severe("Unable to send PUR.", (Throwable)ioe);
        }
    }

    public void updateRepositoryDataResponse(String publicIdentity, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Repository Data";
            tracer.info("Update to " + publicIdentity + "'s '" + dataType + "' response: Result-Code = '" + resultCode + "'");
        }
    }

    public void updatePSIActivationResponse(String publicIdentity, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "PSI Activation";
            tracer.info("Update to " + publicIdentity + "'s '" + dataType + "' response: Result-Code = '" + resultCode + "'");
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("###### STEP 5 # Received Profile-Update-Answer from HSS for 'sip:alice@open-ims.test'");
        }
        HSSClientChildSbbLocalObject child = (HSSClientChildSbbLocalObject)this.getHSSClientChildSbbChildRelation().get("0");
        try {
            if (tracer.isInfoEnabled()) {
                tracer.info("###### STEP 6 # Subscribing to IMS User State for 'sip:bob@open-ims.test'");
            }
            child.subscribeIMSUserState(PUBLIC_IDENTITY_IMS_USER_STATE, 0, DESTINATION_REALM, DESTINATION_HOST);
        }
        catch (IOException ioe) {
            tracer.severe("Unable to send SNR.", (Throwable)ioe);
        }
    }

    public void subscribeRepositoryDataResponse(String publicIdentity, byte[][] serviceIndications, int subscriptionRequestType, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Repository Data";
            String reqType = subscriptionRequestType == 0 ? "SUBSCRIBE" : "UNSUBSCRIBE";
            String serviceIndicationsString = "";
            for (byte[] serviceIndication : serviceIndications) {
                serviceIndicationsString = serviceIndicationsString + new String(serviceIndication);
            }
            tracer.info(publicIdentity + "/" + serviceIndicationsString + " answer to " + reqType + " '" + dataType + "': Result-Code = '" + resultCode + "'");
        }
    }

    public void subscribeIMSUserStateResponse(String publicIdentity, int subscriptionRequestType, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "User State";
            String reqType = subscriptionRequestType == 0 ? "SUBSCRIBE" : "UNSUBSCRIBE";
            tracer.info(publicIdentity + " answer to " + reqType + " '" + dataType + "': Result-Code = '" + resultCode + "'");
        }
        if (resultCode == 2001L) {
            if (tracer.isInfoEnabled()) {
                tracer.info("###### STEP 7 # Subscribed successfuly to IMS User State for 'sip:bob@open-ims.test'");
                tracer.info("###### STEP 8 # !USER ACTION NEEDED! Please change (register or unregister) the SIP client for 'sip:bob@open-ims.test'...");
            }
        } else {
            tracer.severe("Failed to Subscribe to User Profile/IMS User State for 'sip:bob@open-ims.test'.");
        }
    }

    public void subscribeSCSCFNameResponse(String publicIdentity, int subscriptionRequestType, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "S-CSCF Name";
            String reqType = subscriptionRequestType == 0 ? "SUBSCRIBE" : "UNSUBSCRIBE";
            tracer.info(publicIdentity + " answer to " + reqType + " '" + dataType + "': Result-Code = '" + resultCode + "'");
        }
    }

    public void subscribeInitialFilterCriteriaResponse(String publicIdentity, String serverName, int subscriptionRequestType, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "Initial Filter Criteria";
            String reqType = subscriptionRequestType == 0 ? "SUBSCRIBE" : "UNSUBSCRIBE";
            tracer.info(publicIdentity + "/" + serverName + " answer to " + reqType + " '" + dataType + "': Result-Code = '" + resultCode + "'");
        }
    }

    public void subscribePSIActivationResponse(String publicIdentity, int subscriptionRequestType, long resultCode) {
        if (tracer.isInfoEnabled()) {
            String dataType = "PSI Activation";
            String reqType = subscriptionRequestType == 0 ? "SUBSCRIBE" : "UNSUBSCRIBE";
            tracer.info(publicIdentity + " answer to " + reqType + " '" + dataType + "': Result-Code = '" + resultCode + "'");
        }
    }

    public void receivedProfileUpdate(String userIdentity, byte[] msisdn, String data, String originRealm, String originHost) {
        if (tracer.isInfoEnabled()) {
            tracer.info("Received updated User Profile for " + (userIdentity != null ? userIdentity : new String(msisdn)) + " from " + originRealm + "/" + originHost);
            if (data != null) {
                tracer.info("User-Data: " + data);
            }
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("###### STEP 9 # Received profile update for 'sip:bob@open-ims.test'. EXAMPLE COMPLETED SUCCESSFULY!");
        }
    }

    static {
        DESTINATION_HOST = null;
    }
}

