/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.hssclient;

import java.io.Serializable;
import net.java.slee.resource.diameter.sh.events.DiameterShMessage;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import net.java.slee.resource.diameter.sh.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.events.avp.IdentitySetType;
import net.java.slee.resource.diameter.sh.events.avp.RequestedDomainType;
import net.java.slee.resource.diameter.sh.events.avp.SubsReqType;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;

public class MessageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sessionId = null;
    private String publicIdentity = null;
    private String msisdn = null;
    private DataReferenceType dataReference;
    private DataReferenceType[] dataReferences;
    private byte[][] serviceIndications;
    private IdentitySetType[] identitySets;
    private String serverName;
    private RequestedDomainType requestedDomain;
    private SubsReqType subsReqType;

    public MessageData(DiameterShMessage message) {
        this.sessionId = message.getSessionId();
        if (message instanceof UserDataRequest) {
            UserDataRequest udr = (UserDataRequest)message;
            UserIdentityAvp uIdAvp = udr.getUserIdentity();
            this.publicIdentity = uIdAvp.getPublicIdentity();
            this.msisdn = uIdAvp.getMsisdn();
            this.dataReferences = udr.getDataReferences();
            this.serviceIndications = udr.getServiceIndications();
            this.identitySets = udr.getIdentitySets();
            if (udr.hasServerName()) {
                this.serverName = udr.getServerName();
            }
            if (udr.hasRequestedDomain()) {
                this.requestedDomain = udr.getRequestedDomain();
            }
        } else if (message instanceof ProfileUpdateRequest) {
            ProfileUpdateRequest pur = (ProfileUpdateRequest)message;
            UserIdentityAvp uIdAvp = pur.getUserIdentity();
            this.publicIdentity = uIdAvp.getPublicIdentity();
            this.msisdn = uIdAvp.getMsisdn();
            this.dataReference = pur.getDataReference();
        } else if (message instanceof SubscribeNotificationsRequest) {
            SubscribeNotificationsRequest snr = (SubscribeNotificationsRequest)message;
            UserIdentityAvp uIdAvp = snr.getUserIdentity();
            this.publicIdentity = uIdAvp.getPublicIdentity();
            this.msisdn = uIdAvp.getMsisdn();
            if (snr.hasSubsReqType()) {
                this.subsReqType = snr.getSubsReqType();
            }
            this.dataReferences = snr.getDataReferences();
            this.serviceIndications = snr.getServiceIndications();
            if (snr.hasServerName()) {
                this.serverName = snr.getServerName();
            }
        } else if (message instanceof PushNotificationRequest) {
            PushNotificationRequest pnr = (PushNotificationRequest)message;
            UserIdentityAvp uIdAvp = pnr.getUserIdentity();
            this.publicIdentity = uIdAvp.getPublicIdentity();
            this.msisdn = uIdAvp.getMsisdn();
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPublicIdentity() {
        return this.publicIdentity;
    }

    public byte[] getMsisdn() {
        return this.msisdn != null ? this.msisdn.getBytes() : null;
    }

    public DataReferenceType getDataReference() {
        return this.dataReference;
    }

    public DataReferenceType[] getDataReferences() {
        return this.dataReferences;
    }

    public byte[][] getServiceIndications() {
        return this.serviceIndications;
    }

    public IdentitySetType[] getIdentitySets() {
        return this.identitySets;
    }

    public String getServerName() {
        return this.serverName;
    }

    public RequestedDomainType getRequestedDomain() {
        return this.requestedDomain;
    }

    public SubsReqType getSubsReqType() {
        return this.subsReqType;
    }
}

