/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.hssclient;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientProvider;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.events.DiameterShMessage;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataAnswer;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import net.java.slee.resource.diameter.sh.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.events.avp.IdentitySetType;
import net.java.slee.resource.diameter.sh.events.avp.RequestedDomainType;
import net.java.slee.resource.diameter.sh.events.avp.SubsReqType;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.enabler.hssclient.HSSClientChild;
import org.mobicents.slee.enabler.hssclient.HSSClientParentSbbLocalObject;
import org.mobicents.slee.enabler.hssclient.MessageData;
import org.mobicents.slee.enabler.hssclient.RequestMappingACI;

public abstract class HSSClientChildSbb
implements Sbb,
HSSClientChild {
    private static Tracer tracer;
    protected SbbContextExt sbbContext;
    protected ShClientProvider diameterShClientSbbInterface = null;
    protected ShClientActivityContextInterfaceFactory diameterShClientACIF = null;
    protected ShClientMessageFactory diameterShClientMessageFactory = null;
    protected DiameterShAvpFactory diameterShClientAvpFactory = null;

    public abstract RequestMappingACI asSbbActivityContextInterface(ActivityContextInterface var1);

    protected HSSClientParentSbbLocalObject getParent() {
        return (HSSClientParentSbbLocalObject)this.sbbContext.getSbbLocalObject().getParent();
    }

    @Override
    public String getRepositoryData(String publicIdentity, byte[][] serviceIndications, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.REPOSITORY_DATA);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setServiceIndications(serviceIndications);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getIMSPublicIdentity(String publicIdentity, byte[] msisdn, int[] identitySets, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, msisdn);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.IMS_PUBLIC_IDENTITY);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        IdentitySetType[] typeIdentitySets = new IdentitySetType[identitySets.length];
        for (int i = 0; i < identitySets.length; ++i) {
            typeIdentitySets[i] = IdentitySetType.fromInt((int)identitySets[i]);
        }
        udr.setIdentitySets(typeIdentitySets);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getIMSUserState(String publicIdentity, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.IMS_USER_STATE);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getSCSCFName(String publicIdentity, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.S_CSCFNAME);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getInitialFilterCriteria(String publicIdentity, String serverName, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.INITIAL_FILTER_CRITERIA);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setServerName(serverName);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getLocationInformation(byte[] msisdn, int requestedDomain, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(null, msisdn);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.LOCATION_INFORMATION);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setRequestedDomain(RequestedDomainType.fromInt((int)requestedDomain));
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getUserState(byte[] msisdn, int requestedDomain, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(null, msisdn);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.USER_STATE);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setRequestedDomain(RequestedDomainType.fromInt((int)requestedDomain));
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getChargingInformation(String publicIdentity, byte[] msisdn, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, msisdn);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.CHARGING_INFORMATION);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getMSISDN(String publicIdentity, byte[] msisdn, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, msisdn);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.MSISDN);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String getPSIActivation(String publicIdentity, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        UserDataRequest udr = this.diameterShClientMessageFactory.createUserDataRequest(publicIdentityAvp, DataReferenceType.PSI_ACTIVATION);
        udr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        udr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            udr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendUserDataRequest(udr);
        this.storeRequestInACI(activity, (DiameterShMessage)udr);
        return activity.getSessionId();
    }

    @Override
    public String updateRepositoryData(String publicIdentity, String data, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        ProfileUpdateRequest pur = this.diameterShClientMessageFactory.createProfileUpdateRequest(publicIdentityAvp, DataReferenceType.REPOSITORY_DATA, data.getBytes());
        pur.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        pur.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            pur.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendProfileUpdateRequest(pur);
        this.storeRequestInACI(activity, (DiameterShMessage)pur);
        return activity.getSessionId();
    }

    @Override
    public String updatePSIActivation(String publicIdentity, String data, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        ProfileUpdateRequest pur = this.diameterShClientMessageFactory.createProfileUpdateRequest(publicIdentityAvp, DataReferenceType.PSI_ACTIVATION, data.getBytes());
        pur.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        pur.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            pur.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendProfileUpdateRequest(pur);
        this.storeRequestInACI(activity, (DiameterShMessage)pur);
        return activity.getSessionId();
    }

    @Override
    public String subscribeRepositoryData(String publicIdentity, byte[][] serviceIndications, int subscriptionRequestType, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        SubscribeNotificationsRequest snr = this.diameterShClientMessageFactory.createSubscribeNotificationsRequest(publicIdentityAvp, DataReferenceType.REPOSITORY_DATA, SubsReqType.fromInt((int)subscriptionRequestType));
        snr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        snr.setServiceIndications(serviceIndications);
        snr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            snr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendSubscribeNotificationsRequest(snr);
        this.storeRequestInACI(activity, (DiameterShMessage)snr);
        return activity.getSessionId();
    }

    @Override
    public String subscribeIMSUserState(String publicIdentity, int subscriptionRequestType, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        SubscribeNotificationsRequest snr = this.diameterShClientMessageFactory.createSubscribeNotificationsRequest(publicIdentityAvp, DataReferenceType.IMS_USER_STATE, SubsReqType.fromInt((int)subscriptionRequestType));
        snr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        snr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            snr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendSubscribeNotificationsRequest(snr);
        this.storeRequestInACI(activity, (DiameterShMessage)snr);
        return activity.getSessionId();
    }

    @Override
    public String subscribeSCSCFName(String publicIdentity, int subscriptionRequestType, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        SubscribeNotificationsRequest snr = this.diameterShClientMessageFactory.createSubscribeNotificationsRequest(publicIdentityAvp, DataReferenceType.S_CSCFNAME, SubsReqType.fromInt((int)subscriptionRequestType));
        snr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        snr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            snr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendSubscribeNotificationsRequest(snr);
        this.storeRequestInACI(activity, (DiameterShMessage)snr);
        return activity.getSessionId();
    }

    @Override
    public String subscribeInitialFilterCriteria(String publicIdentity, String serverName, int subscriptionRequestType, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        SubscribeNotificationsRequest snr = this.diameterShClientMessageFactory.createSubscribeNotificationsRequest(publicIdentityAvp, DataReferenceType.INITIAL_FILTER_CRITERIA, SubsReqType.fromInt((int)subscriptionRequestType));
        snr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        snr.setServerName(serverName);
        snr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            snr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendSubscribeNotificationsRequest(snr);
        this.storeRequestInACI(activity, (DiameterShMessage)snr);
        return activity.getSessionId();
    }

    @Override
    public String subscribePSIActivation(String publicIdentity, int subscriptionRequestType, String destinationRealm, String destinationHost) throws IOException {
        UserIdentityAvp publicIdentityAvp = this.createUserIdentityAvp(publicIdentity, null);
        SubscribeNotificationsRequest snr = this.diameterShClientMessageFactory.createSubscribeNotificationsRequest(publicIdentityAvp, DataReferenceType.PSI_ACTIVATION, SubsReqType.fromInt((int)subscriptionRequestType));
        snr.setAuthSessionState(AuthSessionStateType.NO_STATE_MAINTAINED);
        snr.setDestinationRealm(new DiameterIdentity(destinationRealm));
        if (destinationHost != null) {
            snr.setDestinationHost(new DiameterIdentity(destinationHost));
        }
        ShClientActivity activity = this.getShClientActivity();
        activity.sendSubscribeNotificationsRequest(snr);
        this.storeRequestInACI(activity, (DiameterShMessage)snr);
        return activity.getSessionId();
    }

    private UserIdentityAvp createUserIdentityAvp(String publicIdentity, byte[] msisdn) {
        UserIdentityAvp userIdentityAvp = this.diameterShClientAvpFactory.createUserIdentity();
        if (publicIdentity != null) {
            userIdentityAvp.setPublicIdentity(publicIdentity);
        } else if (msisdn != null && msisdn.length > 0) {
            userIdentityAvp.setMsisdn(new String(msisdn));
        }
        return userIdentityAvp;
    }

    private String[] getUserIdentityValues(DiameterShMessage shMessage) {
        UserIdentityAvp uIdAvp = null;
        if (shMessage instanceof UserDataRequest) {
            uIdAvp = ((UserDataRequest)shMessage).getUserIdentity();
        } else if (shMessage instanceof ProfileUpdateRequest) {
            uIdAvp = ((ProfileUpdateRequest)shMessage).getUserIdentity();
        } else if (shMessage instanceof SubscribeNotificationsRequest) {
            uIdAvp = ((SubscribeNotificationsRequest)shMessage).getUserIdentity();
        } else if (shMessage instanceof PushNotificationRequest) {
            uIdAvp = ((PushNotificationRequest)shMessage).getUserIdentity();
        }
        String publicIdentity = null;
        String msisdn = null;
        if (uIdAvp != null) {
            publicIdentity = uIdAvp.getPublicIdentity();
            msisdn = uIdAvp.getMsisdn();
            if (publicIdentity == null && msisdn == null) {
                tracer.warning("Unable to retrieve Public User/Service Identity OR MSISDN. At least one of them should be present.");
            }
        } else {
            tracer.warning("User-Identity AVP missing in Diameter Sh Message.");
        }
        return new String[]{publicIdentity, msisdn};
    }

    private ShClientActivity getShClientActivity() throws IOException {
        try {
            ShClientActivity activity = this.diameterShClientSbbInterface.createShClientActivity();
            ActivityContextInterface aci = this.diameterShClientACIF.getActivityContextInterface(activity);
            aci.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            return activity;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void storeRequestInACI(ShClientActivity activity, DiameterShMessage message) {
        ActivityContextInterface aci = this.diameterShClientACIF.getActivityContextInterface(activity);
        RequestMappingACI rmACI = this.asSbbActivityContextInterface(aci);
        rmACI.setRequestData(new MessageData(message));
    }

    public void onSubscriptionNotificationsAnswer(SubscribeNotificationsAnswer event, RequestMappingACI aci) {
        MessageData snrData = aci.getRequestData();
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        SubsReqType subsReqType = snrData.getSubsReqType();
        long resultCode = event.getResultCode();
        DataReferenceType dataRef = snrData.getDataReferences()[0];
        switch (dataRef.getValue()) {
            case 0: {
                byte[][] serviceIndications = snrData.getServiceIndications();
                this.getParent().subscribeRepositoryDataResponse(snrData.getPublicIdentity(), serviceIndications, subsReqType.getValue(), resultCode);
                break;
            }
            case 11: {
                this.getParent().subscribeIMSUserStateResponse(snrData.getPublicIdentity(), subsReqType.getValue(), resultCode);
                break;
            }
            case 12: {
                this.getParent().subscribeSCSCFNameResponse(snrData.getPublicIdentity(), subsReqType.getValue(), resultCode);
                break;
            }
            case 13: {
                this.getParent().subscribeInitialFilterCriteriaResponse(snrData.getPublicIdentity(), snrData.getServerName(), subsReqType.getValue(), resultCode);
                break;
            }
            case 18: {
                this.getParent().subscribePSIActivationResponse(snrData.getPublicIdentity(), subsReqType.getValue(), resultCode);
                break;
            }
        }
    }

    public void onProfileUpdateAnswer(ProfileUpdateAnswer event, RequestMappingACI aci) {
        MessageData purData = aci.getRequestData();
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        DataReferenceType dataRef = purData.getDataReference();
        long resultCode = event.getResultCode();
        switch (dataRef.getValue()) {
            case 0: {
                this.getParent().updateRepositoryDataResponse(purData.getPublicIdentity(), resultCode);
                break;
            }
            case 18: {
                this.getParent().updatePSIActivationResponse(purData.getPublicIdentity(), resultCode);
                break;
            }
        }
    }

    public void onPushNotificationRequest(PushNotificationRequest event, RequestMappingACI aci) {
        try {
            ShClientSubscriptionActivity activity = (ShClientSubscriptionActivity)aci.getActivity();
            activity.sendPushNotificationAnswer(2001L, true);
        }
        catch (IOException e) {
            tracer.warning("Failed to send Push-Notification-Answer.", (Throwable)e);
        }
        String[] userIdentityValues = this.getUserIdentityValues((DiameterShMessage)event);
        String data = new String(event.getUserData());
        this.getParent().receivedProfileUpdate(userIdentityValues[0], userIdentityValues[1].getBytes(), data, event.getOriginRealm().toString(), event.getOriginHost().toString());
    }

    public void onUserDataAnswer(UserDataAnswer event, RequestMappingACI aci) {
        MessageData udrData = aci.getRequestData();
        String data = new String(event.getUserData());
        long resultCode = event.getResultCode();
        DataReferenceType dataRef = udrData.getDataReferences()[0];
        switch (dataRef.getValue()) {
            case 0: {
                this.getParent().deliverRepositoryData(udrData.getPublicIdentity(), udrData.getServiceIndications(), resultCode, data);
                break;
            }
            case 10: {
                IdentitySetType[] identitySets = udrData.getIdentitySets();
                int[] intIdentitySets = new int[identitySets.length];
                for (int i = 0; i < identitySets.length; ++i) {
                    intIdentitySets[i] = identitySets[i].getValue();
                }
                this.getParent().deliverIMSPublicIdentity(udrData.getPublicIdentity(), udrData.getMsisdn(), intIdentitySets, resultCode, data);
                break;
            }
            case 11: {
                this.getParent().deliverIMSUserState(udrData.getPublicIdentity(), resultCode, data);
                break;
            }
            case 12: {
                this.getParent().deliverSCSCFName(udrData.getPublicIdentity(), resultCode, data);
                break;
            }
            case 13: {
                this.getParent().deliverInitialFilterCriteria(udrData.getPublicIdentity(), udrData.getServerName(), resultCode, data);
                break;
            }
            case 14: {
                RequestedDomainType requestedDomain = udrData.getRequestedDomain();
                this.getParent().deliverLocationInformation(udrData.getMsisdn(), requestedDomain != null ? Integer.valueOf(requestedDomain.getValue()) : null, resultCode, data);
                break;
            }
            case 15: {
                RequestedDomainType requestedDomain = udrData.getRequestedDomain();
                this.getParent().deliverUserState(udrData.getMsisdn(), requestedDomain != null ? Integer.valueOf(requestedDomain.getValue()) : null, resultCode, data);
                break;
            }
            case 16: {
                this.getParent().deliverChargingInformation(udrData.getPublicIdentity(), udrData.getMsisdn(), resultCode, data);
                break;
            }
            case 17: {
                this.getParent().deliverMSISDN(udrData.getPublicIdentity(), udrData.getMsisdn(), resultCode, data);
                break;
            }
            case 18: {
                this.getParent().deliverPSIActivation(udrData.getPublicIdentity(), resultCode, data);
                break;
            }
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(HSSClientChildSbb.class.getSimpleName());
        }
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.diameterShClientSbbInterface = (ShClientProvider)context.lookup("slee/resources/diameter-sh-client-ra-interface");
            this.diameterShClientACIF = (ShClientActivityContextInterfaceFactory)context.lookup("slee/resources/JDiameterShClientResourceAdaptor/java.net/0.8.1/acif");
            this.diameterShClientMessageFactory = this.diameterShClientSbbInterface.getClientMessageFactory();
            this.diameterShClientAvpFactory = this.diameterShClientSbbInterface.getClientAvpFactory();
        }
        catch (NamingException e) {
            tracer.severe("Can't set sbb context.", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

