/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.sip;

import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.TimeoutEvent;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.SIPETagHeader;
import javax.sip.header.SIPIfMatchHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.slee.resource.ResourceAdaptorTypeID;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.ActivityContextInterfaceExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.SbbLocalObjectExt;
import org.mobicents.slee.enabler.sip.PostponedModifyPublicationRequest;
import org.mobicents.slee.enabler.sip.PostponedRemovePublicationRequest;
import org.mobicents.slee.enabler.sip.PostponedRequest;
import org.mobicents.slee.enabler.sip.PublicationClientChild;
import org.mobicents.slee.enabler.sip.PublicationClientChildSbbLocalObject;
import org.mobicents.slee.enabler.sip.PublicationClientParentSbbLocalObject;
import org.mobicents.slee.enabler.sip.PublishRequestType;

public abstract class PublicationClientChildSbb
implements Sbb,
PublicationClientChild {
    private static final int DEFAULT_EXPIRES_DRIFT = 15;
    private static final ResourceAdaptorTypeID sipResourceAdaptorTypeID = new ResourceAdaptorTypeID("JAIN SIP", "javax.sip", "1.2");
    private static final TimerOptions TIMER_OPTIONS = new TimerOptions();
    private static Tracer tracer;
    protected SbbContextExt sbbContext;
    protected SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory = null;
    protected SleeSipProvider sleeSipProvider = null;
    protected MessageFactory messageFactory;
    protected AddressFactory addressFactory;
    protected HeaderFactory headerFactory;
    protected Address ecsAddress;
    protected int expiresDrift = 15;

    protected PublicationClientParentSbbLocalObject getParent() {
        return (PublicationClientParentSbbLocalObject)this.sbbContext.getSbbLocalObject().getParent();
    }

    public String getEntity() {
        return this.getEntityCMP();
    }

    public String getETag() {
        return this.getETagCMP();
    }

    private boolean isBusy() {
        return this.getPublishRequestTypeCMP() != null;
    }

    public void newPublication(String entity, String eventPackage, String document, String contentType, String contentSubType, int expires) {
        SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject();
        try {
            Request r = this.createNewPublishRequest(entity, eventPackage, expires, contentType, contentSubType, document);
            ClientTransaction ctx = this.sleeSipProvider.getNewClientTransaction(r);
            ActivityContextInterface aci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(ctx);
            aci.attach((SbbLocalObject)sbbLocalObject);
            ctx.sendRequest();
            this.setPublishRequestTypeCMP(PublishRequestType.NEW);
            this.setEntityCMP(entity);
            this.setEventPackageCMP(eventPackage);
        }
        catch (Throwable e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to create publication", e);
            }
            this.getParent().newPublicationFailed(500, (PublicationClientChildSbbLocalObject)sbbLocalObject);
        }
    }

    public void modifyPublication(String document, String contentType, String contentSubType, int expires) {
        if (this.isBusy()) {
            this.setPostponedRequestCMP(new PostponedModifyPublicationRequest(document, contentType, contentSubType, expires));
            return;
        }
        this.cancelExpiresTimer(false);
        SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject();
        try {
            Request r = this.createUpdatePublishRequest(contentType, contentSubType, document);
            ClientTransaction ctx = this.sleeSipProvider.getNewClientTransaction(r);
            ActivityContextInterface aci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(ctx);
            aci.attach((SbbLocalObject)sbbLocalObject);
            ctx.sendRequest();
            this.setPublishRequestTypeCMP(PublishRequestType.UPDATE);
        }
        catch (Throwable e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to modify publication", e);
            }
            this.getParent().modifyPublicationFailed(500, (PublicationClientChildSbbLocalObject)sbbLocalObject);
        }
    }

    public void removePublication() {
        if (this.isBusy()) {
            this.setPostponedRequestCMP(new PostponedRemovePublicationRequest());
            return;
        }
        this.cancelExpiresTimer(true);
        SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject();
        try {
            Request r = this.createRemovePublishRequest();
            ClientTransaction ctx = this.sleeSipProvider.getNewClientTransaction(r);
            ActivityContextInterface aci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(ctx);
            aci.attach((SbbLocalObject)sbbLocalObject);
            ctx.sendRequest();
            this.setPublishRequestTypeCMP(PublishRequestType.REMOVE);
        }
        catch (Throwable e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to remove publication", e);
            }
            this.getParent().removePublicationFailed(500, (PublicationClientChildSbbLocalObject)sbbLocalObject);
        }
    }

    public abstract void setEntityCMP(String var1);

    public abstract String getEntityCMP();

    public abstract void setEventPackageCMP(String var1);

    public abstract String getEventPackageCMP();

    public abstract void setExpiresCMP(int var1);

    public abstract int getExpiresCMP();

    public abstract void setETagCMP(String var1);

    public abstract String getETagCMP();

    public abstract void setPostponedRequestCMP(PostponedRequest var1);

    public abstract PostponedRequest getPostponedRequestCMP();

    public abstract void setPublishRequestTypeCMP(PublishRequestType var1);

    public abstract PublishRequestType getPublishRequestTypeCMP();

    public void onSuccessRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        PostponedRequest postponedRequest;
        block12: {
            ExpiresHeader expiresHeader;
            PublishRequestType type;
            if (tracer.isFineEnabled()) {
                tracer.fine("Received 2xx (SUCCESS) response:\n" + event.getResponse());
            }
            SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject();
            aci.detach((SbbLocalObject)sbbLocalObject);
            Response response = event.getResponse();
            SIPETagHeader sipeTagHeader = (SIPETagHeader)response.getHeader("SIP-ETag");
            if (sipeTagHeader != null) {
                this.setETagCMP(sipeTagHeader.getETag());
            }
            if ((type = this.getPublishRequestTypeCMP()) != PublishRequestType.REMOVE && (expiresHeader = (ExpiresHeader)response.getHeader("Expires")) != null && expiresHeader.getExpires() != 0) {
                this.setExpiresCMP(expiresHeader.getExpires());
                this.startExpiresTimer();
            }
            postponedRequest = null;
            this.setPublishRequestTypeCMP(null);
            try {
                switch (type) {
                    case NEW: {
                        postponedRequest = this.getPostponedRequestCMP();
                        this.getParent().newPublicationSucceed((PublicationClientChildSbbLocalObject)sbbLocalObject);
                        break;
                    }
                    case REFRESH: {
                        postponedRequest = this.getPostponedRequestCMP();
                        break;
                    }
                    case UPDATE: {
                        postponedRequest = this.getPostponedRequestCMP();
                        this.getParent().modifyPublicationSucceed((PublicationClientChildSbbLocalObject)sbbLocalObject);
                        break;
                    }
                    case REMOVE: {
                        this.getParent().removePublicationSucceed((PublicationClientChildSbbLocalObject)sbbLocalObject);
                    }
                }
            }
            catch (Exception e) {
                if (!tracer.isSevereEnabled()) break block12;
                tracer.severe("Exception in publication parent!", (Throwable)e);
            }
        }
        if (postponedRequest != null) {
            postponedRequest.resume(this);
        }
    }

    public void onClientErrorRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 4xx (CLIENT ERROR) response:\n" + event.getResponse());
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        Response response = event.getResponse();
        int statusCode = response.getStatusCode();
        if (statusCode == 423) {
            MinExpiresHeader minExpires = (MinExpiresHeader)response.getHeader("Min-Expires");
            PublishRequestType type = this.getPublishRequestTypeCMP();
            this.setPublishRequestTypeCMP(null);
            Request request = null;
            ContentTypeHeader cTypeHeader = null;
            switch (type) {
                case NEW: {
                    request = event.getClientTransaction().getRequest();
                    cTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
                    this.newPublication(this.getEntityCMP(), this.getEventPackageCMP(), (String)request.getContent(), cTypeHeader.getContentType(), cTypeHeader.getContentSubType(), minExpires.getExpires());
                    break;
                }
                case UPDATE: {
                    request = event.getClientTransaction().getRequest();
                    cTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
                    this.modifyPublication((String)request.getContent(), cTypeHeader.getContentType(), cTypeHeader.getContentSubType(), minExpires.getExpires());
                    break;
                }
                case REFRESH: {
                    this.setExpiresCMP(minExpires.getExpires());
                    this.doRefresh();
                    break;
                }
                case REMOVE: {
                    if (tracer.isSevereEnabled()) {
                        tracer.severe("Received 423 on REMOVE request!");
                    }
                    try {
                        this.getParent().removePublicationFailed(statusCode, (PublicationClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject());
                        break;
                    }
                    catch (Exception e) {
                        if (!tracer.isSevereEnabled()) break;
                        tracer.severe("Exception in publication parent!", (Throwable)e);
                    }
                }
            }
        } else {
            this.handleFailure(statusCode, aci);
        }
    }

    public void onServerErrorRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 5xx (SERVER ERROR) response:\n" + event.getResponse());
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        this.handleFailure(event.getResponse().getStatusCode(), aci);
    }

    public void onGlobalFailureRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 6xx (GLOBAL FAILURE) response:\n" + event.getResponse());
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        this.handleFailure(event.getResponse().getStatusCode(), aci);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        if (this.isBusy()) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Performing " + (Object)((Object)this.getPublishRequestTypeCMP()) + ", skipping refresh.");
            }
            return;
        }
        if (tracer.isFineEnabled()) {
            tracer.fine("Refreshing publication.");
        }
        this.doRefresh();
    }

    public void onTransactionTimeoutEvent(TimeoutEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received Tx Timeout");
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        this.handleFailure(504, aci);
    }

    private ActivityContextInterface getTimerACI() {
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            if (!(aci.getActivity() instanceof NullActivity)) continue;
            return aci;
        }
        return null;
    }

    private void startExpiresTimer() {
        long expires;
        ActivityContextInterface naAci = this.getTimerACI();
        if (naAci == null) {
            NullActivity na = this.sbbContext.getNullActivityFactory().createNullActivity();
            naAci = this.sbbContext.getNullActivityContextInterfaceFactory().getActivityContextInterface(na);
            naAci.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        if ((expires = (long)this.getExpiresCMP()) - (long)this.expiresDrift > 0L) {
            expires -= (long)this.expiresDrift;
        }
        this.sbbContext.getTimerFacility().setTimer(naAci, null, System.currentTimeMillis() + expires * 1000L, TIMER_OPTIONS);
    }

    private void cancelExpiresTimer(boolean detachActivity) {
        ActivityContextInterface naAci = this.getTimerACI();
        if (naAci != null) {
            ActivityContextInterfaceExt naAciExt = (ActivityContextInterfaceExt)naAci;
            TimerID[] timerIDs = naAciExt.getTimers();
            if (timerIDs.length > 0) {
                this.sbbContext.getTimerFacility().cancelTimer(timerIDs[0]);
            }
            if (detachActivity) {
                naAci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            }
        }
    }

    protected Request createPublishRequest(String entity) throws ParseException, TransportNotSupportedException, InvalidArgumentException {
        URI entityURI = this.addressFactory.createURI(entity);
        Address entityAddress = this.addressFactory.createAddress(entityURI);
        FromHeader fromHeader = this.headerFactory.createFromHeader(entityAddress, null);
        ToHeader toHeader = this.headerFactory.createToHeader(entityAddress, null);
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        viaHeaders.add(this.sleeSipProvider.getLocalVia("UDP", null));
        CallIdHeader callIdHeader = this.sleeSipProvider.getNewCallId();
        CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(1L, "PUBLISH");
        MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
        Request request = this.messageFactory.createRequest(entityURI, "PUBLISH", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        if (this.ecsAddress != null) {
            RouteHeader routeHeader = this.headerFactory.createRouteHeader(this.ecsAddress);
            request.addHeader((Header)routeHeader);
        }
        return request;
    }

    protected Request createNewPublishRequest(String entity, String eventPackage, int expires, String contentType, String contentSubType, String document) throws ParseException, TransportNotSupportedException, InvalidArgumentException {
        Request request = this.createPublishRequest(entity);
        if (this.getExpiresCMP() > 0) {
            ExpiresHeader expiresHeader = this.headerFactory.createExpiresHeader(expires);
            request.addHeader((Header)expiresHeader);
        }
        EventHeader eventHeader = this.headerFactory.createEventHeader(eventPackage);
        request.addHeader((Header)eventHeader);
        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader(contentType, contentSubType);
        request.setContent((Object)document, contentTypeHeader);
        return request;
    }

    protected Request createUpdatePublishRequest(String contentType, String contentSubType, String document) throws ParseException, TransportNotSupportedException, InvalidArgumentException {
        Request request = this.createPublishRequest(this.getEntity());
        ExpiresHeader expiresHeader = this.headerFactory.createExpiresHeader(this.getExpiresCMP());
        request.addHeader((Header)expiresHeader);
        SIPIfMatchHeader sipIfMatch = this.headerFactory.createSIPIfMatchHeader(this.getETagCMP());
        request.addHeader((Header)sipIfMatch);
        EventHeader eventHeader = this.headerFactory.createEventHeader(this.getEventPackageCMP());
        request.addHeader((Header)eventHeader);
        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader(contentType, contentSubType);
        request.setContent((Object)document, contentTypeHeader);
        return request;
    }

    protected Request createRemovePublishRequest() throws ParseException, TransportNotSupportedException, InvalidArgumentException {
        Request request = this.createPublishRequest(this.getEntity());
        ExpiresHeader expiresHeader = this.headerFactory.createExpiresHeader(0);
        request.addHeader((Header)expiresHeader);
        SIPIfMatchHeader sipIfMatch = this.headerFactory.createSIPIfMatchHeader(this.getETagCMP());
        request.addHeader((Header)sipIfMatch);
        EventHeader eventHeader = this.headerFactory.createEventHeader(this.getEventPackageCMP());
        request.addHeader((Header)eventHeader);
        return request;
    }

    protected Request createRefreshPublishRequest() throws ParseException, TransportNotSupportedException, InvalidArgumentException {
        Request request = this.createPublishRequest(this.getEntity());
        ExpiresHeader expiresHeader = this.headerFactory.createExpiresHeader(this.getExpiresCMP());
        request.addHeader((Header)expiresHeader);
        SIPIfMatchHeader sipIfMatch = this.headerFactory.createSIPIfMatchHeader(this.getETagCMP());
        request.addHeader((Header)sipIfMatch);
        EventHeader eventHeader = this.headerFactory.createEventHeader(this.getEventPackageCMP());
        request.addHeader((Header)eventHeader);
        return request;
    }

    protected void handleFailure(int statusCode, ActivityContextInterface ac) {
        PublishRequestType type = this.getPublishRequestTypeCMP();
        if (type != null) {
            this.setPublishRequestTypeCMP(null);
        }
        try {
            switch (type) {
                case NEW: {
                    this.getParent().newPublicationFailed(statusCode, (PublicationClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject());
                    break;
                }
                case REFRESH: {
                    this.getParent().refreshPublicationFailed(statusCode, (PublicationClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject());
                    break;
                }
                case UPDATE: {
                    this.getParent().modifyPublicationFailed(statusCode, (PublicationClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject());
                    break;
                }
                case REMOVE: {
                    this.getParent().removePublicationFailed(statusCode, (PublicationClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject());
                }
            }
        }
        catch (Exception e) {
            tracer.severe("Exception in publication parent!", (Throwable)e);
        }
    }

    protected void doRefresh() {
        SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject();
        try {
            Request r = this.createRefreshPublishRequest();
            ClientTransaction ctx = this.sleeSipProvider.getNewClientTransaction(r);
            ActivityContextInterface ctxAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(ctx);
            ctxAci.attach((SbbLocalObject)sbbLocalObject);
            ctx.sendRequest();
            this.setPublishRequestTypeCMP(PublishRequestType.REFRESH);
        }
        catch (Throwable e) {
            tracer.severe("Failed to refresh publication", e);
            this.getParent().refreshPublicationFailed(500, (PublicationClientChildSbbLocalObject)sbbLocalObject);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(PublicationClientChildSbb.class.getSimpleName());
        }
        try {
            InitialContext context;
            block15: {
                this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)this.sbbContext.getActivityContextInterfaceFactory(sipResourceAdaptorTypeID);
                this.sleeSipProvider = (SleeSipProvider)this.sbbContext.getResourceAdaptorInterface(sipResourceAdaptorTypeID, "SipRA");
                this.messageFactory = this.sleeSipProvider.getMessageFactory();
                this.addressFactory = this.sleeSipProvider.getAddressFactory();
                this.headerFactory = this.sleeSipProvider.getHeaderFactory();
                context = new InitialContext();
                try {
                    String serverAddress = (String)context.lookup("server.address");
                    if (serverAddress != null) {
                        this.ecsAddress = this.sleeSipProvider.getAddressFactory().createAddress(serverAddress);
                    }
                }
                catch (NamingException e) {
                    if (!tracer.isInfoEnabled()) break block15;
                    tracer.info("No ECS/PA address to use in Route header.");
                }
            }
            try {
                String expireTime = (String)context.lookup("expires.drift");
                if (expireTime != null) {
                    int intExpireTime = Integer.parseInt(expireTime);
                    if (intExpireTime < 0) {
                        if (tracer.isInfoEnabled()) {
                            tracer.info("Expire time drift less than zero, using default: " + this.expiresDrift + "s.");
                        }
                    } else {
                        this.expiresDrift = intExpireTime;
                        if (tracer.isInfoEnabled()) {
                            tracer.info("Expire time drift set to: " + this.expiresDrift + "s.");
                        }
                    }
                }
            }
            catch (NamingException e) {
                if (tracer.isInfoEnabled()) {
                    tracer.info("No Expire time drift, using default: " + this.expiresDrift + "s.");
                }
            }
        }
        catch (NamingException e) {
            tracer.severe("Can't set sbb context.", (Throwable)e);
        }
        catch (ParseException e) {
            tracer.severe("Can't set sbb context.", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

