/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.sip;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.mobicents.slee.enabler.sip.ContentType;
import org.mobicents.slee.enabler.sip.EventPackageParameter;

public class SubscriptionData
implements Externalizable {
    private static final EventPackageParameter[] EMPTY_EVENT_PARAMETERS = new EventPackageParameter[0];
    private static final ContentType[] EMPTY_ACCEPTED_CONTENT_TYPES = new ContentType[0];
    private String subscriberURI;
    private String subscriberDisplayName;
    private String notifierURI;
    private String eventPackage;
    private EventPackageParameter[] eventParameters = EMPTY_EVENT_PARAMETERS;
    private ContentType[] acceptedContentTypes = EMPTY_ACCEPTED_CONTENT_TYPES;
    private boolean supportResourceLists;
    private int expires = 3600;

    public String getSubscriberURI() {
        return this.subscriberURI;
    }

    public SubscriptionData setSubscriberURI(String subscriberURI) {
        this.subscriberURI = subscriberURI;
        return this;
    }

    public String getSubscriberDisplayName() {
        return this.subscriberDisplayName;
    }

    public SubscriptionData setSubscriberDisplayName(String subscriberDisplayName) {
        this.subscriberDisplayName = subscriberDisplayName;
        return this;
    }

    public String getNotifierURI() {
        return this.notifierURI;
    }

    public SubscriptionData setNotifierURI(String notifierURI) {
        this.notifierURI = notifierURI;
        return this;
    }

    public String getEventPackage() {
        return this.eventPackage;
    }

    public SubscriptionData setEventPackage(String eventPackage) {
        this.eventPackage = eventPackage;
        return this;
    }

    public EventPackageParameter[] getEventParameters() {
        return this.eventParameters;
    }

    public SubscriptionData setEventParameters(EventPackageParameter[] eventParameters) {
        if (eventParameters == null) {
            throw new NullPointerException("null event parameters");
        }
        this.eventParameters = eventParameters;
        return this;
    }

    public ContentType[] getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    public SubscriptionData setAcceptedContentTypes(ContentType[] acceptedContentTypes) {
        if (this.eventParameters == null) {
            throw new NullPointerException("null accepted content types");
        }
        this.acceptedContentTypes = acceptedContentTypes;
        return this;
    }

    public boolean isSupportResourceLists() {
        return this.supportResourceLists;
    }

    public SubscriptionData setSupportResourceLists(boolean supportResourceLists) {
        this.supportResourceLists = supportResourceLists;
        return this;
    }

    public int getExpires() {
        return this.expires;
    }

    public SubscriptionData setExpires(int expires) {
        this.expires = expires;
        return this;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.subscriberURI);
        out.writeUTF(this.notifierURI);
        out.writeUTF(this.eventPackage);
        out.writeBoolean(this.supportResourceLists);
        out.writeInt(this.eventParameters.length);
        for (EventPackageParameter eventPackageParameter : this.eventParameters) {
            out.writeObject(eventPackageParameter);
        }
        out.writeInt(this.acceptedContentTypes.length);
        for (Externalizable externalizable : this.acceptedContentTypes) {
            out.writeObject(externalizable);
        }
        if (this.subscriberDisplayName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subscriberDisplayName);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.expires);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int acceptedContentTypesLenght;
        this.subscriberURI = in.readUTF();
        this.notifierURI = in.readUTF();
        this.eventPackage = in.readUTF();
        this.supportResourceLists = in.readBoolean();
        int eventParametersLenght = in.readInt();
        if (eventParametersLenght > 0) {
            this.eventParameters = new EventPackageParameter[eventParametersLenght];
            for (int i = 0; i < eventParametersLenght; ++i) {
                this.eventParameters[i] = (EventPackageParameter)in.readObject();
            }
        }
        if ((acceptedContentTypesLenght = in.readInt()) > 0) {
            this.acceptedContentTypes = new ContentType[acceptedContentTypesLenght];
            for (int i = 0; i < acceptedContentTypesLenght; ++i) {
                this.acceptedContentTypes[i] = (ContentType)in.readObject();
            }
        }
        if (in.readBoolean()) {
            this.subscriberDisplayName = in.readUTF();
        }
        this.expires = in.readInt();
    }
}

