/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.sip;

import java.io.Externalizable;
import java.text.ParseException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.DialogForkedEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.ActivityContextInterfaceExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.SbbLocalObjectExt;
import org.mobicents.slee.enabler.sip.ContentType;
import org.mobicents.slee.enabler.sip.EventPackageParameter;
import org.mobicents.slee.enabler.sip.Notify;
import org.mobicents.slee.enabler.sip.SubscribeRequestType;
import org.mobicents.slee.enabler.sip.SubscriptionClientChild;
import org.mobicents.slee.enabler.sip.SubscriptionClientChildSbbLocalObject;
import org.mobicents.slee.enabler.sip.SubscriptionClientParentSbbLocalObject;
import org.mobicents.slee.enabler.sip.SubscriptionData;
import org.mobicents.slee.enabler.sip.SubscriptionException;
import org.mobicents.slee.enabler.sip.SubscriptionRequestContent;
import org.mobicents.slee.enabler.sip.SubscriptionStatus;
import org.mobicents.slee.enabler.sip.TerminationReason;

public abstract class SubscriptionClientChildSbb
implements Sbb,
SubscriptionClientChild {
    private static final int DEFAULT_EXPIRES_DRIFT = 15;
    private static final ResourceAdaptorTypeID sipResourceAdaptorTypeID = new ResourceAdaptorTypeID("JAIN SIP", "javax.sip", "1.2");
    private static final TimerOptions TIMER_OPTIONS = new TimerOptions();
    private static Tracer tracer;
    protected SbbContextExt sbbContext;
    protected SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory = null;
    protected SleeSipProvider sleeSipProvider = null;
    protected MessageFactory messageFactory;
    protected AddressFactory addressFactory;
    protected HeaderFactory headerFactory;
    protected int expiresDrift = 15;
    protected Address ecsAddress;

    public SubscriptionData getSubscriptionData() {
        return this.getSubscriptionDataCMP();
    }

    public void subscribe(SubscriptionData subscriptionData) throws SubscriptionException {
        this.subscribe(subscriptionData, null);
    }

    public void subscribe(SubscriptionData subscriptionData, SubscriptionRequestContent initialSubscribeContent) throws SubscriptionException {
        if (this.getSubscriptionData() != null) {
            throw new IllegalStateException("Active subscription found for: " + this.getSubscriptionData());
        }
        if (subscriptionData == null) {
            throw new IllegalArgumentException("subscriptionData argument must not be null!");
        }
        if (subscriptionData.getEventPackage() == null || subscriptionData.getNotifierURI() == null || subscriptionData.getSubscriberURI() == null) {
            throw new IllegalArgumentException("subscriptionData argument must contain a non null subscriber, notifier and event package.");
        }
        this.setSubscriptionDataCMP(subscriptionData);
        ActivityContextInterface aci = null;
        try {
            Address from = this.addressFactory.createAddress(subscriptionData.getSubscriberURI());
            if (subscriptionData.getSubscriberDisplayName() != null) {
                from.setDisplayName(subscriptionData.getSubscriberDisplayName());
            }
            Address to = this.addressFactory.createAddress(subscriptionData.getNotifierURI());
            DialogActivity dialogActivity = this.sleeSipProvider.getNewDialog(from, to);
            Request subscribeRequest = this.createInitialSubscribe(dialogActivity, subscriptionData, initialSubscribeContent);
            aci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialogActivity);
            this.setSubscribeRequestTypeCMP(SubscribeRequestType.NEW);
            aci.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            dialogActivity.sendRequest(subscribeRequest);
        }
        catch (TransactionUnavailableException e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to create client transaction", (Throwable)e);
            }
            throw new SubscriptionException("Failed to create client transaction", e);
        }
        catch (Exception e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to create dialog or send SUBSRIBE", (Throwable)e);
            }
            if (aci != null) {
                aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
                ((DialogActivity)aci.getActivity()).delete();
            }
            throw new SubscriptionException("Failed to create dialog or send SUBSRIBE", e);
        }
    }

    public void unsubscribe() throws SubscriptionException {
        if (this.getSubscribeRequestTypeCMP() != null) {
            throw new SubscriptionException("Enabler is " + (Object)((Object)this.getSubscribeRequestTypeCMP()) + ", cannot unsubscribe.");
        }
        try {
            ActivityContextInterface aci = this.sbbContext.getActivities()[0];
            this.cancelExpiresTimer(aci);
            DialogActivity da = (DialogActivity)aci.getActivity();
            Request unsubscribeRequest = this.createUnSubscribe(da);
            this.setSubscribeRequestTypeCMP(SubscribeRequestType.REMOVE);
            da.sendRequest(unsubscribeRequest);
        }
        catch (Exception e) {
            if (tracer.isSevereEnabled()) {
                tracer.severe("Failed to send unsubscribe", (Throwable)e);
            }
            this.setSubscribeRequestTypeCMP(null);
            throw new SubscriptionException("Failed to send unSUBSRIBE", e);
        }
    }

    public abstract SubscriptionData getSubscriptionDataCMP();

    public abstract void setSubscriptionDataCMP(SubscriptionData var1);

    public abstract SubscribeRequestType getSubscribeRequestTypeCMP();

    public abstract void setSubscribeRequestTypeCMP(SubscribeRequestType var1);

    public void onRedirRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 3xx (REDIRECT) response:\n" + event.getResponse());
        }
        this.handleFailure(event.getResponse().getStatusCode(), ac);
    }

    public void onClientErrorRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 4xx (CLIENT ERROR) response:\n" + event.getResponse());
        }
        this.handleFailure(event.getResponse().getStatusCode(), ac);
    }

    public void onServerErrorRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 5xx (SERVER ERROR) response:\n" + event.getResponse());
        }
        this.handleFailure(event.getResponse().getStatusCode(), ac);
    }

    public void onGlobalFailureRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received 6xx (GLOBAL FAILURE) response:\n" + event.getResponse());
        }
        this.handleFailure(event.getResponse().getStatusCode(), ac);
    }

    public void onNotify(RequestEvent event, ActivityContextInterface aci) {
        block24: {
            SubscriptionStatus state;
            Notify notify;
            block25: {
                if (tracer.isFineEnabled()) {
                    tracer.fine("Received Notify, on activity: " + aci.getActivity() + "\nRequest:\n" + event.getRequest());
                }
                Request request = event.getRequest();
                SubscriptionData subscriptionData = this.getSubscriptionDataCMP();
                EventHeader eventHeader = (EventHeader)request.getHeader("Event");
                if (eventHeader == null || !eventHeader.getEventType().equals(subscriptionData.getEventPackage())) {
                    block23: {
                        try {
                            Response badEventResponse = this.messageFactory.createResponse(489, request);
                            event.getServerTransaction().sendResponse(badEventResponse);
                        }
                        catch (Exception e) {
                            if (!tracer.isSevereEnabled()) break block23;
                            tracer.severe("Failed to create 489 answer to NOTIFY", (Throwable)e);
                        }
                    }
                    return;
                }
                try {
                    Response okResponse = this.messageFactory.createResponse(200, request);
                    event.getServerTransaction().sendResponse(okResponse);
                }
                catch (Exception e) {
                    if (tracer.isSevereEnabled()) {
                        tracer.severe("Failed to create 200 answer to NOTIFY", (Throwable)e);
                    }
                    return;
                }
                notify = new Notify();
                notify.setSubscriber(subscriptionData.getSubscriberURI());
                ContentTypeHeader contentType = (ContentTypeHeader)request.getHeader("Content-Type");
                if (contentType != null) {
                    notify.setContentType(contentType.getContentType());
                    notify.setContentSubType(contentType.getContentSubType());
                    notify.setContent(new String(request.getRawContent()));
                }
                notify.setNotifier(subscriptionData.getNotifierURI());
                SubscriptionStateHeader subscriptionStateHeader = (SubscriptionStateHeader)request.getHeader("Subscription-State");
                state = SubscriptionStatus.fromString(subscriptionStateHeader.getState());
                notify.setStatus(state);
                block3 : switch (state) {
                    case active: 
                    case pending: {
                        if (subscriptionStateHeader.getExpires() == -1) break;
                        notify.setExpires(subscriptionStateHeader.getExpires());
                        SubscribeRequestType subscribeRequestType = this.getSubscribeRequestTypeCMP();
                        if (subscribeRequestType != SubscribeRequestType.NEW && subscribeRequestType != SubscribeRequestType.REFRESH) break;
                        this.startExpiresTimer(aci, subscriptionStateHeader.getExpires());
                        this.setSubscribeRequestTypeCMP(null);
                        break;
                    }
                    case waiting: {
                        break;
                    }
                    case extension: {
                        notify.setStatusExtension(subscriptionStateHeader.getState());
                    }
                    case terminated: {
                        String reasonString = subscriptionStateHeader.getReasonCode();
                        TerminationReason reason = TerminationReason.fromString(reasonString);
                        notify.setTerminationReason(reason);
                        if (reason == null) break;
                        switch (reason) {
                            case rejected: 
                            case noresource: 
                            case deactivated: 
                            case timeout: {
                                break block3;
                            }
                            case probation: 
                            case giveup: {
                                if (subscriptionStateHeader.getRetryAfter() != -1) {
                                    notify.setRetryAfter(subscriptionStateHeader.getRetryAfter());
                                    break block3;
                                }
                                break block25;
                            }
                            case extension: {
                                notify.setTerminationReasonExtension(reasonString);
                            }
                        }
                    }
                }
            }
            try {
                SbbLocalObjectExt sbbLocalObjectExt = this.sbbContext.getSbbLocalObject();
                if (state == SubscriptionStatus.terminated) {
                    this.cancelExpiresTimer(aci);
                    aci.detach((SbbLocalObject)sbbLocalObjectExt);
                    event.getDialog().delete();
                }
                ((SubscriptionClientParentSbbLocalObject)sbbLocalObjectExt.getParent()).onNotify(notify, (SubscriptionClientChildSbbLocalObject)sbbLocalObjectExt);
            }
            catch (Exception e) {
                if (!tracer.isSevereEnabled()) break block24;
                tracer.severe("Received exception from parent on notify callback", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDialogForked(DialogForkedEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("Received fork, on activity: " + aci.getActivity() + "\nResponse:\n" + event.getResponse());
        }
        Response response = event.getResponse();
        int responseCode = response.getStatusCode();
        DialogActivity forkedDialog = (DialogActivity)event.getForkedDialog();
        if (responseCode >= 200 && responseCode < 300) {
            try {
                Request unSubscribe = this.createUnSubscribe(forkedDialog);
                forkedDialog.sendRequest(unSubscribe);
            }
            catch (Exception e) {
                if (tracer.isSevereEnabled()) {
                    tracer.severe("Failed to send unSUBSCRIBE for forked dialog.", (Throwable)e);
                }
            }
            finally {
                forkedDialog.delete();
            }
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        block3: {
            if (this.getSubscribeRequestTypeCMP() != null) {
                return;
            }
            try {
                DialogActivity da = (DialogActivity)aci.getActivity();
                Request refreshSubscribe = this.createRefresh(da, this.getSubscriptionData());
                this.setSubscribeRequestTypeCMP(SubscribeRequestType.REFRESH);
                da.sendRequest(refreshSubscribe);
            }
            catch (Exception e) {
                if (!tracer.isSevereEnabled()) break block3;
                tracer.severe("Failed to send unSUBSCRIBE for forked dialog.", (Throwable)e);
            }
        }
    }

    public void onTransactionTimeoutEvent(TimeoutEvent event, ActivityContextInterface ac) {
        this.handleFailure(504, ac);
    }

    protected void handleFailure(int errorCode, ActivityContextInterface ac) {
        SubscribeRequestType type = this.getSubscribeRequestTypeCMP();
        this.setSubscribeRequestTypeCMP(null);
        DialogActivity dialogActivity = (DialogActivity)ac.getActivity();
        if (dialogActivity != null) {
            ac.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            this.cancelExpiresTimer(ac);
            dialogActivity.delete();
        }
        SubscriptionClientChildSbbLocalObject sbbLocalObject = (SubscriptionClientChildSbbLocalObject)this.sbbContext.getSbbLocalObject();
        switch (type) {
            case NEW: {
                try {
                    ((SubscriptionClientParentSbbLocalObject)sbbLocalObject.getParent()).subscribeFailed(errorCode, sbbLocalObject);
                }
                catch (Exception e) {
                    if (!tracer.isSevereEnabled()) break;
                    tracer.severe("Received exception from parent on subscribe callback", (Throwable)e);
                }
                break;
            }
            case REFRESH: {
                try {
                    ((SubscriptionClientParentSbbLocalObject)sbbLocalObject.getParent()).resubscribeFailed(errorCode, sbbLocalObject);
                }
                catch (Exception e) {
                    if (!tracer.isSevereEnabled()) break;
                    tracer.severe("Received exception from parent on subscribe callback", (Throwable)e);
                }
                break;
            }
            case REMOVE: {
                try {
                    ((SubscriptionClientParentSbbLocalObject)sbbLocalObject.getParent()).unsubscribeFailed(errorCode, sbbLocalObject);
                    break;
                }
                catch (Exception e) {
                    if (!tracer.isSevereEnabled()) break;
                    tracer.severe("Received exception from parent on subscribe callback", (Throwable)e);
                }
            }
        }
    }

    protected Request createInitialSubscribe(DialogActivity da, SubscriptionData subscriptionData, SubscriptionRequestContent subscriptionContent) throws ParseException, InvalidArgumentException, SipException {
        Request request = da.createRequest("SUBSCRIBE");
        SipURI contactURI = this.sleeSipProvider.getLocalSipURI(this.sleeSipProvider.getListeningPoints()[0].getTransport());
        Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
        ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
        request.setHeader((Header)contactHeader);
        this.fillSubscribeRequest(request, subscriptionData);
        ExpiresHeader expiresHeader = this.headerFactory.createExpiresHeader(subscriptionData.getExpires());
        request.addHeader((Header)expiresHeader);
        if (this.ecsAddress != null) {
            RouteHeader routeHeader = this.headerFactory.createRouteHeader(this.ecsAddress);
            request.addHeader((Header)routeHeader);
        }
        if (subscriptionContent != null) {
            ContentTypeHeader cth = this.headerFactory.createContentTypeHeader(subscriptionContent.getContentType().getType(), subscriptionContent.getContentType().getSubType());
            request.setContent((Object)subscriptionContent.getContent().getBytes(), cth);
        }
        return request;
    }

    protected Request createUnSubscribe(DialogActivity da) throws SipException, InvalidArgumentException, ParseException {
        Request request = da.createRequest("SUBSCRIBE");
        this.fillSubscribeRequest(request, this.getSubscriptionData());
        request.setExpires(this.headerFactory.createExpiresHeader(0));
        return request;
    }

    protected Request createRefresh(DialogActivity da, SubscriptionData subscriptionData) throws SipException, InvalidArgumentException, ParseException {
        Request request = da.createRequest("SUBSCRIBE");
        this.fillSubscribeRequest(request, subscriptionData);
        request.setExpires(this.headerFactory.createExpiresHeader(subscriptionData.getExpires()));
        return request;
    }

    private void fillSubscribeRequest(Request request, SubscriptionData subscriptionData) throws ParseException {
        EventHeader eventHeader = this.headerFactory.createEventHeader(subscriptionData.getEventPackage());
        if (subscriptionData.getEventParameters() != null) {
            for (Externalizable externalizable : subscriptionData.getEventParameters()) {
                eventHeader.setParameter(((EventPackageParameter)externalizable).getName(), ((EventPackageParameter)externalizable).getValue());
            }
        }
        request.addHeader((Header)eventHeader);
        if (subscriptionData.getAcceptedContentTypes() != null) {
            for (Externalizable externalizable : subscriptionData.getAcceptedContentTypes()) {
                request.addHeader((Header)this.headerFactory.createAcceptHeader(((ContentType)externalizable).getType(), ((ContentType)externalizable).getSubType()));
            }
        }
        if (subscriptionData.isSupportResourceLists()) {
            request.addHeader((Header)this.headerFactory.createAcceptHeader("application", "rlmi+xml"));
            request.addHeader((Header)this.headerFactory.createAcceptHeader("multipart", "related"));
            request.addHeader((Header)this.headerFactory.createSupportedHeader("eventlist"));
        }
    }

    private void startExpiresTimer(ActivityContextInterface aci, int expires) {
        if (expires - this.expiresDrift > 0) {
            expires -= this.expiresDrift;
        }
        this.sbbContext.getTimerFacility().setTimer(aci, null, System.currentTimeMillis() + (long)(expires * 1000), TIMER_OPTIONS);
    }

    private void cancelExpiresTimer(ActivityContextInterface aci) {
        ActivityContextInterfaceExt aciExt = (ActivityContextInterfaceExt)aci;
        TimerID[] timerIDs = aciExt.getTimers();
        if (timerIDs.length > 0) {
            this.sbbContext.getTimerFacility().cancelTimer(timerIDs[0]);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(SubscriptionClientChildSbb.class.getSimpleName());
        }
        try {
            InitialContext context;
            block15: {
                this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)this.sbbContext.getActivityContextInterfaceFactory(sipResourceAdaptorTypeID);
                this.sleeSipProvider = (SleeSipProvider)this.sbbContext.getResourceAdaptorInterface(sipResourceAdaptorTypeID, "SipRA");
                this.messageFactory = this.sleeSipProvider.getMessageFactory();
                this.addressFactory = this.sleeSipProvider.getAddressFactory();
                this.headerFactory = this.sleeSipProvider.getHeaderFactory();
                context = new InitialContext();
                try {
                    String serverAddress = (String)context.lookup("server.address");
                    if (serverAddress != null) {
                        this.ecsAddress = this.sleeSipProvider.getAddressFactory().createAddress(serverAddress);
                    }
                }
                catch (NamingException e) {
                    if (!tracer.isInfoEnabled()) break block15;
                    tracer.info("No ECS/PA address to use in Route header.");
                }
            }
            try {
                String expireTime = (String)context.lookup("expires.drift");
                if (expireTime != null) {
                    int intExpireTime = Integer.parseInt(expireTime);
                    if (intExpireTime < 0) {
                        if (tracer.isInfoEnabled()) {
                            tracer.info("Expire time drift less than zero, using default: " + this.expiresDrift + "s.");
                        }
                    } else {
                        this.expiresDrift = intExpireTime;
                        if (tracer.isInfoEnabled()) {
                            tracer.info("Expire time drift set to: " + this.expiresDrift + "s.");
                        }
                    }
                }
            }
            catch (NamingException e) {
                if (tracer.isInfoEnabled()) {
                    tracer.info("No Expire time drift, using default: " + this.expiresDrift + "s.");
                }
            }
        }
        catch (NamingException e) {
            tracer.severe("Can't set sbb context.", (Throwable)e);
        }
        catch (ParseException e) {
            tracer.severe("Can't set sbb context.", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

