/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.EventTypeID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.SleeManagementMBean;
import javax.slee.management.SleeState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.container.management.jmx.ActivityManagementMBeanImplMBean;
import org.mobicents.slee.container.management.jmx.CongestionControlConfigurationMBean;
import org.mobicents.slee.container.management.jmx.EventRouterConfigurationMBean;
import org.mobicents.slee.container.management.jmx.EventRouterStatisticsMBean;
import org.mobicents.slee.container.management.jmx.JmxActivityContextHandle;
import org.mobicents.slee.container.management.jmx.MobicentsManagementMBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.utils.JainSleeServerUtils;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainSleeServerComponent
implements JainSleeServerUtils,
MeasurementFacet,
OperationFacet,
CreateChildResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    volatile MBeanServerUtils mBeanServerUtils = null;
    private volatile SleeState sleeState = SleeState.STOPPED;
    private ResourceContext resourceContext;
    private String deployFolder;
    private String farmDeployFolder;
    private String logFilePath;
    private String logConfigurationsFolder;

    @Override
    public MBeanServerUtils getMBeanServerUtils() {
        return this.mBeanServerUtils;
    }

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + resourceContext + ") called."));
        }
        this.resourceContext = resourceContext;
        this.deployFolder = resourceContext.getPluginConfiguration().getSimple("serverHomeDir").getStringValue() + File.separator + "deploy";
        this.farmDeployFolder = resourceContext.getPluginConfiguration().getSimple("serverHomeDir").getStringValue() + File.separator + "farm";
        this.logFilePath = resourceContext.getPluginConfiguration().getSimple("serverHomeDir").getStringValue() + File.separator + "conf" + File.separator + "jboss-log4j.xml";
        this.logConfigurationsFolder = this.deployFolder + File.separator + "mobicents-slee" + File.separator + "log4j-templates";
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        String namingURL = pluginConfig.getSimple("namingURL").getStringValue();
        String principal = pluginConfig.getSimple("principal").getStringValue();
        String credentials = pluginConfig.getSimple("credentials").getStringValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Started JAIN SLEE Server Component @ " + namingURL + ", " + principal + "/" + credentials));
        }
        this.mBeanServerUtils = new MBeanServerUtils(namingURL, principal, credentials);
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        if (this.mBeanServerUtils != null) {
            try {
                ObjectName sleemanagement = new ObjectName("javax.slee.management:name=SleeManagement");
                MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
                this.mBeanServerUtils.login();
                this.sleeState = (SleeState)connection.getAttribute(sleemanagement, "State");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("JAIN SLEE State = " + this.sleeState));
                }
                AvailabilityType availabilityType = AvailabilityType.UP;
                return availabilityType;
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to obtain JAIN SLEE Server state.", (Throwable)e);
                AvailabilityType availabilityType = AvailabilityType.DOWN;
                return availabilityType;
            }
            finally {
                block14: {
                    try {
                        this.mBeanServerUtils.logout();
                    }
                    catch (LoginException e) {
                        if (!this.log.isDebugEnabled()) break block14;
                        this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                    }
                }
            }
        }
        this.log.error((Object)"Returning availability as DOWN");
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getValues(" + report + "," + metrics + ") called."));
        }
        for (MeasurementScheduleRequest request : metrics) {
            EventRouterStatisticsMBean erStatsMBean;
            if (request.getName().equals("state")) {
                report.addData(new MeasurementDataTrait(request, this.sleeState.toString()));
                continue;
            }
            if (request.getName().equals("activitiesMapped")) {
                erStatsMBean = this.getEventRouterStatisticsMBean();
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStatsMBean.getActivitiesMapped())));
                continue;
            }
            if (request.getName().equals("averageEventRoutingTime")) {
                erStatsMBean = this.getEventRouterStatisticsMBean();
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStatsMBean.getAverageEventRoutingTime())));
                continue;
            }
            if (request.getName().equals("executedTasks")) {
                erStatsMBean = this.getEventRouterStatisticsMBean();
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStatsMBean.getExecutedTasks())));
                continue;
            }
            if (!request.getName().equals("miscTasksExecuted")) continue;
            erStatsMBean = this.getEventRouterStatisticsMBean();
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStatsMBean.getMiscTasksExecuted())));
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invokeOperation(" + name + ", " + parameters + ") called."));
        }
        if ("sleeState".equals(name)) {
            return this.doSleeState(parameters);
        }
        if ("listActivityContexts".equals(name)) {
            return this.doListActivityContexts(parameters);
        }
        if ("queryActivityContextLiveness".equals(name)) {
            return this.doQueryActivityContextLiveness(parameters);
        }
        if ("switchLoggingConfiguration".equals(name)) {
            return this.doSwitchLoggingConfiguration(parameters);
        }
        if ("getLoggingConfiguration".equals(name)) {
            return this.doGetLoggingConfiguration(parameters);
        }
        if ("setLoggingConfiguration".equals(name)) {
            return this.doSetLoggingConfiguration(parameters);
        }
        if ("viewEventRouterStatistics".equals(name)) {
            return this.doViewEventRouterStatistics(parameters);
        }
        if ("ccSetMemOn".equals(name)) {
            return this.doManageCongestionControl(0, parameters);
        }
        if ("ccSetMemOff".equals(name)) {
            return this.doManageCongestionControl(1, parameters);
        }
        if ("ccSetCheckPeriod".equals(name)) {
            return this.doManageCongestionControl(2, parameters);
        }
        if ("ccSetRefuseStartActivity".equals(name)) {
            return this.doManageCongestionControl(3, parameters);
        }
        if ("ccSetRefuseFireEvent".equals(name)) {
            return this.doManageCongestionControl(4, parameters);
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OperationResult doManageCongestionControl(int op, Configuration parameters) throws Exception {
        OperationResult result = new OperationResult();
        MBeanServerUtils mbeanUtils = this.getMBeanServerUtils();
        try {
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName ccConfigObjectName = new ObjectName("org.mobicents.slee:name=CongestionControlConfiguration");
            CongestionControlConfigurationMBean ccConfigMBean = MBeanServerInvocationHandler.newProxyInstance(connection, ccConfigObjectName, CongestionControlConfigurationMBean.class, false);
            switch (op) {
                case 0: {
                    int oldValue = ccConfigMBean.getMinFreeMemoryToTurnOn();
                    int newValue = parameters.getSimple("value").getIntegerValue();
                    if (oldValue != newValue) {
                        ccConfigMBean.setMinFreeMemoryToTurnOn(newValue);
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Operation completed successfully (value changed from '" + oldValue + "' to '" + newValue + "').")));
                        return result;
                    } else {
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Operation completed successfully (value wasn't changed, it was equal to the current)."));
                        return result;
                    }
                }
                case 1: {
                    int oldValue = ccConfigMBean.getMinFreeMemoryToTurnOff();
                    int newValue = parameters.getSimple("value").getIntegerValue();
                    if (oldValue != newValue) {
                        ccConfigMBean.setMinFreeMemoryToTurnOff(newValue);
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Operation completed successfully (value changed from '" + oldValue + "' to '" + newValue + "').")));
                        return result;
                    } else {
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Operation completed successfully (value wasn't changed, it was equal to the current)."));
                        return result;
                    }
                }
                case 2: {
                    int oldValue = ccConfigMBean.getPeriodBetweenChecks();
                    int newValue = parameters.getSimple("value").getIntegerValue();
                    if (oldValue != newValue) {
                        ccConfigMBean.setPeriodBetweenChecks(newValue);
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Operation completed successfully (value changed from '" + oldValue + "' to '" + newValue + "').")));
                        return result;
                    } else {
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Operation completed successfully (value wasn't changed, it was equal to the current)."));
                        return result;
                    }
                }
                case 3: {
                    boolean oldValueBool = ccConfigMBean.isRefuseStartActivity();
                    boolean newValueBool = parameters.getSimple("value").getBooleanValue();
                    if (oldValueBool != newValueBool) {
                        ccConfigMBean.setRefuseStartActivity(newValueBool);
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Operation completed successfully (value changed from '" + oldValueBool + "' to '" + newValueBool + "').")));
                        return result;
                    } else {
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Operation completed successfully (value wasn't changed, it was equal to the current)."));
                        return result;
                    }
                }
                case 4: {
                    boolean oldValueBool = ccConfigMBean.isRefuseFireEvent();
                    boolean newValueBool = parameters.getSimple("value").getBooleanValue();
                    if (oldValueBool != newValueBool) {
                        ccConfigMBean.setRefuseFireEvent(newValueBool);
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Operation completed successfully (value changed from '" + oldValueBool + "' to '" + newValueBool + "').")));
                        return result;
                    } else {
                        result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Operation completed successfully (value wasn't changed, it was equal to the current)."));
                        return result;
                    }
                }
                default: {
                    result.setErrorMessage("Unknown operation in Congestion Control Management (" + op + ")");
                    return result;
                }
            }
        }
        finally {
            block24: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block24;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doViewEventRouterStatistics(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            PropertyList statistics = new PropertyList("statistics");
            result.getComplexResults().put((Property)statistics);
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            String filter = parameters.getSimple("filter").getStringValue();
            if (filter.equals("global")) {
                this.doGetERSGlobal(connection, statistics);
            } else if (filter.equals("executors")) {
                this.doGetERSExecutors(connection, statistics);
            } else if (filter.equals("eventTypes")) {
                this.doGetERSEventTypes(connection, statistics);
            } else if (filter.equals("executorsByEventTypes")) {
                this.doGetERSCombined(connection, statistics);
            } else {
                this.doGetERSGlobal(connection, statistics);
                this.doGetERSExecutors(connection, statistics);
                this.doGetERSEventTypes(connection, statistics);
                this.doGetERSCombined(connection, statistics);
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block15: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block15;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private void doGetERSGlobal(MBeanServerConnection connection, PropertyList statistics) throws Exception {
        EventRouterStatisticsMBean erStatsMBean = this.getEventRouterStatisticsMBean();
        Integer activitiesMapped = erStatsMBean.getActivitiesMapped();
        Long averageEventRoutingTime = erStatsMBean.getAverageEventRoutingTime();
        Long executedTasks = erStatsMBean.getExecutedTasks();
        Long miscTasksExecuted = erStatsMBean.getMiscTasksExecuted();
        PropertyMap query = new PropertyMap("EventRouterStatistics", new Property[]{new PropertySimple("id", (Object)"JAIN SLEE Container"), new PropertySimple("activitiesMapped", (Object)activitiesMapped), new PropertySimple("averageEventRoutingTime", (Object)averageEventRoutingTime), new PropertySimple("executedTasks", (Object)executedTasks), new PropertySimple("miscTasksExecuted", (Object)miscTasksExecuted)});
        statistics.add((Property)query);
    }

    private void doGetERSExecutors(MBeanServerConnection connection, PropertyList statistics) throws Exception {
        EventRouterConfigurationMBean erConfigMBean = this.getEventRouterConfigurationMBean();
        int numExecutors = erConfigMBean.getEventRouterThreads();
        EventRouterStatisticsMBean erStatsMBean = this.getEventRouterStatisticsMBean();
        for (int executorId = 0; executorId < numExecutors; ++executorId) {
            Integer activitiesMapped = erStatsMBean.getActivitiesMapped(executorId);
            Long averageEventRoutingTime = erStatsMBean.getAverageEventRoutingTime(executorId);
            Long executedTasks = erStatsMBean.getExecutedTasks(executorId);
            Long executingTime = erStatsMBean.getExecutingTime(executorId);
            Long idleTime = erStatsMBean.getIdleTime(executorId);
            Long miscTasksExecuted = erStatsMBean.getMiscTasksExecuted(executorId);
            PropertyMap query = new PropertyMap("EventRouterStatistics", new Property[]{new PropertySimple("id", (Object)("Executor #" + executorId)), new PropertySimple("activitiesMapped", (Object)activitiesMapped), new PropertySimple("averageEventRoutingTime", (Object)averageEventRoutingTime), new PropertySimple("executedTasks", (Object)executedTasks), new PropertySimple("executingTime", (Object)executingTime), new PropertySimple("idleTime", (Object)idleTime), new PropertySimple("miscTasksExecuted", (Object)miscTasksExecuted)});
            statistics.add((Property)query);
        }
    }

    private void doGetERSEventTypes(MBeanServerConnection connection, PropertyList statistics) throws Exception {
        ObjectName deploymentObjectName = new ObjectName("javax.slee.management:name=Deployment");
        DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, deploymentObjectName, DeploymentMBean.class, false);
        EventTypeID[] eventTypes = deploymentMBean.getEventTypes();
        EventRouterStatisticsMBean erStatsMBean = this.getEventRouterStatisticsMBean();
        for (EventTypeID eventType : eventTypes) {
            Long averageEventRoutingTime = erStatsMBean.getAverageEventRoutingTime(eventType);
            Long eventsRouted = erStatsMBean.getEventsRouted(eventType);
            PropertyMap query = new PropertyMap("EventRouterStatistics", new Property[]{new PropertySimple("id", (Object)eventType.toString()), new PropertySimple("averageEventRoutingTime", (Object)averageEventRoutingTime), new PropertySimple("eventsRouted", (Object)eventsRouted)});
            statistics.add((Property)query);
        }
    }

    private void doGetERSCombined(MBeanServerConnection connection, PropertyList statistics) throws Exception {
        EventRouterConfigurationMBean erConfigMBean = this.getEventRouterConfigurationMBean();
        int numExecutors = erConfigMBean.getEventRouterThreads();
        ObjectName deploymentObjectName = new ObjectName("javax.slee.management:name=Deployment");
        DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, deploymentObjectName, DeploymentMBean.class, false);
        EventTypeID[] eventTypes = deploymentMBean.getEventTypes();
        EventRouterStatisticsMBean erStatsMBean = this.getEventRouterStatisticsMBean();
        for (EventTypeID eventType : eventTypes) {
            for (int executorId = 0; executorId < numExecutors; ++executorId) {
                Long averageEventRoutingTime = erStatsMBean.getAverageEventRoutingTime(executorId, eventType);
                Long eventsRouted = erStatsMBean.getEventsRouted(executorId, eventType);
                Long routingTime = erStatsMBean.getRoutingTime(executorId, eventType);
                PropertyMap query = new PropertyMap("EventRouterStatistics", new Property[]{new PropertySimple("id", (Object)(eventType.toString() + "@Executor #" + executorId)), new PropertySimple("averageEventRoutingTime", (Object)averageEventRoutingTime), new PropertySimple("routingTime", (Object)routingTime), new PropertySimple("eventsRouted", (Object)eventsRouted)});
                statistics.add((Property)query);
            }
        }
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        ResourceType resourceType = createResourceReport.getResourceType();
        if (resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT) {
            this.createContentBasedResource(createResourceReport, resourceType);
        }
        return createResourceReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContentBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("createContentBasedResource(" + createResourceReport + ", " + resourceType + ")"));
        }
        try {
            BufferedOutputStream os = null;
            ResourcePackageDetails details = createResourceReport.getPackageDetails();
            PackageDetailsKey key = details.getKey();
            String archiveName = key.getName();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createContentBasedResource: archiveName = " + archiveName));
            }
            Configuration deployTimeConfig = createResourceReport.getPackageDetails().getDeploymentTimeConfiguration();
            boolean persistentDeploy = deployTimeConfig.getSimple("persistentDeploy").getBooleanValue();
            boolean deployFarmed = deployTimeConfig.getSimple("deployFarmed").getBooleanValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createContentBasedResource: persistentDeploy = " + persistentDeploy + ", deployFarmed = " + deployFarmed));
            }
            if (deployFarmed) {
                if (!persistentDeploy) {
                    throw new IllegalArgumentException("Invalid options. If 'Deploy Farmed' is set to 'Yes', 'Persistent Deploy' should also be set to 'Yes'.");
                }
                if (!new File(this.farmDeployFolder).exists()) {
                    throw new IllegalArgumentException("Invalid options. 'Deploy Farmed' is set to 'Yes', but " + this.farmDeployFolder + " does not exist.");
                }
            }
            if (!archiveName.toLowerCase().endsWith(".jar")) {
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setErrorMessage("Deployed file must have a .jar extension");
                return;
            }
            Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
            PropertySimple propSimple = pluginConfiguration.getSimple("serverTmpDir");
            String tmpPath = propSimple.getStringValue();
            File serverTmpFile = new File(tmpPath);
            File tempDir = null;
            tempDir = JainSleeServerComponent.createTempDirectory("jopr-jainslee-deploy-content", null, serverTmpFile);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createContentBasedResource: tmpFile = " + tempDir.getAbsolutePath()));
            }
            File archiveFile = new File(key.getName());
            File contentCopy = new File(tempDir, archiveFile.getName());
            os = new BufferedOutputStream(new FileOutputStream(contentCopy));
            ContentContext contentContext = this.resourceContext.getContentContext();
            ContentServices contentServices = contentContext.getContentServices();
            contentServices.downloadPackageBitsForChildResource(contentContext, resourceType.getName(), key, (OutputStream)os);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createContentBasedResource: contentCopy = " + contentCopy.getAbsolutePath()));
            }
            ObjectName deploymentObjName = new ObjectName("javax.slee.management:name=Deployment");
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, deploymentObjName, DeploymentMBean.class, false);
            String depKey = null;
            if (!persistentDeploy) {
                DeployableUnitID deployableUnitID = deploymentMBean.install(contentCopy.toURI().toURL().toString());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("createContentBasedResource: Deployed " + deployableUnitID));
                }
                depKey = deployableUnitID.getURL();
            } else {
                File destination = new File((deployFarmed ? this.farmDeployFolder : this.deployFolder) + File.separator + archiveName);
                this.copyFile(contentCopy, destination);
                depKey = destination.toURI().toURL().toString();
            }
            String[] elements = depKey.split(System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\"));
            String lastElement = elements[elements.length - 1];
            String name = lastElement.substring(0, lastElement.lastIndexOf("."));
            createResourceReport.setResourceName(name);
            createResourceReport.setResourceKey(depKey);
            createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (Exception e) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage(e.getMessage());
            createResourceReport.setException((Throwable)e);
            return;
        }
        finally {
            block27: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block27;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private static File createTempDirectory(String prefix, String suffix, File parentDirectory) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, parentDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp directory named [" + tmpDir + "]");
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doSleeState(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            String message = null;
            String action = parameters.getSimple("action").getStringValue();
            ObjectName sleemanagement = new ObjectName("javax.slee.management:name=SleeManagement");
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            SleeManagementMBean sleeManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, sleemanagement, SleeManagementMBean.class, false);
            if ("start".equals(action)) {
                sleeManagementMBean.start();
                message = "Successfully started Mobicents JAIN SLEE Server";
            } else if ("stop".equals(action)) {
                sleeManagementMBean.stop();
                message = "Successfully stopped Mobicents JAIN SLEE Server";
            } else if ("shutdown".equals(action)) {
                sleeManagementMBean.shutdown();
                message = "Successfully shutdown Mobicents JAIN SLEE Server";
            }
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)message));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block12: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doQueryActivityContextLiveness(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:name=ActivityManagementMBean");
            ActivityManagementMBeanImplMBean aciManagMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, ActivityManagementMBeanImplMBean.class, false);
            aciManagMBean.queryActivityContextLiveness();
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)"Activity Context Liveness queried successfully."));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doSwitchLoggingConfiguration(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:service=MobicentsManagement");
            MobicentsManagementMBean mobicentsManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, MobicentsManagementMBean.class, false);
            String profile = parameters.getSimple("profile").getStringValue();
            mobicentsManagementMBean.switchLoggingConfiguration(profile);
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Log4j Configuration Profile successfully changed to " + profile + ".")));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doGetLoggingConfiguration(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:service=MobicentsManagement");
            MobicentsManagementMBean mobicentsManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, MobicentsManagementMBean.class, false);
            String profile = parameters.getSimple("profile").getStringValue();
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)mobicentsManagementMBean.getLoggingConfiguration(profile)));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doSetLoggingConfiguration(Configuration parameters) throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:service=MobicentsManagement");
            MobicentsManagementMBean mobicentsManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, MobicentsManagementMBean.class, false);
            String profile = parameters.getSimple("profile").getStringValue().toLowerCase();
            String contents = parameters.getSimple("contents").getStringValue();
            mobicentsManagementMBean.setLoggingConfiguration(profile, contents);
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)("Log4j " + profile + " Configuration successfully updated.")));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doListActivityContexts(Configuration paramteres) throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:name=ActivityManagementMBean");
            ActivityManagementMBeanImplMBean aciManagMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, ActivityManagementMBeanImplMBean.class, false);
            Object[] activities = aciManagMBean.listActivityContexts(true);
            PropertyList columnList = new PropertyList("result");
            if (activities != null) {
                for (Object obj : activities) {
                    Object[] tempObjects = (Object[])obj;
                    PropertyMap col = new PropertyMap("element");
                    Object tempObj = tempObjects[0];
                    PropertySimple activityHandle = new PropertySimple("ActivityHandle", tempObj != null ? (tempObj instanceof JmxActivityContextHandle ? ((JmxActivityContextHandle)tempObj).getActivityHandleToString() : tempObj) : "-");
                    col.put((Property)activityHandle);
                    col.put((Property)new PropertySimple("Class", tempObjects[1]));
                    tempObj = tempObjects[2];
                    Date d = new Date(Long.parseLong((String)tempObj));
                    col.put((Property)new PropertySimple("LastAccessTime", (Object)d));
                    tempObj = tempObjects[3];
                    col.put((Property)new PropertySimple("ResourceAdaptor", tempObj == null ? "-" : tempObj));
                    tempObj = tempObjects[4];
                    String[] strArr = (String[])tempObj;
                    StringBuffer sb = new StringBuffer();
                    for (String s : strArr) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("SbbAttachmentValue", (Object)sb.toString()));
                    tempObj = tempObjects[5];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("NameBoundToValue", (Object)sb.toString()));
                    tempObj = tempObjects[6];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("TimerValue", (Object)sb.toString()));
                    tempObj = tempObjects[7];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("DataPropertyValue", (Object)sb.toString()));
                    columnList.add((Property)col);
                }
            }
            result.getComplexResults().put((Property)columnList);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block13: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destFile) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CopyFile : Source[" + sourceFile.getAbsolutePath() + "] Dest[" + destFile.getAbsolutePath() + "]"));
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public String getDeployFolderPath() {
        return this.deployFolder;
    }

    public String getFarmDeployFolderPath() {
        return this.farmDeployFolder;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getLogConfigurationsFolder() {
        return this.logConfigurationsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventRouterStatisticsMBean getEventRouterStatisticsMBean() throws Exception {
        try {
            EventRouterStatisticsMBean erStatsMBean;
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName erStatsObjectName = new ObjectName("org.mobicents.slee:name=EventRouterStatistics");
            EventRouterStatisticsMBean eventRouterStatisticsMBean = erStatsMBean = MBeanServerInvocationHandler.newProxyInstance(connection, erStatsObjectName, EventRouterStatisticsMBean.class, false);
            return eventRouterStatisticsMBean;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventRouterConfigurationMBean getEventRouterConfigurationMBean() throws Exception {
        try {
            EventRouterConfigurationMBean erConfigMBean;
            MBeanServerConnection connection = this.mBeanServerUtils.getConnection();
            this.mBeanServerUtils.login();
            ObjectName erConfigObjectName = new ObjectName("org.mobicents.slee:name=EventRouterConfiguration");
            EventRouterConfigurationMBean eventRouterConfigurationMBean = erConfigMBean = MBeanServerInvocationHandler.newProxyInstance(connection, erConfigObjectName, EventRouterConfigurationMBean.class, false);
            return eventRouterConfigurationMBean;
        }
        finally {
            block7: {
                try {
                    this.mBeanServerUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

