/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.adaptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.mobicents.slee.connector.adaptor.ManagedConnectionImpl;
import org.mobicents.slee.connector.adaptor.SleeConnectionFactoryImpl;
import org.mobicents.slee.connector.remote.RemoteSleeConnectionService;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private static Logger log = Logger.getLogger(ManagedConnectionFactoryImpl.class);
    private String sleeJndiName;
    private boolean refreshOnDisconnect = true;
    private RemoteSleeConnectionService rmiStub;
    private PrintWriter printWriter;

    public String getSleeJndiName() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"mcf.getSleeJndiName() called.");
        }
        return this.sleeJndiName;
    }

    public void setSleeJndiName(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("mcf.setSleeJndiName() called with " + name));
        }
        this.sleeJndiName = name;
    }

    public boolean isRefreshOnDisconnect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"mcf.isRefreshOnDisconnect() called.");
        }
        return this.refreshOnDisconnect;
    }

    public void setRefreshOnDisconnect(boolean refreshOnDisconnect) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("mcf.setRefreshOnDisconnect() called with " + refreshOnDisconnect));
        }
        this.refreshOnDisconnect = refreshOnDisconnect;
    }

    public ManagedConnectionFactoryImpl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating ManagedConnectionFactoryImpl instance");
        }
    }

    private synchronized boolean lookupRMIStub(boolean refresh) throws ResourceException {
        if (this.rmiStub == null || refresh) {
            try {
                InitialContext ctx = new InitialContext();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking up slee service with name " + this.sleeJndiName));
                }
                this.rmiStub = (RemoteSleeConnectionService)ctx.lookup(this.sleeJndiName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Success on RMI stub of RemoteSleeService lookup");
                }
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Failed to lookup Slee service in JNDI ");
                throw new ResourceException("Failed to lookup Slee service in JNDI ", (Throwable)e);
            }
        }
        return false;
    }

    RemoteSleeConnectionService getRemoteSleeConnectionService() throws ResourceException {
        if (this.rmiStub == null) {
            this.lookupRMIStub(false);
        }
        return this.rmiStub;
    }

    boolean refreshRemoteSleeConnectionService() throws ResourceException {
        if (this.refreshOnDisconnect) {
            return this.lookupRMIStub(true);
        }
        return false;
    }

    public Object createConnectionFactory() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createConnectionFactory() called");
        }
        throw new ResourceException("Mobicents SLEE resource adaptor only works in managed environment!");
    }

    public Object createConnectionFactory(ConnectionManager connectionMgr) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createConnectionFactory(ConnectionManager connectionMgr) called");
        }
        return new SleeConnectionFactoryImpl(connectionMgr, this);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createManagedConnection() called");
        }
        this.lookupRMIStub(false);
        return new ManagedConnectionImpl(this);
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"matchManagedConnections() called");
        }
        if (connections.isEmpty()) {
            return null;
        }
        return (ManagedConnection)connections.iterator().next();
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.printWriter = writer;
    }
}

