/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.adaptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.UnrecognizedEventException;
import javax.slee.connection.ExternalActivityHandle;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.mobicents.slee.connector.adaptor.ConnectionMetaDataImpl;
import org.mobicents.slee.connector.adaptor.ManagedConnectionFactoryImpl;
import org.mobicents.slee.connector.adaptor.SleeConnectionImpl;
import org.mobicents.slee.connector.remote.EventInvocation;
import org.mobicents.slee.connector.remote.RemoteEventWrapper;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction {
    private static Logger log = Logger.getLogger(ManagedConnectionImpl.class);
    private static ConnectionMetaDataImpl metaData = new ConnectionMetaDataImpl();
    private LinkedList<ConnectionEventListener> listeners = new LinkedList();
    private LinkedList<SleeConnectionImpl> connectionHandles = new LinkedList();
    private ArrayList<EventInvocation> eventQueue = new ArrayList();
    private boolean destroyed;
    private PrintWriter printWriter;
    private boolean inTransaction;
    private ManagedConnectionFactoryImpl parent;

    ManagedConnectionImpl(ManagedConnectionFactoryImpl managedConnectionFactoryImpl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating ManagedConnectionImpl");
        }
        this.parent = managedConnectionFactoryImpl;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addConnectionEventListener() called");
        }
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeConnectionEventListener() called");
        }
        this.listeners.remove(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"associateConnection() called");
        }
        SleeConnectionImpl conn = (SleeConnectionImpl)connection;
        conn.getManagedConnection().removeConnectionHandle(conn);
        this.connectionHandles.add(conn);
        conn.setManagedConnection(this);
    }

    public void cleanup() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleanUp() called on " + this));
        }
        for (SleeConnectionImpl handle : this.connectionHandles) {
            handle.invalidate();
        }
        this.connectionHandles.clear();
    }

    public void destroy() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy() called on " + this));
        }
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        this.destroyed = true;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getConnection() called on " + this));
        }
        if (this.destroyed) {
            throw new IllegalStateException("This ManagedConnection has already been destroyed!");
        }
        SleeConnectionImpl conn = new SleeConnectionImpl(this);
        this.connectionHandles.add(conn);
        return conn;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return metaData;
    }

    public XAResource getXAResource() throws ResourceException {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        log.debug((Object)"getLocalTransaction() called");
        return this;
    }

    public void setLogWriter(PrintWriter pw) throws ResourceException {
        this.printWriter = pw;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void begin() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"begin() called on local transaction");
        }
        if (this.inTransaction) {
            throw new ResourceException("begin() called on transaction already in progress");
        }
        if (this.eventQueue.size() != 0) {
            throw new IllegalStateException("begin() called on transaction but events already in queue!");
        }
        this.inTransaction = true;
    }

    public void commit() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"commit() called on local transaction");
        }
        if (!this.inTransaction) {
            throw new ResourceException("commit() called on transaction but transaction not started");
        }
        this.sendQueuedEvents();
        this.eventQueue.clear();
        this.inTransaction = false;
    }

    public void rollback() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"rollback() called on local transaction");
        }
        if (!this.inTransaction) {
            throw new ResourceException("rollback() called on transaction but transaction not started");
        }
        this.eventQueue.clear();
        this.inTransaction = false;
    }

    private void removeConnectionHandle(SleeConnectionImpl connectionHandle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeConnectionHandle() called");
        }
        this.connectionHandles.remove(connectionHandle);
    }

    private void sendNotification(ConnectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendNotification() called with " + event + " eventID = " + event.getId()));
        }
        block7: for (ConnectionEventListener listener : this.listeners) {
            switch (event.getId()) {
                case 1: {
                    listener.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    listener.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    listener.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    listener.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    listener.connectionErrorOccurred(event);
                    continue block7;
                }
            }
            throw new IllegalStateException("Invalid event id:" + event.getId());
        }
    }

    void handleClosed(SleeConnectionImpl handle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleClosed() called");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Attempt to close a handle on a destroyed connection!");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        this.sendNotification(event);
        this.connectionHandles.remove(handle);
    }

    void connectionError(SleeConnectionImpl handle, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"connectionError() called");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Attempt to signal a connection error on a destroyed connection!");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5);
        event.setConnectionHandle((Object)handle);
        this.sendNotification(event);
    }

    ExternalActivityHandle createActivityHandle() throws ResourceException {
        return this.createActivityHandle(true);
    }

    EventTypeID getEventTypeID(String name, String vendor, String version) throws ResourceException, UnrecognizedEventException {
        return this.getEventTypeID(name, vendor, version, true);
    }

    void fireEvent(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) throws ResourceException, NullPointerException, UnrecognizedEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fireEvent() called:" + event + "," + eventType + "," + activityHandle + "," + address));
        }
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        if (!this.inTransaction) {
            this.fireEventNow(event, eventType, activityHandle, address, true);
        } else {
            this.fireEventLater(event, eventType, activityHandle, address);
        }
    }

    private ExternalActivityHandle createActivityHandle(boolean mayRefresh) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createActivityHandle() called");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        try {
            return this.parent.getRemoteSleeConnectionService().createActivityHandle();
        }
        catch (ConnectException ce) {
            if (mayRefresh && this.parent.refreshRemoteSleeConnectionService()) {
                return this.createActivityHandle(false);
            }
            String s = "Failed to invoke createActivityHandle";
            log.error((Object)s, (Throwable)ce);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)ce);
            throw ex;
        }
        catch (RemoteException e) {
            String s = "Failed to invoke createActivityHandle";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private EventTypeID getEventTypeID(String name, String vendor, String version, boolean mayRefresh) throws ResourceException, UnrecognizedEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEventTypeID called:" + name + "," + vendor + "," + version));
        }
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        try {
            return this.parent.getRemoteSleeConnectionService().getEventTypeID(name, vendor, version);
        }
        catch (ConnectException ce) {
            if (mayRefresh && this.parent.refreshRemoteSleeConnectionService()) {
                return this.getEventTypeID(name, vendor, version, false);
            }
            String s = "Failed to invoke getEventTypeID";
            log.error((Object)s, (Throwable)ce);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)ce);
            throw ex;
        }
        catch (RemoteException e) {
            String s = "Failed to invoke getEventTypeID";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private void fireEventNow(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address, boolean mayRefresh) throws ResourceException, NullPointerException, UnrecognizedEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Firing single event on SLEE:" + event));
        }
        try {
            RemoteEventWrapper rew = new RemoteEventWrapper((Serializable)event);
            this.parent.getRemoteSleeConnectionService().fireEvent((Object)rew, eventType, activityHandle, address);
        }
        catch (ConnectException ce) {
            if (mayRefresh && this.parent.refreshRemoteSleeConnectionService()) {
                this.fireEventNow(event, eventType, activityHandle, address, false);
            }
            String s = "Failed to invoke fireEvent";
            log.error((Object)s, (Throwable)ce);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)ce);
            throw ex;
        }
        catch (RemoteException e) {
            String s = "Failed to invoke fireEvent";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            String s = "Failed to invoke serielize event";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private void fireEventLater(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding event to event queue");
        }
        EventInvocation ei = new EventInvocation(event, eventType, activityHandle, address);
        this.eventQueue.add(ei);
    }

    private void sendQueuedEvents() throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Firing queue of events on SLEE: " + this.eventQueue.size()));
        }
        try {
            for (EventInvocation ei : this.eventQueue) {
                this.fireEventNow(ei.event, ei.eventTypeId, ei.externalActivityHandle, ei.address, true);
            }
        }
        catch (NullPointerException e) {
            throw new ResourceException(e.getMessage(), (Throwable)e);
        }
        catch (UnrecognizedEventException e) {
            throw new ResourceException(e.getMessage(), (Throwable)e);
        }
    }
}

