/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.ServiceID;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.management.ServiceState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.container.management.jmx.SbbEntitiesMBeanImplMBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceComponent
implements ResourceComponent<JainSleeServerComponent>,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<JainSleeServerComponent> resourceContext;
    private ServiceID serviceId = null;
    private MBeanServerUtils mbeanUtils = null;
    private ObjectName servicemanagement;
    private ServiceState serviceState = ServiceState.INACTIVE;

    public void start(ResourceContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.servicemanagement = new ObjectName("javax.slee.management:name=ServiceManagement");
        this.mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        String name = this.resourceContext.getPluginConfiguration().getSimple("name").getStringValue();
        String version = this.resourceContext.getPluginConfiguration().getSimple("version").getStringValue();
        String vendor = this.resourceContext.getPluginConfiguration().getSimple("vendor").getStringValue();
        this.serviceId = new ServiceID(name, vendor, version);
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            this.serviceState = (ServiceState)connection.invoke(this.servicemanagement, "getState", new Object[]{this.serviceId}, new String[]{ServiceID.class.getName()});
        }
        catch (Exception e) {
            this.log.error((Object)("getAvailability failed for ServiceID = " + this.serviceId));
            this.serviceState = ServiceState.INACTIVE;
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getValues(" + report + "," + metrics + ") called."));
        }
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("state")) {
                report.addData(new MeasurementDataTrait(request, this.serviceState.toString()));
                continue;
            }
            if (!request.getName().equals("SbbEntitiesCount")) continue;
            try {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(this.getServiceSbbEntities().size())));
            }
            catch (Exception e) {
                this.log.error((Object)("getAvailability failed for Service = " + this.serviceId));
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(-1.0)));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invokeOperation(" + name + ", " + parameters + ") called."));
        }
        if ("changeServiceState".equals(name)) {
            return this.doChangeServiceState(parameters);
        }
        if ("retrieveSbbEntities".equals(name)) {
            return this.doRetrieveSbbEntities();
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doChangeServiceState(Configuration parameters) throws Exception {
        try {
            String message = null;
            String action = parameters.getSimple("action").getStringValue();
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ServiceManagementMBean serviceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.servicemanagement, ServiceManagementMBean.class, false);
            if ("activate".equals(action)) {
                serviceManagementMBean.activate(this.serviceId);
                message = "Successfully Activated Service " + this.serviceId;
                this.serviceState = ServiceState.ACTIVE;
            } else if ("deactivate".equals(action)) {
                serviceManagementMBean.deactivate(this.serviceId);
                message = "Successfully Deactivated Service " + this.serviceId;
                this.serviceState = ServiceState.INACTIVE;
            }
            OperationResult result = new OperationResult();
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)message));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block10: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private OperationResult doRetrieveSbbEntities() throws Exception {
        PropertyList columnList = new PropertyList("result");
        for (Object[] sbbEntity : this.getServiceSbbEntities()) {
            PropertyMap col = new PropertyMap("element");
            col.put((Property)new PropertySimple("SBB Entity Id", sbbEntity[0] == null ? "-" : sbbEntity[0]));
            col.put((Property)new PropertySimple("Parent SBB Entity Id", sbbEntity[1] == null ? "-" : sbbEntity[1]));
            col.put((Property)new PropertySimple("Priority", sbbEntity[4] == null ? "-" : sbbEntity[4]));
            col.put((Property)new PropertySimple("Attachment Count", sbbEntity[9] == null ? "-" : Integer.valueOf(((String[])sbbEntity[9]).length)));
            columnList.add((Property)col);
        }
        OperationResult result = new OperationResult();
        result.getComplexResults().put((Property)columnList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object[]> getServiceSbbEntities() throws Exception {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName sbbEntitiesMBeanObj = new ObjectName("org.mobicents.slee:name=SbbEntitiesMBean");
            SbbEntitiesMBeanImplMBean sbbEntititesMBean = MBeanServerInvocationHandler.newProxyInstance(connection, sbbEntitiesMBeanObj, SbbEntitiesMBeanImplMBean.class, false);
            Object[] objs = sbbEntititesMBean.retrieveAllSbbEntities();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (Object obj : objs) {
                Object[] sbbEntity = (Object[])obj;
                if (sbbEntity[7] == null || !sbbEntity[7].equals(this.serviceId)) continue;
                list.add(sbbEntity);
            }
            ArrayList<Object[]> arrayList = list;
            return arrayList;
        }
        finally {
            block8: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    public ServiceID getServiceID() {
        return this.serviceId;
    }

    public MBeanServerUtils getMBeanServerUtils() {
        return this.mbeanUtils;
    }
}

