/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee.jbossas5.util;

import java.io.File;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jslee.jbossas5.util.JmxInvokerServiceConfiguration;
import org.rhq.plugins.jslee.jbossas5.util.SecurityDomainInfo;

public class JBossASDiscoveryUtils {
    private static final Log LOG = LogFactory.getLog(JBossASDiscoveryUtils.class);

    @Nullable
    public static UserInfo getJmxInvokerUserInfo(File configDir) {
        File rolesPropsFile;
        String securityDomain = JBossASDiscoveryUtils.getJmxInvokerSecurityDomain(configDir);
        if (securityDomain == null) {
            LOG.debug((Object)"The JMX invoker service is not configured to require authentication.");
            return null;
        }
        LOG.debug((Object)("The JMX invoker service is configured to use the '" + securityDomain + "' security domain for authentication."));
        File usersPropsFile = new File(configDir, "conf/props/" + securityDomain + "-users.properties");
        if (!usersPropsFile.exists()) {
            LOG.debug((Object)("Could not find users configuration for security domain '" + securityDomain + "' - " + usersPropsFile + " does not exist."));
        }
        if (!(rolesPropsFile = new File(configDir, "conf/props/" + securityDomain + "-roles.properties")).exists()) {
            LOG.debug((Object)("Could not find roles configuration for security domain '" + securityDomain + "' - " + rolesPropsFile + " does not exist."));
        }
        if (usersPropsFile.exists() && rolesPropsFile.exists()) {
            try {
                SecurityDomainInfo securityDomainInfo = new SecurityDomainInfo(usersPropsFile, rolesPropsFile);
                Set<String> adminUsers = securityDomainInfo.getUsers("JBossAdmin");
                if (!adminUsers.isEmpty()) {
                    String adminUser = adminUsers.iterator().next();
                    String adminPassword = securityDomainInfo.getPassword(adminUser);
                    LOG.debug((Object)("Discovered principal (" + adminUser + ") and credentials for connecting to the JMX invoker service."));
                    return new UserInfo(adminUser, adminPassword);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Could not determine username and password of admin user - failed to parse users and/or roles configuration file.");
            }
        }
        return null;
    }

    @Nullable
    private static String getJmxInvokerSecurityDomain(File configDir) {
        File deployDir = new File(configDir, "deploy");
        File jmxInvokerServiceXmlFile = new File(deployDir, "jmx-invoker-service.xml");
        String securityDomain = null;
        try {
            JmxInvokerServiceConfiguration jmxInvokerConfig = new JmxInvokerServiceConfiguration(jmxInvokerServiceXmlFile);
            securityDomain = jmxInvokerConfig.getSecurityDomain();
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to read " + jmxInvokerServiceXmlFile + " - unable to determine if authentication is enabled on the JMX invoker. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
        return securityDomain;
    }

    private JBossASDiscoveryUtils() {
    }

    public static class UserInfo {
        private final String username;
        private final String password;

        public UserInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

