/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee.jbossas5.util;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JmxInvokerServiceConfiguration {
    private final Log log = LogFactory.getLog(this.getClass());
    private String source;
    private String securityDomain;

    public JmxInvokerServiceConfiguration(File jmxInvokerServiceXmlFile) throws Exception {
        this.source = jmxInvokerServiceXmlFile.getPath();
        DocumentBuilder docBuilder = this.getDocumentBuilder();
        Document doc = docBuilder.parse(jmxInvokerServiceXmlFile);
        this.parseDocument(doc);
    }

    public JmxInvokerServiceConfiguration(InputStream jmxInvokerServiceXmlInputStream) throws Exception {
        this.source = jmxInvokerServiceXmlInputStream.toString();
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.parse(jmxInvokerServiceXmlInputStream);
        this.parseDocument(doc);
    }

    @Nullable
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        return docBuilderFactory.newDocumentBuilder();
    }

    private void parseDocument(Document doc) throws Exception {
        String securityDomainJndiName;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Node invokerMBeanNode = (Node)xPath.evaluate("//server/mbean[@name = 'jboss.jmx:type=adaptor,name=Invoker']", doc, XPathConstants.NODE);
        if (invokerMBeanNode == null) {
            this.log.warn((Object)("'jboss.jmx:type=adaptor,name=Invoker' mbean not found while parsing '" + this.source + "'."));
            return;
        }
        Node invokeOperationNode = (Node)xPath.evaluate("xmbean/operation[name = 'invoke']", invokerMBeanNode, XPathConstants.NODE);
        if (invokeOperationNode == null) {
            this.log.warn((Object)("'invoke' operation not found for 'jboss.jmx:type=adaptor,name=Invoker' mbean while parsing '" + this.source + "'."));
            return;
        }
        Node interceptorsNode = (Node)xPath.evaluate("descriptors/interceptors", invokeOperationNode, XPathConstants.NODE);
        if (interceptorsNode == null) {
            this.log.debug((Object)("No interceptors are defined for 'invoke' operation for 'jboss.jmx:type=adaptor,name=Invoker' mbean while parsing '" + this.source + "'."));
            return;
        }
        Node authenticationInterceptorNode = (Node)xPath.evaluate("interceptor[@code = 'org.jboss.jmx.connector.invoker.AuthenticationInterceptor']", interceptorsNode, XPathConstants.NODE);
        if (authenticationInterceptorNode == null) {
            return;
        }
        try {
            securityDomainJndiName = xPath.evaluate("@securityDomain", authenticationInterceptorNode);
        }
        catch (XPathExpressionException e) {
            throw new Exception("'securityDomain' attribute not found on 'org.jboss.jmx.connector.invoker.AuthenticationInterceptor' interceptor while parsing '" + this.source + "'.");
        }
        this.securityDomain = securityDomainJndiName.replaceFirst("^java:/jaas/", "");
    }
}

