/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.management.DeploymentMBean;
import javax.slee.resource.ResourceAdaptorID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdaptorDiscoveryComponent
implements ResourceDiscoveryComponent<JainSleeServerComponent> {
    private final Log log = LogFactory.getLog(ResourceAdaptorDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ResourceAdapterDiscoveryComponent.discoverResources() called");
        }
        HashSet<DiscoveredResourceDetails> discoveredRAs = new HashSet<DiscoveredResourceDetails>();
        MBeanServerUtils mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            ResourceAdaptorID[] ras;
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName deploymentMBeanObj = new ObjectName("javax.slee.management:name=Deployment");
            DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, deploymentMBeanObj, DeploymentMBean.class, false);
            for (ResourceAdaptorID raID : ras = deploymentMBean.getResourceAdaptors()) {
                String key = raID.toString();
                String description = raID.toString();
                DiscoveredResourceDetails discoveredService = new DiscoveredResourceDetails(context.getResourceType(), key, raID.getName(), raID.getVersion(), description, null, null);
                discoveredService.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)raID.getName()));
                discoveredService.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)raID.getVersion()));
                discoveredService.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)raID.getVendor()));
                discoveredRAs.add(discoveredService);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredRAs.size() + " JAIN SLEE Resource Adaptor Components."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredRAs;
            return hashSet;
        }
        finally {
            block10: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

