/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee.utils;

import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.rhq.plugins.jslee.utils.jaas.JBossCallbackHandler;
import org.rhq.plugins.jslee.utils.jaas.JBossConfiguration;

public class MBeanServerUtils {
    private Properties prop = new Properties();
    private LoginContext loginContext;

    public MBeanServerUtils(String namingURL, String principal, String credentials) {
        this.prop.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        this.prop.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        this.prop.put("java.naming.provider.url", namingURL);
        if (principal != null) {
            this.prop.put("java.naming.security.principal", principal);
            this.prop.put("java.naming.security.credentials", credentials);
            JBossCallbackHandler jaasCallbackHandler = new JBossCallbackHandler(principal, "admin");
            JBossConfiguration jaasConfig = new JBossConfiguration();
            try {
                this.loginContext = new LoginContext("jboss", null, jaasCallbackHandler, jaasConfig);
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MBeanServerConnection getConnection() throws NamingException {
        InitialContext ctx = new InitialContext(this.prop);
        MBeanServerConnection server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
        return server;
    }

    public void login() throws LoginException {
        if (this.loginContext != null) {
            this.loginContext.login();
        }
    }

    public void logout() throws LoginException {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
    }
}

