/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee.jbossas5.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

public class JBossConfigurationUtility {
    public static URL makeURL(String urlSpec, @Nullable File baseDir) throws MalformedURLException {
        URL url;
        if (baseDir != null && !baseDir.isAbsolute()) {
            throw new IllegalArgumentException("Base dir is not an absolute path: " + baseDir);
        }
        urlSpec = urlSpec.trim();
        try {
            url = new URL(urlSpec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlSpec);
                if (!file.isAbsolute() && baseDir != null) {
                    file = new File(baseDir, urlSpec);
                }
                file = file.getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception e2) {
                throw new MalformedURLException(e2.toString());
            }
        }
        return url;
    }
}

