/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.ServiceID;
import javax.slee.management.ServiceState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDiscoveryComponent
implements ResourceDiscoveryComponent<JainSleeServerComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("discoverResources(" + context + ") called."));
        }
        HashSet<DiscoveredResourceDetails> discoveredServices = new HashSet<DiscoveredResourceDetails>();
        ObjectName servicemanagement = new ObjectName("javax.slee.management:name=ServiceManagement");
        MBeanServerUtils mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ServiceID[] activeServices = (ServiceID[])connection.invoke(servicemanagement, "getServices", new Object[]{ServiceState.ACTIVE}, new String[]{ServiceState.class.getName()});
            ServiceID[] inactiveServices = (ServiceID[])connection.invoke(servicemanagement, "getServices", new Object[]{ServiceState.INACTIVE}, new String[]{ServiceState.class.getName()});
            ServiceID[] stoppingServices = (ServiceID[])connection.invoke(servicemanagement, "getServices", new Object[]{ServiceState.STOPPING}, new String[]{ServiceState.class.getName()});
            this.addService(activeServices, discoveredServices, context.getResourceType());
            this.addService(inactiveServices, discoveredServices, context.getResourceType());
            this.addService(stoppingServices, discoveredServices, context.getResourceType());
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredServices.size() + " JAIN SLEE Service Components."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredServices;
            return hashSet;
        }
        finally {
            block9: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private void addService(ServiceID[] services, Set<DiscoveredResourceDetails> discoveredServices, ResourceType resourceType) {
        for (ServiceID serviceID : services) {
            String key = serviceID.toString();
            String description = serviceID.toString();
            DiscoveredResourceDetails discoveredService = new DiscoveredResourceDetails(resourceType, key, serviceID.getName(), serviceID.getVersion(), description, null, null);
            discoveredService.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)serviceID.getName()));
            discoveredService.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)serviceID.getVersion()));
            discoveredService.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)serviceID.getVendor()));
            discoveredServices.add(discoveredService);
        }
    }
}

