/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ServiceUsageMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.ServiceSbbComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceSbbUsageParameterSetComponent
implements ResourceComponent<ServiceSbbComponent>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<ServiceSbbComponent> resourceContext;
    String usageParameterSetName = null;
    private ServiceID serviceId = null;
    private SbbID sbbId = null;
    private MBeanServerUtils mbeanUtils = null;
    private boolean isUp = false;

    public void start(ResourceContext<ServiceSbbComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.log.info((Object)"start");
        this.resourceContext = context;
        this.mbeanUtils = ((ServiceSbbComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        String name = this.resourceContext.getPluginConfiguration().getSimple("name").getStringValue();
        String version = this.resourceContext.getPluginConfiguration().getSimple("version").getStringValue();
        String vendor = this.resourceContext.getPluginConfiguration().getSimple("vendor").getStringValue();
        this.sbbId = new SbbID(name, vendor, version);
        this.serviceId = ((ServiceSbbComponent)context.getParentResourceComponent()).getServiceID();
        this.usageParameterSetName = this.resourceContext.getPluginConfiguration().getSimple("usageParameterSet").getStringValue();
    }

    public void stop() {
        this.log.info((Object)"stop");
    }

    public AvailabilityType getAvailability() {
        this.log.info((Object)"getAvailability");
        this.isUp = true;
        return this.isUp ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.log.info((Object)"getValues");
        for (MeasurementScheduleRequest request : metrics) {
            if (!request.getName().equals("state")) continue;
            report.addData(new MeasurementDataTrait(request, this.isUp ? "UP" : "DOWN"));
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        this.log.info((Object)("SbbComponent.invokeOperation() with name = " + name));
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported.");
    }

    public MBeanServerUtils getMBeanServerUtils() {
        return this.mbeanUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        try {
            Configuration config = new Configuration();
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName serviceUsageON = new ObjectName("javax.slee.management.usage:type=ServiceUsage,serviceName=" + ObjectName.quote(this.serviceId.getName()) + ',' + "serviceVendor" + '=' + ObjectName.quote(this.serviceId.getVendor()) + ',' + "serviceVersion" + '=' + ObjectName.quote(this.serviceId.getVersion()));
            ServiceUsageMBean serviceUsageMBean = MBeanServerInvocationHandler.newProxyInstance(connection, serviceUsageON, ServiceUsageMBean.class, false);
            PropertyList columnList = new PropertyList("usageParameter");
            ObjectName sbbUsageON = null;
            sbbUsageON = this.usageParameterSetName != null && !this.usageParameterSetName.equals("<default>") ? serviceUsageMBean.getSbbUsageMBean(this.sbbId, this.usageParameterSetName) : serviceUsageMBean.getSbbUsageMBean(this.sbbId);
            MBeanInfo usageInfo = connection.getMBeanInfo(sbbUsageON);
            for (MBeanOperationInfo operation : usageInfo.getOperations()) {
                String opName = operation.getName();
                if (!opName.startsWith("get")) continue;
                PropertyMap col = new PropertyMap("usageParameterDefinition");
                col.put((Property)new PropertySimple("usageParameterName", (Object)opName.replaceFirst("get", "")));
                boolean isSampleType = operation.getReturnType().equals("javax.slee.usage.SampleStatistics");
                col.put((Property)new PropertySimple("usageParameterType", (Object)(isSampleType ? "Sample" : "Counter")));
                Object value = connection.invoke(sbbUsageON, opName, new Object[]{false}, new String[]{"boolean"});
                col.put((Property)new PropertySimple("usageParameterValue", value));
                columnList.add((Property)col);
            }
            config.put((Property)columnList);
            Configuration configuration = config;
            return configuration;
        }
        finally {
            block8: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName serviceUsageON = new ObjectName("javax.slee.management.usage:type=ServiceUsage,serviceName=" + ObjectName.quote(this.serviceId.getName()) + ',' + "serviceVendor" + '=' + ObjectName.quote(this.serviceId.getVendor()) + ',' + "serviceVersion" + '=' + ObjectName.quote(this.serviceId.getVersion()));
            ServiceUsageMBean serviceUsageMBean = MBeanServerInvocationHandler.newProxyInstance(connection, serviceUsageON, ServiceUsageMBean.class, false);
            PropertyList columnList = configurationUpdateReport.getConfiguration().getList("usageParameter");
            ObjectName sbbUsageON = serviceUsageMBean.getSbbUsageMBean(this.sbbId);
            for (Property p : columnList.getList()) {
                PropertyMap pMap = (PropertyMap)p;
                String usageParamName = ((PropertySimple)pMap.get("usageParameterName")).getStringValue();
                Property curValue = pMap.get("usageParameterValue");
                Object newValue = connection.invoke(sbbUsageON, "get" + usageParamName, new Object[]{false}, new String[]{"boolean"});
                if (newValue == null || newValue.equals(curValue) || !this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Changing Usage Parameter '" + usageParamName + "' from value [" + curValue + "] to [" + newValue + "]."));
            }
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update Resource Configuration.", (Throwable)e);
            configurationUpdateReport.setErrorMessageFromThrowable((Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

