/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.jbossas5.helper.JBossInstallationInfo;
import org.rhq.plugins.jslee.jbossas5.helper.JBossInstanceInfo;
import org.rhq.plugins.jslee.jbossas5.util.JBossASDiscoveryUtils;
import org.rhq.plugins.jslee.jbossas5.util.JnpConfig;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainSleeServerDiscoveryComponent
implements ResourceDiscoveryComponent<JainSleeServerComponent>,
ManualAddFacet<JainSleeServerComponent>,
ClassLoaderFacet<JainSleeServerComponent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String CHANGE_ME = "***CHANGE_ME***";
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String JBOSS_SERVICE_XML = "conf" + File.separator + "jboss-service.xml";
    private static final String JBOSS_NAMING_SERVICE_XML = "deploy" + File.separator + "naming-service.xml";
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private static final String[] CLIENT_JARS = new String[]{"client/jbossall-client.jar", "common/lib/jboss-security-aspects.jar", "lib/jboss-managed.jar", "lib/jboss-metatype.jar", "lib/jboss-dependency.jar"};

    public Set discoverResources(ResourceDiscoveryContext<JainSleeServerComponent> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        this.log.trace((Object)"Discovering Restcomm JSLEE Server 2.0.0.BETA2 and above Resources...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        DiscoveredResourceDetails inProcessJBossAS = this.discoverInProcessJBossAS(discoveryContext);
        if (inProcessJBossAS != null) {
            resources.add(inProcessJBossAS);
        } else {
            resources.addAll(this.discoverExternalJBossAsProcesses(discoveryContext));
        }
        this.log.trace((Object)("Discovered " + resources.size() + " JBossAS 5.x and 6.x Resources."));
        return resources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException {
        DiscoveredResourceDetails resourceDetails;
        JBossInstallationInfo installInfo;
        ProcessInfo processInfo = null;
        String jbossHomeDir = pluginConfig.getSimple("serverHomeDir").getStringValue();
        String mobicentsJSleeHome = jbossHomeDir + File.separator + "deploy" + File.separator + "restcomm-slee";
        File mobicentsSlee = new File(mobicentsJSleeHome);
        try {
            if (!mobicentsSlee.getCanonicalFile().isDirectory()) {
                this.log.warn((Object)("Skipping manuall add for Restcomm JAIN SLEE Server " + mobicentsJSleeHome + ", because Restcomm dir 'restcomm-slee' does not exist or is not a directory."));
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Skipping discovery for Restcomm JAIN SLEE Server " + mobicentsJSleeHome + ", because Restcomm dir could not be canonicalized."), (Throwable)e);
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        pluginConfig.put((Property)new PropertySimple("jslee.home.dir", (Object)mobicentsJSleeHome));
        try {
            installInfo = new JBossInstallationInfo(new File(jbossHomeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        try {
            resourceDetails = this.createResourceDetails(context, pluginConfig, processInfo, installInfo);
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        return resourceDetails;
    }

    private String getNamingPort(String namingUrl) {
        String port;
        String namingPort = null;
        int colonIndex = namingUrl.lastIndexOf(58);
        if (colonIndex != -1 && colonIndex != namingUrl.length() - 1 && !(port = namingUrl.substring(colonIndex + 1)).equals(CHANGE_ME)) {
            namingPort = port;
        }
        return namingPort;
    }

    public List getAdditionalClasspathUrls(ResourceDiscoveryContext<JainSleeServerComponent> context, DiscoveredResourceDetails details) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getAdditionalClasspathUrls(" + context + ", " + details + ") called."));
        }
        Configuration pluginConfig = details.getPluginConfiguration();
        String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (String jarFileName : CLIENT_JARS) {
            File clientJar = new File(homeDir, jarFileName);
            if (!clientJar.exists()) {
                throw new FileNotFoundException("Cannot find [" + clientJar + "] - unable to manage server.");
            }
            if (!clientJar.canRead()) {
                throw new IOException("Cannot read [" + clientJar + "] - unable to manage server.");
            }
            clientJars.add(clientJar.toURI().toURL());
        }
        return clientJars;
    }

    private DiscoveredResourceDetails discoverInProcessJBossAS(ResourceDiscoveryContext discoveryContext) {
        try {
            return null;
        }
        catch (Throwable t) {
            this.log.debug((Object)"In-process JBoss AS discovery failed - we are probably not running embedded within JBoss AS.", t);
            return null;
        }
    }

    private Set<DiscoveredResourceDetails> discoverExternalJBossAsProcesses(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            String javaHome;
            File configDir;
            File installHome;
            JBossInstallationInfo installInfo;
            JBossInstanceInfo cmdLine;
            ProcessInfo processInfo;
            block13: {
                block12: {
                    processInfo = autoDiscoveryResult.getProcessInfo();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Discovered JBoss AS process: " + processInfo));
                    }
                    try {
                        cmdLine = new JBossInstanceInfo(processInfo);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to process JBoss AS command line: " + Arrays.asList(processInfo.getCommandLine())), (Throwable)e);
                        continue;
                    }
                    installInfo = cmdLine.getInstallInfo();
                    installHome = new File(cmdLine.getSystemProperties().getProperty("jboss.home.dir"));
                    configDir = new File(cmdLine.getSystemProperties().getProperty("jboss.server.home.dir"));
                    try {
                        if (!configDir.getCanonicalFile().isDirectory()) {
                            this.log.warn((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' does not exist or is not a directory."));
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Skipping discovery for JBoss AS process " + processInfo + ", because configuration dir '" + configDir + "' could not be canonicalized."), (Throwable)e);
                    }
                    continue;
                }
                File mobicentsSlee = new File(cmdLine.getSystemProperties().getProperty("jslee.home.dir"));
                try {
                    if (!mobicentsSlee.getCanonicalFile().isDirectory()) {
                        this.log.warn((Object)("Skipping discovery for Restcomm JAIN SLEE process " + processInfo + ", because Restcomm dir " + mobicentsSlee.getCanonicalFile().getAbsolutePath() + " does not exist or is not a directory."));
                    }
                    break block13;
                }
                catch (IOException e) {
                    this.log.error((Object)("Skipping discovery for Restcomm JAIN SLEE process " + processInfo + ", because Restcomm dir could not be canonicalized."), (Throwable)e);
                }
                continue;
            }
            Configuration pluginConfiguration = discoveryContext.getDefaultPluginConfiguration();
            String jnpURL = this.getJnpURL(cmdLine, installHome, configDir);
            pluginConfiguration.put((Property)new PropertySimple("namingURL", (Object)jnpURL));
            pluginConfiguration.put((Property)new PropertySimple("homeDir", (Object)installHome.getAbsolutePath()));
            pluginConfiguration.put((Property)new PropertySimple("serverHomeDir", (Object)configDir));
            pluginConfiguration.put((Property)new PropertySimple("jslee.home.dir", (Object)cmdLine.getSystemProperties().getProperty("jslee.home.dir")));
            pluginConfiguration.put((Property)new PropertySimple("serverName", (Object)cmdLine.getSystemProperties().getProperty("jboss.server.name")));
            pluginConfiguration.put((Property)new PropertySimple("bindAddress", (Object)cmdLine.getSystemProperties().getProperty("jboss.bind.address")));
            pluginConfiguration.put((Property)new PropertySimple("serverTmpDir", (Object)cmdLine.getSystemProperties().getProperty("jboss.server.temp.dir")));
            JBossASDiscoveryUtils.UserInfo userInfo = JBossASDiscoveryUtils.getJmxInvokerUserInfo(configDir);
            if (userInfo != null) {
                pluginConfiguration.put((Property)new PropertySimple("principal", (Object)userInfo.getUsername()));
                pluginConfiguration.put((Property)new PropertySimple("credentials", (Object)userInfo.getPassword()));
            }
            if ((javaHome = processInfo.getEnvironmentVariable(JAVA_HOME_ENV_VAR)) == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAVA_HOME environment variable not set in JBoss AS process - defaulting javaHome connection property to the plugin container JRE dir.");
                javaHome = System.getenv(JAVA_HOME_ENV_VAR);
            }
            pluginConfiguration.put((Property)new PropertySimple("javaHome", (Object)javaHome));
            this.initLogEventSourcesConfigProp(configDir, pluginConfiguration);
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfiguration, processInfo, installInfo);
            resources.add(resourceDetails);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig, ProcessInfo processInfo, JBossInstallationInfo installInfo) throws Exception {
        String serverHomeDir = pluginConfig.getSimple("jslee.home.dir").getStringValue();
        File absoluteConfigPath = JainSleeServerDiscoveryComponent.resolvePathRelativeToHomeDir(pluginConfig, serverHomeDir);
        String key = FileUtils.getCanonicalPath((String)absoluteConfigPath.getPath());
        String bindAddress = pluginConfig.getSimple("bindAddress").getStringValue();
        String namingUrl = pluginConfig.getSimple("namingURL").getStringValue();
        String namingPort = this.getNamingPort(namingUrl);
        ObjectName sleemanagement = new ObjectName("javax.slee.management:name=SleeManagement");
        String principal = pluginConfig.getSimple("principal").getStringValue();
        String credentials = pluginConfig.getSimple("credentials").getStringValue();
        MBeanServerUtils mbeanUtils = new MBeanServerUtils(namingUrl, principal, credentials);
        MBeanServerConnection connection = mbeanUtils.getConnection();
        try {
            mbeanUtils.login();
            String sleeName = (String)connection.getAttribute(sleemanagement, "SleeName");
            String sleeVersion = (String)connection.getAttribute(sleemanagement, "SleeVersion");
            String sleeVendor = (String)connection.getAttribute(sleemanagement, "SleeVendor");
            String description = sleeName + " v" + sleeVersion + " by " + sleeVendor;
            String name = this.formatServerName(sleeName + " " + sleeVersion, bindAddress, namingPort);
            DiscoveredResourceDetails discoveredResourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, sleeVersion, description, pluginConfig, processInfo);
            return discoveredResourceDetails;
        }
        finally {
            block7: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private String formatServerName(String baseName, String bindingAddress, String jnpPort) {
        String details = null;
        if (bindingAddress != null && jnpPort != null && !jnpPort.equals(CHANGE_ME)) {
            details = bindingAddress + ":" + jnpPort;
        } else if (bindingAddress == null && jnpPort != null && !jnpPort.equals(CHANGE_ME)) {
            details = jnpPort;
        } else if (bindingAddress != null) {
            details = bindingAddress;
        }
        return baseName + (details != null ? " (" + details + ")" : "");
    }

    private static File resolvePathRelativeToHomeDir(Configuration pluginConfig, String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String homeDir = pluginConfig.getSimple("homeDir").getStringValue();
            configDir = new File(homeDir, path);
        }
        return configDir;
    }

    private String getJnpURL(JBossInstanceInfo cmdLine, File installHome, File configDir) {
        String jnpAddress;
        File jnpServiceUrlFile = new File(configDir, "data/jnp-service.url");
        if (jnpServiceUrlFile.exists() && jnpServiceUrlFile.canRead()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(jnpServiceUrlFile));
                String jnpUrl = br.readLine();
                if (jnpUrl != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Read JNP URL from jnp-service.url file: " + jnpUrl));
                    }
                    return jnpUrl;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.log.warn((Object)("Failed to read JNP URL from '" + jnpServiceUrlFile + "'."));
        JnpConfig jnpConfig = JainSleeServerDiscoveryComponent.getJnpConfig(installHome, configDir, cmdLine.getSystemProperties());
        String string = jnpAddress = jnpConfig.getJnpAddress() != null ? jnpConfig.getJnpAddress() : CHANGE_ME;
        if (ANY_ADDRESS.equals(jnpAddress)) {
            jnpAddress = LOCALHOST;
        }
        String jnpPort = jnpConfig.getJnpPort() != null ? String.valueOf(jnpConfig.getJnpPort()) : CHANGE_ME;
        return "jnp://" + jnpAddress + ":" + jnpPort;
    }

    private static JnpConfig getJnpConfig(File installHome, File configDir, Properties props) {
        File namingServiceFile;
        File serviceXML = new File(configDir, JBOSS_SERVICE_XML);
        JnpConfig config = JnpConfig.getConfig(installHome, serviceXML, props);
        if ((config == null || config.getJnpPort() == null) && (namingServiceFile = new File(configDir, JBOSS_NAMING_SERVICE_XML)).exists()) {
            config = JnpConfig.getConfig(installHome, namingServiceFile, props);
        }
        return config;
    }

    private void initLogEventSourcesConfigProp(File configDir, Configuration pluginConfig) {
        File logDir = new File(configDir, "log");
        File serverLogFile = new File(logDir, "server.log");
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("serverLog");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            PropertyList logEventSources = pluginConfig.getList("logEventSources");
            if (logEventSources != null) {
                logEventSources.add((Property)serverLogEventSource);
            }
        }
    }
}

