/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.alarms;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.alarms.AlarmDetailsPanel;
import org.mobicents.slee.container.management.console.client.alarms.AlarmInfo;
import org.mobicents.slee.container.management.console.client.alarms.AlarmListPanel;
import org.mobicents.slee.container.management.console.client.alarms.AlarmsServiceAsync;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;

public class AlarmListPanel
extends Composite {
    private BrowseContainer browseContainer;
    private AlarmsServiceAsync service = ServerConnection.alarmsServiceAsync;
    private ControlContainer rootPanel = new ControlContainer();
    private ListPanel alarmListPanel = new ListPanel();
    private AlarmInfo[] alarmInfos;
    private static final int COLUMN_TIMESTAMP = 0;
    private static final int COLUMN_ID = 1;
    private static final int COLUMN_LEVEL = 2;
    private static final int COLUMN_MESSAGE = 3;
    private static final int COLUMN_CLEAR = 4;
    private Label alarmCount;

    public AlarmListPanel(BrowseContainer browseContainer) {
        this.browseContainer = browseContainer;
        this.initWidget((Widget)this.rootPanel);
        this.alarmListPanel.setHeader(0, "Timestamp");
        this.alarmListPanel.setHeader(1, "ID");
        this.alarmListPanel.setHeader(2, "Level");
        this.alarmListPanel.setHeader(3, "Message");
        this.alarmListPanel.setHeader(4, "Action");
        this.alarmListPanel.setColumnWidth(3, "100%");
        Hyperlink refreshLink = new Hyperlink("refresh", "refresh");
        refreshLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ControlContainer counterTypeTitlePanel = new ControlContainer();
        this.alarmCount = new Label("");
        counterTypeTitlePanel.setWidget(0, 0, (Widget)this.alarmCount);
        counterTypeTitlePanel.setWidget(0, 1, (Widget)new Image("images/refresh.gif"));
        counterTypeTitlePanel.setWidget(0, 2, (Widget)refreshLink);
        counterTypeTitlePanel.getCellFormatter().setWidth(0, 0, "100%");
        this.rootPanel.setWidget(0, 0, (Widget)counterTypeTitlePanel);
        this.rootPanel.setWidget(1, 0, (Widget)this.alarmListPanel);
        this.rootPanel.getCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        this.refreshData();
    }

    private void refreshData() {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.getAlarms((AsyncCallback)callback);
    }

    private void refreshTable() {
        if (this.alarmInfos == null || this.alarmInfos.length == 0) {
            this.alarmListPanel.emptyTable();
            this.alarmCount.setText("There are no alarms");
            this.browseContainer.setTitle((Widget)this, "There are no alarms");
            return;
        }
        this.alarmCount.setText("Total alarms :" + this.alarmInfos.length);
        this.browseContainer.setTitle((Widget)this, "Alarms (" + this.alarmInfos.length + ")");
        this.alarmListPanel.emptyTable();
        for (int i = 0; i < this.alarmInfos.length; ++i) {
            AlarmInfo alarmInfo = this.alarmInfos[i];
            Hyperlink idLink = new Hyperlink(alarmInfo.getId(), alarmInfo.getId());
            idLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.alarmListPanel.setCell(i, 1, (Widget)idLink);
            this.alarmListPanel.setCellText(i, 2, alarmInfo.getLevel());
            this.alarmListPanel.setCellText(i, 3, alarmInfo.getMessage());
            this.alarmListPanel.setCellText(i, 0, alarmInfo.getTimestamp());
            Hyperlink clearLink = new Hyperlink("clear", "clear alarm " + alarmInfo.getId());
            clearLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.alarmListPanel.setCell(i, 4, (Widget)clearLink);
        }
    }

    private void onAlarmClicked(AlarmInfo alarmInfo) {
        AlarmDetailsPanel detailsPanel = new AlarmDetailsPanel(this.browseContainer, alarmInfo);
        this.browseContainer.add("Alarm Details", (Widget)detailsPanel);
    }

    private void onClear(AlarmInfo alarmInfo) {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.clearAlarm(alarmInfo.getId(), (AsyncCallback)callback);
    }

    static /* synthetic */ void access$000(AlarmListPanel x0) {
        x0.refreshData();
    }

    static /* synthetic */ AlarmInfo[] access$102(AlarmListPanel x0, AlarmInfo[] x1) {
        x0.alarmInfos = x1;
        return x1;
    }

    static /* synthetic */ void access$200(AlarmListPanel x0) {
        x0.refreshTable();
    }

    static /* synthetic */ void access$300(AlarmListPanel x0, AlarmInfo x1) {
        x0.onAlarmClicked(x1);
    }

    static /* synthetic */ void access$400(AlarmListPanel x0, AlarmInfo x1) {
        x0.onClear(x1);
    }
}

