/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.usage;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.Logger;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.common.Title;
import org.mobicents.slee.container.management.console.client.components.ComponentsServiceAsync;
import org.mobicents.slee.container.management.console.client.components.info.ComponentInfo;
import org.mobicents.slee.container.management.console.client.components.info.ComponentTypeInfo;
import org.mobicents.slee.container.management.console.client.components.info.SbbInfo;
import org.mobicents.slee.container.management.console.client.components.info.ServiceInfo;
import org.mobicents.slee.container.management.console.client.services.ServicesServiceAsync;
import org.mobicents.slee.container.management.console.client.usage.ParameterSetListPanel;
import org.mobicents.slee.container.management.console.client.usage.ParameterSetPanel;
import org.mobicents.slee.container.management.console.client.usage.UsageServiceAsync;

public class ParameterSetListPanel
extends Composite {
    private UsageServiceAsync usageService = ServerConnection.usageServiceAsync;
    private ServicesServiceAsync servicesService = ServerConnection.servicesServiceAsync;
    ComponentsServiceAsync componentsService = ServerConnection.componentsService;
    private BrowseContainer browseContainer;
    private ControlContainer rootPanel = new ControlContainer();
    private ListBox serviceListBox = new ListBox();
    private ComponentInfo[] serviceInfos;
    private ListBox sbbListBox = new ListBox();
    private ComponentInfo[] sbbInfos;
    private String[] parameterSets;
    private ListPanel parameterSetsPanel = new ListPanel();
    private TextBox createParameterSetTextBox = new TextBox();
    private Button createParameterSetButton = new Button("Create");
    private Button resetAllUsageParameters = new Button("Reset all usage parameters");

    public ParameterSetListPanel(BrowseContainer browseContainer) {
        this.browseContainer = browseContainer;
        this.initWidget((Widget)this.rootPanel);
        this.serviceListBox.setWidth("300px");
        this.sbbListBox.setWidth("300px");
        this.serviceListBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sbbListBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.parameterSetsPanel.setHeader(1, "Name");
        this.parameterSetsPanel.setHeader(2, "Actions");
        this.parameterSetsPanel.setColumnWidth(1, "100%");
        this.rootPanel.setWidget(0, 0, (Widget)new Title("Select a Service and a SBB:", 2));
        ControlContainer serviceAndSbbSelectPanel = new ControlContainer();
        serviceAndSbbSelectPanel.setText(0, 0, "Service");
        serviceAndSbbSelectPanel.setWidget(0, 1, (Widget)this.serviceListBox);
        serviceAndSbbSelectPanel.getCellFormatter().setWidth(0, 1, "100%");
        serviceAndSbbSelectPanel.setText(1, 0, "SBB");
        serviceAndSbbSelectPanel.setWidget(1, 1, (Widget)this.sbbListBox);
        serviceAndSbbSelectPanel.getCellFormatter().setWidth(1, 1, "100%");
        this.resetAllUsageParameters.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ControlContainer parameterSetControlsPanel = new ControlContainer();
        parameterSetControlsPanel.setText(0, 0, "New parameter set");
        parameterSetControlsPanel.getCellFormatter().setWordWrap(0, 0, false);
        parameterSetControlsPanel.setWidget(0, 1, (Widget)this.createParameterSetTextBox);
        parameterSetControlsPanel.setWidget(0, 2, (Widget)this.createParameterSetButton);
        parameterSetControlsPanel.setWidget(0, 3, (Widget)new Label());
        parameterSetControlsPanel.getCellFormatter().setWidth(0, 3, "100%");
        parameterSetControlsPanel.setWidget(0, 4, (Widget)this.resetAllUsageParameters);
        this.createParameterSetButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.rootPanel.setWidget(1, 0, (Widget)serviceAndSbbSelectPanel);
        this.rootPanel.setWidget(2, 0, (Widget)new Title("Parameter Sets", 2));
        this.rootPanel.setWidget(4, 0, (Widget)parameterSetControlsPanel);
        this.refreshData();
    }

    private void onResetAllUsageParameters() {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        Logger.info((String)("Resetting all parameters " + this.getSelectedServiceInfo().getID() + " - " + this.getSelectedSbbInfo().getID()));
        this.usageService.resetAllUsageParameters(this.getSelectedServiceInfo().getID(), this.getSelectedSbbInfo().getID(), (AsyncCallback)callback);
    }

    private void onCreateParameterSet(String name) {
        if (name == null || name.length() == 0) {
            Logger.error((String)"Name not defined");
            return;
        }
        6 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.usageService.createUsageParameterSet(this.getSelectedServiceInfo().getID(), this.getSelectedSbbInfo().getID(), name, (AsyncCallback)callback);
    }

    private void refreshData() {
        this.refreshServiceListBox();
    }

    private void refreshParameterSetControls() {
        if (this.parameterSets == null) {
            this.createParameterSetTextBox.setEnabled(false);
            this.createParameterSetButton.setEnabled(false);
            this.resetAllUsageParameters.setEnabled(false);
        } else {
            this.createParameterSetTextBox.setEnabled(true);
            this.createParameterSetButton.setEnabled(true);
            this.resetAllUsageParameters.setEnabled(true);
        }
    }

    private void refreshServiceListBox() {
        7 serviceListCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.componentsService.getComponentInfos(new ComponentTypeInfo("Service", 0), (AsyncCallback)serviceListCallback);
    }

    private void onServiceListBoxChange() {
        this.refreshSbbListBox();
    }

    private void refreshSbbListBox() {
        8 sbbListCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.servicesService.getSbbsWithinService(this.getSelectedServiceInfo().getID(), (AsyncCallback)sbbListCallback);
    }

    private void onSbbListBoxChange() {
        this.refreshParameterSets();
    }

    private void refreshParameterSets() {
        ServiceInfo serviceInfo = this.getSelectedServiceInfo();
        SbbInfo sbbInfo = this.getSelectedSbbInfo();
        9 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.usageService.getParameterSets(serviceInfo.getID(), sbbInfo.getID(), (AsyncCallback)callback);
    }

    private void fillParameterSets() {
        if (this.parameterSets == null) {
            this.rootPanel.setWidget(3, 0, (Widget)new Label("(No parameter set defined)"));
            this.refreshParameterSetControls();
            return;
        }
        this.parameterSetsPanel.emptyTable();
        for (int i = 0; i < this.parameterSets.length; ++i) {
            this.parameterSetsPanel.setCell(i, 0, (Widget)new Image("images/usage.parameterset.gif"));
            String parameterSet = this.parameterSets[i];
            Hyperlink nameLink = parameterSet.length() == 0 ? new Hyperlink("default", "default") : new Hyperlink(parameterSet, parameterSet);
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.parameterSetsPanel.setCell(i, 1, (Widget)nameLink);
            if (parameterSet.length() == 0) continue;
            Hyperlink removeLink = new Hyperlink("remove", "remove");
            removeLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.parameterSetsPanel.setCell(i, 2, (Widget)removeLink);
        }
        this.rootPanel.setWidget(3, 0, (Widget)this.parameterSetsPanel);
        this.refreshParameterSetControls();
    }

    private void onParameterSet(String name) {
        ParameterSetPanel parameterSetPanel = new ParameterSetPanel(this.browseContainer, this.getSelectedServiceInfo(), this.getSelectedSbbInfo(), name);
        if (name.length() == 0) {
            this.browseContainer.add("default", (Widget)parameterSetPanel);
        } else {
            this.browseContainer.add(name, (Widget)parameterSetPanel);
        }
    }

    private void onRemoveParameterSet(String name) {
        12 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.usageService.removeUsageParameterSet(this.getSelectedServiceInfo().getID(), this.getSelectedSbbInfo().getID(), name, (AsyncCallback)callback);
    }

    private SbbInfo getSelectedSbbInfo() {
        int iSelectedSbb = this.sbbListBox.getSelectedIndex();
        if (iSelectedSbb == -1) {
            return null;
        }
        return (SbbInfo)this.sbbInfos[iSelectedSbb];
    }

    private ServiceInfo getSelectedServiceInfo() {
        int iSelectedService = this.serviceListBox.getSelectedIndex();
        if (iSelectedService == -1) {
            return null;
        }
        return (ServiceInfo)this.serviceInfos[iSelectedService];
    }

    static /* synthetic */ void access$000(ParameterSetListPanel x0) {
        x0.onServiceListBoxChange();
    }

    static /* synthetic */ void access$100(ParameterSetListPanel x0) {
        x0.onSbbListBoxChange();
    }

    static /* synthetic */ void access$200(ParameterSetListPanel x0) {
        x0.onResetAllUsageParameters();
    }

    static /* synthetic */ TextBox access$300(ParameterSetListPanel x0) {
        return x0.createParameterSetTextBox;
    }

    static /* synthetic */ void access$400(ParameterSetListPanel x0, String x1) {
        x0.onCreateParameterSet(x1);
    }

    static /* synthetic */ SbbInfo access$500(ParameterSetListPanel x0) {
        return x0.getSelectedSbbInfo();
    }

    static /* synthetic */ ServiceInfo access$600(ParameterSetListPanel x0) {
        return x0.getSelectedServiceInfo();
    }

    static /* synthetic */ void access$700(ParameterSetListPanel x0) {
        x0.refreshParameterSets();
    }

    static /* synthetic */ ComponentInfo[] access$802(ParameterSetListPanel x0, ComponentInfo[] x1) {
        x0.serviceInfos = x1;
        return x1;
    }

    static /* synthetic */ ListBox access$900(ParameterSetListPanel x0) {
        return x0.serviceListBox;
    }

    static /* synthetic */ ComponentInfo[] access$800(ParameterSetListPanel x0) {
        return x0.serviceInfos;
    }

    static /* synthetic */ ComponentInfo[] access$1002(ParameterSetListPanel x0, ComponentInfo[] x1) {
        x0.sbbInfos = x1;
        return x1;
    }

    static /* synthetic */ ListBox access$1100(ParameterSetListPanel x0) {
        return x0.sbbListBox;
    }

    static /* synthetic */ ComponentInfo[] access$1000(ParameterSetListPanel x0) {
        return x0.sbbInfos;
    }

    static /* synthetic */ String[] access$1202(ParameterSetListPanel x0, String[] x1) {
        x0.parameterSets = x1;
        return x1;
    }

    static /* synthetic */ void access$1300(ParameterSetListPanel x0) {
        x0.fillParameterSets();
    }

    static /* synthetic */ void access$1400(ParameterSetListPanel x0, String x1) {
        x0.onParameterSet(x1);
    }

    static /* synthetic */ void access$1500(ParameterSetListPanel x0, String x1) {
        x0.onRemoveParameterSet(x1);
    }
}

