/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.usage;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.Logger;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.common.Title;
import org.mobicents.slee.container.management.console.client.components.ComponentsServiceAsync;
import org.mobicents.slee.container.management.console.client.components.info.ComponentInfo;
import org.mobicents.slee.container.management.console.client.components.info.ComponentTypeInfo;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorEntityInfo;
import org.mobicents.slee.container.management.console.client.resources.ResourceServiceAsync;
import org.mobicents.slee.container.management.console.client.usage.RaParameterSetListPanel;
import org.mobicents.slee.container.management.console.client.usage.RaParameterSetPanel;
import org.mobicents.slee.container.management.console.client.usage.RaUsageServiceAsync;

public class RaParameterSetListPanel
extends Composite {
    private RaUsageServiceAsync usageService = ServerConnection.raUsageServiceAsync;
    private ResourceServiceAsync resourceService = ServerConnection.resourceServiceAsync;
    ComponentsServiceAsync componentsService = ServerConnection.componentsService;
    private BrowseContainer browseContainer;
    private ControlContainer rootPanel = new ControlContainer();
    private ListBox raListBox = new ListBox();
    private ComponentInfo[] raInfos;
    private ListBox raEntityListBox = new ListBox();
    private ResourceAdaptorEntityInfo[] raEntityInfos;
    private String[] parameterSets;
    private ListPanel parameterSetsPanel = new ListPanel();
    private TextBox createParameterSetTextBox = new TextBox();
    private Button createParameterSetButton = new Button("Create");
    private Button resetAllUsageParameters = new Button("Reset all usage parameters");

    public RaParameterSetListPanel(BrowseContainer browseContainer) {
        this.browseContainer = browseContainer;
        this.initWidget((Widget)this.rootPanel);
        this.raListBox.setWidth("300px");
        this.raEntityListBox.setWidth("300px");
        this.raListBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.raEntityListBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.parameterSetsPanel.setHeader(1, "Name");
        this.parameterSetsPanel.setHeader(2, "Actions");
        this.parameterSetsPanel.setColumnWidth(1, "100%");
        this.rootPanel.setWidget(0, 0, (Widget)new Title("Select a Resource Adaptor and Entity:", 2));
        ControlContainer serviceAndSbbSelectPanel = new ControlContainer();
        serviceAndSbbSelectPanel.setText(0, 0, "Resource Adaptor");
        serviceAndSbbSelectPanel.setWidget(0, 1, (Widget)this.raListBox);
        serviceAndSbbSelectPanel.getCellFormatter().setWidth(0, 1, "100%");
        serviceAndSbbSelectPanel.setText(1, 0, "Entity");
        serviceAndSbbSelectPanel.setWidget(1, 1, (Widget)this.raEntityListBox);
        serviceAndSbbSelectPanel.getCellFormatter().setWidth(1, 1, "100%");
        this.resetAllUsageParameters.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ControlContainer parameterSetControlsPanel = new ControlContainer();
        parameterSetControlsPanel.setText(0, 0, "New parameter set");
        parameterSetControlsPanel.getCellFormatter().setWordWrap(0, 0, false);
        parameterSetControlsPanel.setWidget(0, 1, (Widget)this.createParameterSetTextBox);
        parameterSetControlsPanel.setWidget(0, 2, (Widget)this.createParameterSetButton);
        parameterSetControlsPanel.setWidget(0, 3, (Widget)new Label());
        parameterSetControlsPanel.getCellFormatter().setWidth(0, 3, "100%");
        parameterSetControlsPanel.setWidget(0, 4, (Widget)this.resetAllUsageParameters);
        this.createParameterSetButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.rootPanel.setWidget(1, 0, (Widget)serviceAndSbbSelectPanel);
        this.rootPanel.setWidget(2, 0, (Widget)new Title("Parameter Sets", 2));
        this.rootPanel.setWidget(4, 0, (Widget)parameterSetControlsPanel);
        this.refreshData();
    }

    private void onResetAllUsageParameters() {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        Logger.info((String)("Resetting all parameters " + this.getSelectedRaInfo().getID() + " - " + this.getSelectedRaEntityInfo().getName()));
        this.usageService.resetAllUsageParameters(this.getSelectedRaInfo().getID(), this.getSelectedRaEntityInfo().getName(), (AsyncCallback)callback);
    }

    private void onCreateParameterSet(String name) {
        if (name == null || name.length() == 0) {
            Logger.error((String)"Name not defined");
            return;
        }
        6 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.usageService.createUsageParameterSet(this.getSelectedRaEntityInfo().getName(), name, (AsyncCallback)callback);
    }

    private void refreshData() {
        this.refreshRaListBox();
    }

    private void refreshParameterSetControls() {
        if (this.parameterSets == null) {
            this.createParameterSetTextBox.setEnabled(false);
            this.createParameterSetButton.setEnabled(false);
            this.resetAllUsageParameters.setEnabled(false);
        } else {
            this.createParameterSetTextBox.setEnabled(true);
            this.createParameterSetButton.setEnabled(true);
            this.resetAllUsageParameters.setEnabled(true);
        }
    }

    private void refreshRaListBox() {
        7 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.componentsService.getComponentInfos(new ComponentTypeInfo("Resource Adaptor", 0), (AsyncCallback)callback);
    }

    private void onRaListBoxChange() {
        this.refreshRaEntityListBox();
    }

    private void refreshRaEntityListBox() {
        8 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.getResourceAdaptorEntityInfos(this.getSelectedRaInfo().getID(), (AsyncCallback)callback);
    }

    private void onRaEntityListBoxChange() {
        this.refreshParameterSets();
    }

    private void refreshParameterSets() {
        ComponentInfo raInfo = this.getSelectedRaInfo();
        ResourceAdaptorEntityInfo raEntityInfo = this.getSelectedRaEntityInfo();
        9 callback = new /* Unavailable Anonymous Inner Class!! */;
        Logger.info((String)("Selected entity name:" + raEntityInfo.getName()));
        this.usageService.getParameterSets(raInfo.getID(), raEntityInfo.getName(), (AsyncCallback)callback);
    }

    private void fillParameterSets() {
        if (this.parameterSets == null) {
            this.rootPanel.setWidget(3, 0, (Widget)new Label("(No parameter set defined)"));
            this.refreshParameterSetControls();
            return;
        }
        this.parameterSetsPanel.emptyTable();
        for (int i = 0; i < this.parameterSets.length; ++i) {
            this.parameterSetsPanel.setCell(i, 0, (Widget)new Image("images/usage.parameterset.gif"));
            String parameterSet = this.parameterSets[i];
            Hyperlink nameLink = parameterSet.length() == 0 ? new Hyperlink("default", "default") : new Hyperlink(parameterSet, parameterSet);
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.parameterSetsPanel.setCell(i, 1, (Widget)nameLink);
            if (parameterSet.length() == 0) continue;
            Hyperlink removeLink = new Hyperlink("remove", "remove");
            removeLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.parameterSetsPanel.setCell(i, 2, (Widget)removeLink);
        }
        this.rootPanel.setWidget(3, 0, (Widget)this.parameterSetsPanel);
        this.refreshParameterSetControls();
    }

    private void onParameterSet(String name) {
        RaParameterSetPanel parameterSetPanel = new RaParameterSetPanel(this.browseContainer, this.getSelectedRaInfo(), this.getSelectedRaEntityInfo(), name);
        if (name.length() == 0) {
            this.browseContainer.add("default", (Widget)parameterSetPanel);
        } else {
            this.browseContainer.add(name, (Widget)parameterSetPanel);
        }
    }

    private void onRemoveParameterSet(String name) {
        12 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.usageService.removeUsageParameterSet(this.getSelectedRaEntityInfo().getName(), name, (AsyncCallback)callback);
    }

    private ResourceAdaptorEntityInfo getSelectedRaEntityInfo() {
        int iSelectedEntity = this.raEntityListBox.getSelectedIndex();
        if (iSelectedEntity == -1) {
            return null;
        }
        return this.raEntityInfos[iSelectedEntity];
    }

    private ComponentInfo getSelectedRaInfo() {
        int iSelectedRa = this.raListBox.getSelectedIndex();
        if (iSelectedRa == -1) {
            return null;
        }
        return this.raInfos[iSelectedRa];
    }

    static /* synthetic */ void access$000(RaParameterSetListPanel x0) {
        x0.onRaListBoxChange();
    }

    static /* synthetic */ void access$100(RaParameterSetListPanel x0) {
        x0.onRaEntityListBoxChange();
    }

    static /* synthetic */ void access$200(RaParameterSetListPanel x0) {
        x0.onResetAllUsageParameters();
    }

    static /* synthetic */ TextBox access$300(RaParameterSetListPanel x0) {
        return x0.createParameterSetTextBox;
    }

    static /* synthetic */ void access$400(RaParameterSetListPanel x0, String x1) {
        x0.onCreateParameterSet(x1);
    }

    static /* synthetic */ ResourceAdaptorEntityInfo access$500(RaParameterSetListPanel x0) {
        return x0.getSelectedRaEntityInfo();
    }

    static /* synthetic */ ComponentInfo access$600(RaParameterSetListPanel x0) {
        return x0.getSelectedRaInfo();
    }

    static /* synthetic */ void access$700(RaParameterSetListPanel x0) {
        x0.refreshParameterSets();
    }

    static /* synthetic */ ComponentInfo[] access$802(RaParameterSetListPanel x0, ComponentInfo[] x1) {
        x0.raInfos = x1;
        return x1;
    }

    static /* synthetic */ ListBox access$900(RaParameterSetListPanel x0) {
        return x0.raListBox;
    }

    static /* synthetic */ ComponentInfo[] access$800(RaParameterSetListPanel x0) {
        return x0.raInfos;
    }

    static /* synthetic */ ResourceAdaptorEntityInfo[] access$1002(RaParameterSetListPanel x0, ResourceAdaptorEntityInfo[] x1) {
        x0.raEntityInfos = x1;
        return x1;
    }

    static /* synthetic */ ListBox access$1100(RaParameterSetListPanel x0) {
        return x0.raEntityListBox;
    }

    static /* synthetic */ ResourceAdaptorEntityInfo[] access$1000(RaParameterSetListPanel x0) {
        return x0.raEntityInfos;
    }

    static /* synthetic */ String[] access$1202(RaParameterSetListPanel x0, String[] x1) {
        x0.parameterSets = x1;
        return x1;
    }

    static /* synthetic */ void access$1300(RaParameterSetListPanel x0) {
        x0.fillParameterSets();
    }

    static /* synthetic */ void access$1400(RaParameterSetListPanel x0, String x1) {
        x0.onParameterSet(x1);
    }

    static /* synthetic */ void access$1500(RaParameterSetListPanel x0, String x1) {
        x0.onRemoveParameterSet(x1);
    }
}

