/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jsleex;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.EventTypeID;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class RouterStatsCommand
extends AbstractSleeCommand {
    public RouterStatsCommand() {
        super("router.stats", "This command performs operations on Mobicents EventRouterStatistics MBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("   -m, --mapped-activities     Returns number of mapped activities. Optionally it can take positive integer argument.");
        out.println("                               In case argument is present it indicates executor for which value should be returned.");
        out.println("    -a, --avg-time              Returns avarage time spent in routing tasks. Without any option this returns avg time for all executors and events. ");
        out.println("                                Options may be used in any conjunctions: ");
        out.println("           --eventTypeId        Specifies EventTypeID for which avg time should be retrieved. Requires EventTypeID argument.");
        out.println("           --executor           Specifies executor for which avg time should be retrieved. Requires positive integer argument.");
        out.println("    -r, --events-routed         Returns number of events routed. It requires \"--eventTypeId\" option to be present. ");
        out.println("                                Following options are supported: ");
        out.println("           --eventTypeId        Specifies EventTypeID for which avg time should be retrieved. Requires EventTypeID argument.");
        out.println("           --executor           Specifies executor for which avg time should be retrieved. Requires positive integer argument.");
        out.println("    -e, --executed-tasks        Returns number of executed tasks. Optionally it can take positive integer argument.");
        out.println("                                In case argument is present it indicates executor for which value should be returned.");
        out.println("    -i, --idle-time             Returns idle time for particular executor. Requires positive integer argument, which indicates executor.");
        out.println("    -c, --misc-tasks            Returns number of misc tasks(not routing) executed within container. Optionally it can take positive integer argument.");
        out.println("                                In case argument is present it indicates executor for which value should be returned.");
        out.println("    -t, --executing-time        Returns total time spent in executor. Requires positive integer argument, which indicates executor.");
        out.println("    -x, --misc-executing-time   Returns total time spent in executor(misc tasks). Requires positive integer argument, which indicates executor.");
        out.println("    -o, --routing-time          Returns total time spent on routing event type in particular executor. Requires both option to be present.");
        out.println("                                Following options are supported: ");
        out.println("          --eventTypeId         Specifies EventTypeID for which avg time should be retrieved. Requires EventTypeID argument.");
        out.println("          --executor            Specifies executor for which avg time should be retrieved. Requires positive integer argument.");
        out.println("    -p, print-all               Prints all statistics. Does not require argument.");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Get number of milliseconds spent on routing certain event type:");
        out.println("" + this.name + " -r --eventTypeId=EventTypeID[name=javax.sip.message.Request.OPTIONS,vendor=net.java.slee,version=1.2]");
        out.println("");
        out.println("     2. Get number of milliseconds spent on routing certain event type in certain executor:");
        out.println("" + this.name + "  -r --eventTypeId=EventTypeID[name=javax.sip.message.Request.OPTIONS,vendor=net.java.slee,version=1.2] --executor=2");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.mobicents.slee:name=EventRouterStatistics");
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":m::are::i:c::t:x:op";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("mapped-activities", 2, null, 109), new LongOpt("avg-time", 0, null, 97), new LongOpt("eventTypeId", 1, null, 122), new LongOpt("executor", 1, null, 113), new LongOpt("events-routed", 0, null, 114), new LongOpt("executed-tasks", 2, null, 101), new LongOpt("idle-time", 1, null, 105), new LongOpt("misc-tasks", 2, null, 99), new LongOpt("executing-time", 1, null, 116), new LongOpt("misc-executing-time", 1, null, 120), new LongOpt("routing-time", 0, null, 111), new LongOpt("print-all", 0, null, 112)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block14: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 109: {
                    this.operation = new MappedActivitiesOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 97: {
                    this.operation = new AvgTimeOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 114: {
                    this.operation = new EventsRoutedOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 101: {
                    this.operation = new ExecutedTasksOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 105: {
                    this.operation = new IdleTimeOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 99: {
                    this.operation = new MiscTasksOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 116: {
                    this.operation = new ExecutingTimeOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 120: {
                    this.operation = new MiscTimeOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 111: {
                    this.operation = new RoutingTimeOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
                case 112: {
                    this.operation = new PrintAllOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block14;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class PrintAllOperation
    extends AbstractOperation {
        private static final String OPERATION_printAllStats = "printAllStats";

        public PrintAllOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_printAllStats;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class RoutingTimeOperation
    extends AbstractOperation {
        private static final String OPERATION_getRoutingTime = "getRoutingTime";
        private String stringEventTypeId;
        private String stringExecutor;

        public RoutingTimeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getRoutingTime;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 122: {
                        if (this.stringEventTypeId != null) {
                            throw new CommandException("Event Type can be specified only once.");
                        }
                        this.stringEventTypeId = opts.getOptarg();
                        continue block10;
                    }
                    case 113: {
                        if (this.stringExecutor != null) {
                            throw new CommandException("Executor can be specified only once.");
                        }
                        this.stringExecutor = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringEventTypeId == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires \"--eventTypeId\"");
            }
            if (this.stringExecutor == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires \"--executor\"");
            }
            try {
                this.addArg((Object)Integer.parseInt(this.stringExecutor), Integer.TYPE, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Integer: \"" + this.stringExecutor + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.stringEventTypeId, EventTypeID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse EventTypeID: \"" + this.stringEventTypeId + "\"", (Throwable)e);
            }
        }
    }

    private class MiscTimeOperation
    extends AbstractOperation {
        private static final String OPERATION_getMiscTasksExecutingTime = "getMiscTasksExecutingTime";

        public MiscTimeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getMiscTasksExecutingTime;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            try {
                this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class ExecutingTimeOperation
    extends AbstractOperation {
        private static final String OPERATION_getExecutingTime = "getExecutingTime";

        public ExecutingTimeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getExecutingTime;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            try {
                this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class MiscTasksOperation
    extends AbstractOperation {
        private static final String OPERATION_getMiscTasksExecuted = "getMiscTasksExecuted";

        public MiscTasksOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getMiscTasksExecuted;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg != null) {
                try {
                    this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
                }
            }
        }
    }

    private class IdleTimeOperation
    extends AbstractOperation {
        private static final String OPERATION_getIdleTime = "getIdleTime";

        public IdleTimeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getIdleTime;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            try {
                this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class ExecutedTasksOperation
    extends AbstractOperation {
        private static final String OPERATION_getExecutedTasks = "getExecutedTasks";

        public ExecutedTasksOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getExecutedTasks;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg != null) {
                try {
                    this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
                }
            }
        }
    }

    private class EventsRoutedOperation
    extends AbstractOperation {
        private static final String OPERATION_getEventsRouted = "getEventsRouted";
        private String stringEventTypeId;
        private String stringExecutor;

        public EventsRoutedOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getEventsRouted;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 122: {
                        if (this.stringEventTypeId != null) {
                            throw new CommandException("Event Type can be specified only once.");
                        }
                        this.stringEventTypeId = opts.getOptarg();
                        continue block10;
                    }
                    case 113: {
                        if (this.stringExecutor != null) {
                            throw new CommandException("Executor can be specified only once.");
                        }
                        this.stringExecutor = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringEventTypeId == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires \"--eventTypeId\"");
            }
            if (this.stringExecutor != null) {
                try {
                    this.addArg((Object)Integer.parseInt(this.stringExecutor), Integer.TYPE, false);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Integer: \"" + this.stringExecutor + "\"", (Throwable)e);
                }
            }
            if (this.stringEventTypeId != null) {
                try {
                    this.addArg((Object)this.stringEventTypeId, EventTypeID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse EventTypeID: \"" + this.stringEventTypeId + "\"", (Throwable)e);
                }
            }
        }
    }

    private class AvgTimeOperation
    extends AbstractOperation {
        private static final String OPERATION_getAverageEventRoutingTime = "getAverageEventRoutingTime";
        public static final char eventTypeId = 'z';
        public static final char executor = 'q';
        private String stringEventTypeId;
        private String stringExecutor;

        public AvgTimeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getAverageEventRoutingTime;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 122: {
                        if (this.stringEventTypeId != null) {
                            throw new CommandException("Event Type can be specified only once.");
                        }
                        this.stringEventTypeId = opts.getOptarg();
                        continue block10;
                    }
                    case 113: {
                        if (this.stringExecutor != null) {
                            throw new CommandException("Executor can be specified only once.");
                        }
                        this.stringExecutor = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringExecutor != null) {
                try {
                    this.addArg((Object)Integer.parseInt(this.stringExecutor), Integer.TYPE, false);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Integer: \"" + this.stringExecutor + "\"", (Throwable)e);
                }
            }
            if (this.stringEventTypeId != null) {
                try {
                    this.addArg((Object)this.stringEventTypeId, EventTypeID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse EventTypeID: \"" + this.stringEventTypeId + "\"", (Throwable)e);
                }
            }
        }
    }

    private class MappedActivitiesOperation
    extends AbstractOperation {
        private static final String OPERATION_getActivitiesMapped = "getActivitiesMapped";

        public MappedActivitiesOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getActivitiesMapped;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg != null) {
                try {
                    this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
                }
            }
        }
    }
}

