/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jsleex;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class ActivityCommand
extends AbstractSleeCommand {
    public ActivityCommand() {
        super("activity", "This command performs operations on Restcomm ActivityManagement MBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -c, --count                     Retrieves current count of activity contexts. Does not require argument.");
        out.println("    -q, --query                     Performs liveliness query if no option is specified.");
        out.println("                                    Optionally it may be followed by one of options, which alter action:");
        out.println("    \t\t--set                    Sets interval between queries. Requires argument of type long, interval is set in seconds.");
        out.println("    \t\t--get                    Gets interval. Does not require argument.");
        out.println("    -i, --idle                      Performs operation on activity context maximal idle time. Requires one of following options:");
        out.println("    \t\t--set                    Sets idle time. Requires argument of long type. Idle time is set in seconds.");
        out.println("    \t\t--get                    Gets idle time. Does not require argument.");
        out.println("    -l, --list                      Depending on option lists specific information. It must be followed by one of options:");
        out.println("    \t\t--factories              Lists activity context factories. Does not require argument.");
        out.println("    \t\t--contexts               Lists contexts present in container. It takes optional boolean argument. If argument is set to true information about context is detailed.");
        out.println("    \t\t--id-by-activity-type    List IDs of activity context based on activity class name. Requires FQN class name of activity as argument.");
        out.println("    \t\t--id-by-ra-entity        List IDs of activity context based on RA entity name. Requires entity name as argument.");
        out.println("    \t\t--id-by-sbb-id           List IDs of activity context based on SBB ID. Requires SBB ID as argument.");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Perform livelines query:");
        out.println("" + this.name + " -q");
        out.println("");
        out.println("     2. Set automatic livelines query delay to 1,5 minute:");
        out.println("" + this.name + " -q --set=90");
        out.println("");
        out.println("     3. List activity contexts, wit all information, attachments, names, variables, ...:");
        out.println("" + this.name + " -l --contexts=true");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.mobicents.slee:name=ActivityManagementMBean");
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":cqil";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("count", 0, null, 99), new LongOpt("query", 0, null, 113), new LongOpt("set", 1, null, 115), new LongOpt("get", 0, null, 103), new LongOpt("idle", 0, null, 105), new LongOpt("set", 1, null, 115), new LongOpt("get", 0, null, 103), new LongOpt("list", 0, null, 108), new LongOpt("factories", 0, null, 109), new LongOpt("contexts", 2, null, 110), new LongOpt("id-by-activity-type", 1, null, 98), new LongOpt("id--by-ra-entity", 1, null, 118), new LongOpt("id-by-sbb-id", 1, null, 120)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block10: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 99: {
                    this.operation = new CountOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 113: {
                    this.operation = new QueryOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 105: {
                    this.operation = new IdleOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 100: {
                    this.operation = new DetailsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 101: {
                    this.operation = new EndOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class EndOperation
    extends AbstractOperation {
        private static final String OPERATION_endActivity = "endActivity";

        public EndOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_endActivity;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class ListOperation
    extends AbstractOperation {
        public static final char sbbEID = 'z';
        public static final char sbbID = 'x';
        public static final char raEntity = 'v';
        public static final char activityType = 'b';
        public static final char contexts = 'n';
        public static final char factories = 'm';
        private static final String OPERATION_retrieveActivityContextIDBySbbEntityID = "retrieveActivityContextIDBySbbEntityID";
        private static final String OPERATION_retrieveActivityContextIDBySbbID = "retrieveActivityContextIDBySbbID";
        private static final String OPERATION_retrieveActivityContextIDByResourceAdaptorEntityName = "retrieveActivityContextIDByResourceAdaptorEntityName";
        private static final String OPERATION_retrieveActivityContextIDByActivityType = "retrieveActivityContextIDByActivityType";
        private static final String OPERATION_listActivityContexts = "listActivityContexts";
        private static final String OPERATION_listActivityContextsFactories = "listActivityContextsFactories";
        public static final int AC_ID = 0;
        public static final int ACTIVITY_CLASS = 1;
        public static final int LAST_ACCESS_TIME = 2;
        public static final int RA = 3;
        public static final int SBB_ATTACHMENTS = 4;
        public static final int NAMES_BOUND_TO = 5;
        public static final int TIMERS_ATTACHED = 6;
        public static final int DATA_PROPERTIES = 7;

        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects  option!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 120: {
                        this.operationName = OPERATION_retrieveActivityContextIDBySbbID;
                        String optArg = opts.getOptarg();
                        this.addArg((Object)optArg, String.class, false);
                        break;
                    }
                    case 118: {
                        this.operationName = OPERATION_retrieveActivityContextIDByResourceAdaptorEntityName;
                        String optArg = opts.getOptarg();
                        this.addArg((Object)optArg, String.class, false);
                        break;
                    }
                    case 98: {
                        this.operationName = OPERATION_retrieveActivityContextIDByActivityType;
                        String optArg = opts.getOptarg();
                        this.addArg((Object)optArg, String.class, false);
                        break;
                    }
                    case 110: {
                        this.operationName = OPERATION_listActivityContexts;
                        String optArg = opts.getOptarg();
                        if (optArg == null) {
                            optArg = "False";
                        }
                        this.addArg((Object)Boolean.valueOf(optArg), Boolean.TYPE, false);
                        break;
                    }
                    case 109: {
                        this.operationName = OPERATION_listActivityContextsFactories;
                        break;
                    }
                    default: {
                        throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
                    }
                }
                if (this.operationName != null) continue;
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects  option!");
            }
        }

        protected String unfoldArray(String prefix, Object[] array, PropertyEditor editor) {
            if (this.operationName.equals(OPERATION_listActivityContexts)) {
                StringBuffer sb = new StringBuffer();
                for (Object o : array) {
                    Object[] rep = (Object[])o;
                    sb.append("ACH               : ").append(rep[0]).append("\n");
                    sb.append("Class             : ").append(rep[1]).append("\n");
                    sb.append("Last access time  : ").append(rep[2]).append("\n");
                    sb.append("Resource Adaptor  : ").append(rep[3]).append("\n");
                    if (rep[4].getClass().isArray()) {
                        sb.append("SBB attached      : ").append(super.unfoldArray("     ", (Object[])rep[4], null)).append("\n");
                        sb.append("Names             : ").append(super.unfoldArray("     ", (Object[])rep[5], null)).append("\n");
                        sb.append("Timers Attached   : ").append(super.unfoldArray("     ", (Object[])rep[6], null)).append("\n");
                        sb.append("Data properties   : ").append(super.unfoldArray("     ", (Object[])rep[7], null)).append("\n");
                    } else {
                        sb.append("SBB attached      : ").append(rep[4]).append("\n");
                        sb.append("Names             : ").append(rep[5]).append("\n");
                        sb.append("Timers Attached   : ").append(rep[6]).append("\n");
                        sb.append("Data properties   : ").append(rep[7]).append("\n");
                    }
                    sb.append("\n");
                }
                return sb.toString();
            }
            return super.unfoldArray(prefix, array, editor);
        }
    }

    private class DetailsOperation
    extends AbstractOperation {
        private static final String OPERATION_retrieveActivityContextDetails = "retrieveActivityContextDetails";

        public DetailsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_retrieveActivityContextDetails;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class IdleOperation
    extends AbstractOperation {
        private static final String OPERATION_setActivityContextMaxIdleTime = "setActivityContextMaxIdleTime";
        private static final String OPERATION_getActivityContextMaxIdleTime = "getActivityContextMaxIdleTime";

        public IdleOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 115: {
                        this.operationName = OPERATION_setActivityContextMaxIdleTime;
                        String optArg = opts.getOptarg();
                        try {
                            this.addArg((Object)Long.parseLong(optArg), Long.TYPE, false);
                            break;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse Long: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 103: {
                        this.operationName = OPERATION_getActivityContextMaxIdleTime;
                        break;
                    }
                    default: {
                        throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
                    }
                }
                if (this.operationName != null) continue;
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
            }
        }
    }

    private class QueryOperation
    extends AbstractOperation {
        public static final char set = 's';
        public static final char get = 'g';
        private static final String OPERATION_setTimeBetweenLivenessQueries = "setTimeBetweenLivenessQueries";
        private static final String OPERATION_getTimeBetweenLivenessQueries = "getTimeBetweenLivenessQueries";
        private static final String OPERATION_queryActivityContextLiveness = "queryActivityContextLiveness";

        public QueryOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 115: {
                        this.operationName = OPERATION_setTimeBetweenLivenessQueries;
                        String optArg = opts.getOptarg();
                        try {
                            this.addArg((Object)Long.parseLong(optArg), Long.TYPE, false);
                            break;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse Long: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 103: {
                        this.operationName = OPERATION_getTimeBetweenLivenessQueries;
                        break;
                    }
                    default: {
                        throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
                    }
                }
                if (this.operationName != null) continue;
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
            }
            if (this.operationName == null) {
                this.operationName = OPERATION_queryActivityContextLiveness;
            }
        }
    }

    private class CountOperation
    extends AbstractOperation {
        private static final String OPERATION_getActivityContextCount = "getActivityContextCount";

        protected CountOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getActivityContextCount;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }
}

