/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class SleeCommand
extends AbstractSleeCommand {
    public SleeCommand() {
        super("slee", "This command performs operations on JSLEE SleeManagementMBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation>");
        out.println();
        out.println("operation:");
        out.println("    -r, --start                     Starts container.");
        out.println("    -s, --stopt                     Stops container.");
        out.println("    -d, --shutdown                  Shutdowns container.");
        out.println("    -i, --info                      Displays information about SLEE container(vendor, version, etc.).");
        out.flush();
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":rsdi";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("start", 0, null, 114), new LongOpt("stopt", 0, null, 115), new LongOpt("shutdown", 0, null, 100), new LongOpt("info", 0, null, 105)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        block8: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 114: {
                    this.operation = new StartOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 115: {
                    this.operation = new StopOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 100: {
                    this.operation = new ShutdownOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 105: {
                    this.operation = new InfoOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=SleeManagement");
    }

    private class InfoOperation
    extends AbstractOperation {
        private final String[] OPS;

        public InfoOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand2) {
            super(context, log, sleeCommand2);
            this.OPS = new String[]{"SleeName", "SleeVendor", "SleeVersion", "Subsystems", "State"};
            this.operationName = "complicated!";
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }

        public void invoke() throws CommandException {
            try {
                ObjectName on = this.sleeCommand.getBeanOName();
                MBeanServerConnection conn = this.context.getServer();
                Object[] parms = this.getOpArguments().toArray();
                String[] sig = new String[this.getOpSignature().size()];
                sig = this.getOpSignature().toArray(sig);
                StringBuffer sb = new StringBuffer();
                sb.append("Info[");
                for (int index = 0; index < this.OPS.length; ++index) {
                    String op = this.OPS[index];
                    sb.append(op);
                    sb.append("=");
                    Object res = conn.invoke(on, "get" + op, parms, sig);
                    if (res instanceof String[]) {
                        Object[] result = (String[])res;
                        sb.append(Arrays.toString(result));
                    } else {
                        sb.append(res);
                    }
                    if (index + 1 == this.OPS.length) continue;
                    sb.append(",");
                }
                sb.append("]");
                this.operationResult = sb.toString();
                this.displayResult();
            }
            catch (InstanceNotFoundException infe) {
                this.operationResult = "No container deployed.";
                this.displayResult();
            }
            catch (Exception e) {
                throw new CommandException("Failed to invoke \"" + this.operationName + "\" due to: ", (Throwable)e);
            }
        }
    }

    private class ShutdownOperation
    extends AbstractOperation {
        private static final String OPERATION_shutdown = "shutdown";

        public ShutdownOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand2) {
            super(context, log, sleeCommand2);
            this.operationName = OPERATION_shutdown;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class StopOperation
    extends AbstractOperation {
        private static final String OPERATION_stop = "stop";

        public StopOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand2) {
            super(context, log, sleeCommand2);
            this.operationName = OPERATION_stop;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class StartOperation
    extends AbstractOperation {
        private static final String OPERATION_start = "start";

        public StartOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand2) {
            super(context, log, sleeCommand2);
            this.operationName = OPERATION_start;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }
}

