/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jsleex;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AccessorOperation;

public class CongestionCommand
extends AbstractSleeCommand {
    private static final String FIELD_PeriodBetweenChecks = "PeriodBetweenChecks";
    private static final String FIELD_MinFreeMemoryToTurnOn = "MinFreeMemoryToTurnOn";
    private static final String FIELD_MinFreeMemoryToTurnOff = "MinFreeMemoryToTurnOff";
    private static final String FIELD_RefuseFireEvent = "RefuseFireEvent";
    private static final String FIELD_RefuseStartActivity = "RefuseStartActivity";

    public CongestionCommand() {
        super("congestion", "This command performs operations on Mobicents CongestionControlConfiguration MBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println("Congestion mechanism starts acting when there is not enough memory available to JVM.");
        out.println("It stops");
        out.println();
        out.println("operation:");
        out.println("    -p, --period                    Performs operation on period between congestion checks. Exactly one of following options must be present:");
        out.println("            --get                   Returns number of seconds between congestion control checks. Does not require argument.");
        out.println("            --set                   Sets number of seconds, requires argument which is integer greater than zero.");
        out.println("    -d, --disable-level             Performs operation on minimal amount of memory free to turn off congestion. Once free memory reaches this level, congestion control stops.");
        out.println("                                    Exactly one of following options must be present:");
        out.println("            --get                   Returns number of MB required to be free to stop congestion. Does not require argument.");
        out.println("            --set                   Sets number of MB, requires argument which is integer greater than zero.");
        out.println("    -e, --enable-level              Performs operation on minimal amount of memory free to turn on congestion. Once free memory reaches this level, congestion control starts.");
        out.println("                                    Exactly one of following options must be present:");
        out.println("            --get                   Returns number of MB required to be free to start congestion. Does not require argument.");
        out.println("            --set                   Sets number of MB, requires argument which is integer greater than zero.");
        out.println("    -f, --refuse-event              Controls if events should not be fired during congestion period. Exactly one of following options must be present:");
        out.println("            --get                   Returns boolean value indicating if events should not be fired(true). Does not require argument.");
        out.println("            --set                   Sets value, \"true\" indicates that events wont be fired, requires argument which is valid boolean.");
        out.println("    -a, --refuse-activity           Controls if activities should not be created during congestion period. Exactly one of following options must be present:");
        out.println("            --get                   Returns boolean value indicating if activities should not be created(true). Does not require argument.");
        out.println("            --set                   Sets value, \"true\" indicates that activities wont be created, requires argument which is valid boolean.");
        out.println("arg:");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Set period between congestion checks:");
        out.println("" + this.name + " -p set=95");
        out.println("");
        out.println("     2. Set high watermark. Memory that has to be free in JVM for congestion control to stop acting:");
        out.println("" + this.name + " -d --set=25");
        out.println("");
        out.println("     3. Set low watermark. Amount of free memory which will triger congestion control to act:");
        out.println("" + this.name + " -e --set=10");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.mobicents.slee:name=CongestionControlConfiguration");
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":pedfa";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("period", 0, null, 112), new LongOpt("set", 1, null, 115), new LongOpt("get", 0, null, 103), new LongOpt("enable-level", 0, null, 101), new LongOpt("disable-level", 0, null, 100), new LongOpt("refuse-event", 0, null, 102), new LongOpt("refuse-activity", 0, null, 97)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block9: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 112: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_PeriodBetweenChecks, Integer.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 101: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_MinFreeMemoryToTurnOn, Integer.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 100: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_MinFreeMemoryToTurnOff, Integer.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 102: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_RefuseFireEvent, Boolean.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 97: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_RefuseStartActivity, Boolean.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }
}

