/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.jmx.editors.ComponentIDPropertyEditor;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public abstract class AbstractUsageCommand
extends AbstractSleeCommand {
    protected static final String GET_MANAGER_NAME_METHOD = "getUsageNotificationManagerMBean";
    protected static final String GET_MANAGER_NAME_SBB_METHOD = "getSbbUsageNotificationManagerMBean";
    protected ObjectName PROFILE_PROVISIONING_MBEAN;
    protected static final String PROFILE_GET_METHOD = "getProfileTableUsageMBean";
    protected ObjectName RESOURCE_MANAGEMENT_MBEAN;
    protected static final String RESOURCE_GET_METHOD = "getResourceUsageMBean";
    protected ObjectName SERVICE_MANAGEMENT_MBEAN;
    protected static final String SERVICE_GET_METHOD = "getServiceUsageMBean";
    protected static final String GET_SPECIFIC_BEAN_METHOD = "getUsageMBean";
    protected static final String GET_SPECIFIC_SBB_BEAN_METHOD = "getSbbUsageMBean";
    protected ObjectName provisioningMBeanName;
    protected String getOperationName;
    protected ObjectName usageMgmtMBeanName;
    protected ObjectName usageSetManagerMBeanName;
    protected ObjectName specificObjectName;
    protected String resourceName;
    protected String usageSetName;
    protected ServiceID serviceID;
    protected SbbID sbbID;
    protected ComponentIDPropertyEditor editor = new ComponentIDPropertyEditor();
    protected static final String PREFIX_SERVICEID = "ServiceID";

    public AbstractUsageCommand(String commandName, String desc) {
        super(commandName, desc);
        try {
            this.PROFILE_PROVISIONING_MBEAN = new ObjectName("javax.slee.management:name=ProfileProvisioning");
            this.RESOURCE_MANAGEMENT_MBEAN = new ObjectName("javax.slee.management:name=ResourceManagement");
            this.SERVICE_MANAGEMENT_MBEAN = new ObjectName("javax.slee.management:name=ServiceManagement");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        this.provisioningMBeanName = this.getProvisioningMBeanName();
        this.getOperationName = this.getUsageMGMTMBeanOperation();
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        this.addHeaderDescription(out);
        out.println("'SetID' refers to SetName or SbbID and SetName.");
        out.println();
        out.println("operation:");
        out.println("    -l, --list                     Lists certain information about parameters sets. Requires one of options to be present:");
        out.println("           --sets                  Instructs command to list declared parameter sets. Does not require argument.");
        out.println("           --parameters            Instructs command to list parameters of parameter set. Does not require argument.");
        out.println("    -g, --get                      Fetches value of certain parameter in set. Does not take argument.");
        out.println("                                   Requires '--name' option to be present. Following options are supported: ");
        out.println("           --name                  Specifies name of parameter in a set for get operation. Requires parameter name as argument. This option is mandatory.");
        out.println("           --rst                   If present, indicates that 'get' operation should reset parameter value. Does not require argument.");
        out.println("    -r, --reset                    Resets assets in 'Usage' realm. Does not take argument. If 'SetID' is specified, reset command resets specific set, otherwise it acts on default one.");
        out.println("                                   If it is not present, reset command performs operation on default set. Following option is supported:");
        out.println("           --all                   Resets ALL parameters for 'ResourceName', ignores 'SetID'.");
        out.println("    -c, --create                   Creates usage parameter set for given 'SetID'. Does not require argument.");
        out.println("    -d, --delete                   Deletes usage parameter set with given 'SetID'. Does not require argument.");
        out.println("    -n, --notify                   This operation either turn on/off notifications for parameter or queries about state of notifications.");
        out.println("                                   Does not take parameter, supports following options:");
        out.println("           --name                  Specifies name of parameter. Requires parameter name as argument. It is mandatory.");
        out.println("           --value                 Specifies value of parameter. Requires boolean argument.");
        out.println("           --is                    Request information about notification(if its enabled). Does not require argument.");
        out.println("");
        out.println("Examples: ");
        this.addExamples(out);
        out.flush();
    }

    protected abstract void addHeaderDescription(PrintWriter var1);

    protected abstract void addExamples(PrintWriter var1);

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return this.specificObjectName;
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = "-:lgrcdn";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("noprefix", 0, null, 4096), new LongOpt("list", 0, null, 108), new LongOpt("sets", 0, null, 118), new LongOpt("parameters", 0, null, 98), new LongOpt("get", 0, null, 103), new LongOpt("name", 1, null, 122), new LongOpt("rst", 0, null, 120), new LongOpt("reset", 0, null, 114), new LongOpt("all", 0, null, 97), new LongOpt("create", 0, null, 99), new LongOpt("delete", 0, null, 100), new LongOpt("notify", 0, null, 110), new LongOpt("value", 1, null, 111), new LongOpt("is-notify", 0, null, 105)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int nonOptArgIndex = 0;
        block21: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 4096: {
                    continue block21;
                }
                case 1: {
                    switch (nonOptArgIndex) {
                        case 0: {
                            this.resourceName = getopt.getOptarg();
                            if (this.resourceName.startsWith(PREFIX_SERVICEID)) {
                                try {
                                    this.editor.setAsText(this.resourceName);
                                }
                                catch (Exception e) {
                                    throw new CommandException("Command: \"" + this.getName() + "\" failed to parse ServiceID.", (Throwable)e);
                                }
                                this.serviceID = (ServiceID)this.editor.getValue();
                                this.resourceName = null;
                            }
                            ++nonOptArgIndex;
                            continue block21;
                        }
                        case 1: {
                            if (this.serviceID != null) {
                                try {
                                    this.editor.setAsText(getopt.getOptarg());
                                }
                                catch (Exception e) {
                                    throw new CommandException("Command: \"" + this.getName() + "\" failed to parse SbbID.", (Throwable)e);
                                }
                                this.sbbID = (SbbID)this.editor.getValue();
                            } else {
                                this.usageSetName = getopt.getOptarg();
                            }
                            ++nonOptArgIndex;
                            continue block21;
                        }
                        case 2: {
                            if (this.serviceID == null) {
                                throw new CommandException("Command: \"" + this.getName() + "\" expects at most two non opt arguments!");
                            }
                            this.usageSetName = getopt.getOptarg();
                            ++nonOptArgIndex;
                            continue block21;
                        }
                    }
                    throw new CommandException("Command: \"" + this.getName() + "\" expects at most three non opt arguments!");
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
                case 103: {
                    this.operation = new GetOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
                case 114: {
                    this.operation = new ResetOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
                case 99: {
                    this.operation = new CreateOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
                case 100: {
                    this.operation = new DeleteOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
                case 110: {
                    this.operation = new NotifyOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block21;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    protected void prepareCommand() throws CommandException {
        if (this.resourceName == null && this.serviceID == null) {
            throw new CommandException("Command: \"" + this.getName() + "\", expects 'ResourceName'!");
        }
        if (this.serviceID != null && this.sbbID == null) {
            throw new CommandException("Command: \"" + this.getName() + "\", expects atleast 'SbbID' in 'SetID'!");
        }
        String[] sig = null;
        Object[] parms = null;
        if (this.serviceID == null) {
            sig = new String[]{"java.lang.String"};
            parms = new Object[]{this.resourceName};
        } else {
            sig = new String[]{"javax.slee.ServiceID"};
            parms = new Object[]{this.serviceID};
        }
        MBeanServerConnection server = this.context.getServer();
        try {
            this.usageMgmtMBeanName = (ObjectName)server.invoke(this.provisioningMBeanName, this.getOperationName, parms, sig);
        }
        catch (Exception e) {
            throw new CommandException("Command: \"" + this.getName() + "\" failed to obtain usage management bean name. Resource does not exist in container?", (Throwable)e);
        }
    }

    protected ObjectName getSpecificUsageMBeanOName() throws CommandException {
        String[] sig = null;
        Object[] parms = null;
        if (this.serviceID == null) {
            if (this.usageSetName != null) {
                sig = new String[]{"java.lang.String"};
                parms = new Object[]{this.usageSetName};
            } else {
                sig = new String[]{};
                parms = new Object[]{};
            }
        } else if (this.usageSetName != null) {
            sig = new String[]{"javax.slee.SbbID", "java.lang.String"};
            parms = new Object[]{this.sbbID, this.usageSetName};
        } else {
            sig = new String[]{"javax.slee.SbbID"};
            parms = new Object[]{this.sbbID};
        }
        MBeanServerConnection server = this.context.getServer();
        try {
            this.specificObjectName = this.serviceID != null ? (ObjectName)server.invoke(this.usageMgmtMBeanName, GET_SPECIFIC_SBB_BEAN_METHOD, parms, sig) : (ObjectName)server.invoke(this.usageMgmtMBeanName, GET_SPECIFIC_BEAN_METHOD, parms, sig);
            return this.specificObjectName;
        }
        catch (Exception e) {
            throw new CommandException("Command: \"" + this.getName() + "\" failed to obtain usage management bean name. Resource does not exist in container?", (Throwable)e);
        }
    }

    protected ObjectName getSpecificUsageNotificationMBeanOName() throws CommandException {
        String[] sig = null;
        Object[] parms = null;
        if (this.serviceID == null) {
            sig = new String[]{};
            parms = new Object[]{};
        } else {
            sig = new String[]{"javax.slee.SbbID"};
            parms = new Object[]{this.sbbID};
        }
        MBeanServerConnection server = this.context.getServer();
        try {
            this.specificObjectName = this.serviceID != null ? (ObjectName)server.invoke(this.usageMgmtMBeanName, GET_MANAGER_NAME_SBB_METHOD, parms, sig) : (ObjectName)server.invoke(this.usageMgmtMBeanName, GET_MANAGER_NAME_METHOD, parms, sig);
            return this.specificObjectName;
        }
        catch (Exception e) {
            throw new CommandException("Command: \"" + this.getName() + "\" failed to obtain usage management bean name. Resource does not exist in container?", (Throwable)e);
        }
    }

    public abstract ObjectName getProvisioningMBeanName();

    public abstract String getUsageMGMTMBeanOperation();

    protected class NotifyOperation
    extends AbstractOperation {
        public static final char value = 'o';
        public static final char is = 'i';
        private Boolean booleanValue;
        private String parameterName;
        private boolean isIndicated;

        public NotifyOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.isIndicated = false;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block7: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 111: {
                        this.booleanValue = Boolean.parseBoolean(opts.getOptarg());
                        continue block7;
                    }
                    case 122: {
                        String opt = opts.getOptarg();
                        if (!Character.isUpperCase(opt.charAt(0))) {
                            throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", cannot proceed. Parameter name must start with upper case: " + opt);
                        }
                        this.parameterName = opt;
                        continue block7;
                    }
                    case 105: {
                        this.isIndicated = true;
                        continue block7;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.parameterName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires '--name' option to be present.");
            }
            if (this.booleanValue != null && this.isIndicated || this.booleanValue == null && !this.isIndicated) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires either '--is' or '--value'.");
            }
            if (this.isIndicated) {
                this.operationName = "get" + this.parameterName + "NotificationsEnabled";
            } else {
                this.operationName = "set" + this.parameterName + "NotificationsEnabled";
                this.addArg((Object)this.booleanValue, Boolean.TYPE, false);
            }
            AbstractUsageCommand.this.getSpecificUsageNotificationMBeanOName();
        }
    }

    protected class DeleteOperation
    extends AbstractOperation {
        private static final String OPERATION_removeUsageParameterSet = "removeUsageParameterSet";

        public DeleteOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_removeUsageParameterSet;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            if (AbstractUsageCommand.this.usageSetName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires 'SetID' to be present");
            }
            if (AbstractUsageCommand.this.serviceID != null) {
                if (AbstractUsageCommand.this.sbbID == null) {
                    throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires SbbID in 'SetID' to be present");
                }
                this.addArg((Object)AbstractUsageCommand.this.sbbID, "javax.slee.SbbID", false);
            }
            this.addArg((Object)AbstractUsageCommand.this.usageSetName, String.class, false);
            AbstractUsageCommand.this.specificObjectName = AbstractUsageCommand.this.usageMgmtMBeanName;
        }
    }

    protected class CreateOperation
    extends AbstractOperation {
        private static final String OPERATION_createUsageParameterSet = "createUsageParameterSet";

        public CreateOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_createUsageParameterSet;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            if (AbstractUsageCommand.this.usageSetName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires 'SetID' to be present");
            }
            if (AbstractUsageCommand.this.serviceID != null) {
                if (AbstractUsageCommand.this.sbbID == null) {
                    throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires SbbID in 'SetID' to be present");
                }
                this.addArg((Object)AbstractUsageCommand.this.sbbID, "javax.slee.SbbID", false);
            }
            this.addArg((Object)AbstractUsageCommand.this.usageSetName, String.class, false);
            AbstractUsageCommand.this.specificObjectName = AbstractUsageCommand.this.usageMgmtMBeanName;
        }
    }

    protected class ResetOperation
    extends AbstractOperation {
        public static final char all = 'a';
        private static final String OPERATION_resetAllUsageParameters = "resetAllUsageParameters";
        public boolean allIndication;

        public ResetOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.allIndication = false;
            this.operationName = OPERATION_resetAllUsageParameters;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block5: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 97: {
                        AbstractUsageCommand.this.specificObjectName = AbstractUsageCommand.this.usageMgmtMBeanName;
                        this.allIndication = true;
                        continue block5;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (!this.allIndication) {
                AbstractUsageCommand.this.getSpecificUsageMBeanOName();
            } else if (AbstractUsageCommand.this.serviceID != null && AbstractUsageCommand.this.sbbID != null) {
                this.addArg((Object)AbstractUsageCommand.this.sbbID, "javax.slee.SbbID", false);
            }
        }
    }

    protected class GetOperation
    extends AbstractOperation {
        public static final char rst = 'x';
        public static final char name = 'z';
        private boolean reset;

        public GetOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.reset = false;
            this.operationName = "get";
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block6: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 120: {
                        this.reset = true;
                        continue block6;
                    }
                    case 122: {
                        String opt = opts.getOptarg();
                        if (!Character.isUpperCase(opt.charAt(0))) {
                            throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", cannot proceed. Parameter name must start with upper case: " + opt);
                        }
                        this.operationName = this.operationName + opt;
                        continue block6;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.operationName.equals("get")) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires atleast '--name' option.");
            }
            this.addArg((Object)new Boolean(this.reset), Boolean.TYPE, false);
            AbstractUsageCommand.this.getSpecificUsageMBeanOName();
        }
    }

    protected class ListOperation
    extends AbstractOperation {
        public static final char sets = 'v';
        public static final char parameters = 'b';
        private static final String OPERTION_getUsageParameterSets = "getUsageParameterSets";

        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERTION_getUsageParameterSets;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            AbstractUsageCommand.this.specificObjectName = AbstractUsageCommand.this.usageMgmtMBeanName;
            block6: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 118: {
                        this.operationName = OPERTION_getUsageParameterSets;
                        continue block6;
                    }
                    case 98: {
                        if (AbstractUsageCommand.this.serviceID != null) {
                            this.operationName = AbstractUsageCommand.GET_SPECIFIC_SBB_BEAN_METHOD;
                            continue block6;
                        }
                        this.operationName = AbstractUsageCommand.GET_SPECIFIC_BEAN_METHOD;
                        continue block6;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
        }

        public void invoke() throws CommandException {
            if (this.operationName.equals(OPERTION_getUsageParameterSets)) {
                if (AbstractUsageCommand.this.serviceID != null) {
                    this.addArg((Object)AbstractUsageCommand.this.sbbID, "javax.slee.SbbID", false);
                }
                super.invoke();
            } else {
                try {
                    String getMethod = this.operationName;
                    MBeanServerConnection conn = this.context.getServer();
                    Object[] parms = null;
                    String[] sig = null;
                    if (AbstractUsageCommand.this.serviceID == null) {
                        parms = new Object[]{};
                        sig = new String[]{};
                    } else {
                        parms = new Object[]{AbstractUsageCommand.this.sbbID};
                        sig = new String[]{"javax.slee.SbbID"};
                    }
                    ObjectName on = (ObjectName)conn.invoke(AbstractUsageCommand.this.usageMgmtMBeanName, getMethod, parms, sig);
                    this.operationResult = conn.getMBeanInfo(on);
                    this.displayResult();
                }
                catch (Exception e) {
                    throw new CommandException("Failed to invoke \"" + this.operationName + "\" due to: ", (Throwable)e);
                }
            }
        }

        public void displayResult() {
            if (!this.context.isQuiet()) {
                if (this.operationResult instanceof MBeanInfo) {
                    MBeanOperationInfo[] infos;
                    PrintWriter out = this.context.getWriter();
                    for (MBeanOperationInfo info : infos = ((MBeanInfo)this.operationResult).getOperations()) {
                        if (!info.getName().startsWith("get")) continue;
                        out.println();
                        out.println("Desc   : " + info.getDescription());
                        out.println("Name   : " + info.getName().replaceFirst("get", ""));
                        out.println("Sample : " + info.getReturnType().equals("javax.slee.usage.SampleStatistics"));
                    }
                    out.flush();
                } else {
                    super.displayResult();
                }
            }
        }
    }
}

