/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.op;

import gnu.getopt.Getopt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.mobicents.tools.twiddle.AbstractSleeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperation {
    public static final String CID_SEPARATOR = ";";
    protected Object operationResult;
    protected AbstractSleeCommand sleeCommand;
    protected String operationName;
    protected ArrayList<Object> opArguments = new ArrayList();
    protected ArrayList<String> opSignature = new ArrayList();
    protected CommandContext context;
    protected Logger log;

    protected AbstractOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
        this.context = context;
        this.log = log;
        this.sleeCommand = sleeCommand;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ArrayList<Object> getOpArguments() {
        return this.opArguments;
    }

    public ArrayList<String> getOpSignature() {
        return this.opSignature;
    }

    public abstract void buildOperation(Getopt var1, String[] var2) throws CommandException;

    public void displayResult() {
        if (!this.context.isQuiet()) {
            String resultText = this.prepareResultText();
            PrintWriter out = this.context.getWriter();
            out.println(resultText);
            out.flush();
        }
    }

    protected String prepareResultText() {
        String resultText = null;
        if (this.operationResult != null) {
            try {
                if (this.operationResult instanceof Collection) {
                    Object[] arrayO;
                    Collection c = (Collection)this.operationResult;
                    this.operationResult = arrayO = c.toArray();
                }
                if (this.operationResult.getClass().isArray()) {
                    Object[] resultArray = (Object[])this.operationResult;
                    Class<?> memberClass = resultArray.getClass().getComponentType();
                    PropertyEditor editor = PropertyEditors.getEditor(memberClass);
                    resultText = this.unfoldArray("", resultArray, editor);
                } else {
                    PropertyEditor editor = PropertyEditors.getEditor(this.operationResult.getClass());
                    editor.setValue(this.operationResult);
                    resultText = editor.getAsText();
                }
            }
            catch (RuntimeException e) {
                this.log.debug((Object)"No editor found: ", (Throwable)e);
                if (this.operationResult.getClass().isArray()) {
                    Object[] arrayResult = (Object[])this.operationResult;
                    resultText = this.unfoldArray("", arrayResult, null);
                }
                resultText = this.operationResult.toString();
            }
            this.log.debug((Object)("Converted result: " + resultText));
        } else {
            resultText = "'success'";
        }
        return resultText;
    }

    protected String unfoldArray(String prefix, Object[] array, PropertyEditor editor) {
        StringBuffer sb = new StringBuffer("\n");
        for (int index = 0; index < array.length; ++index) {
            if (editor != null) {
                editor.setValue(array[index]);
                sb.append(editor.getAsText());
            } else {
                sb.append(array[index].toString());
            }
            if (index >= array.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void addArg(Object arg, Class<? extends Object> argClass, boolean usPE) throws CommandException {
        if (usPE) {
            PropertyEditor pe = PropertyEditors.getEditor(argClass);
            if (pe == null) {
                throw new CommandException("There is no property editor for: " + argClass);
            }
            pe.setAsText((String)arg);
            this.opArguments.add(pe.getValue());
        } else {
            this.opArguments.add(arg);
        }
        this.opSignature.add(argClass.getName());
    }

    protected void addArg(Object arg, String argClass, boolean usPE) throws CommandException {
        if (usPE) {
            try {
                PropertyEditor pe = PropertyEditors.getEditor((String)argClass);
                if (pe == null) {
                    throw new CommandException("There is no property editor for: " + argClass);
                }
                if (arg != null) {
                    pe.setAsText((String)arg);
                    this.opArguments.add(pe.getValue());
                }
                this.opArguments.add(null);
            }
            catch (ClassNotFoundException cnfe) {
                throw new CommandException("Failed to locate class.", (Throwable)cnfe);
            }
        } else {
            this.opArguments.add(arg);
        }
        this.opSignature.add(argClass);
    }

    public void invoke() throws CommandException {
        try {
            ObjectName on = this.sleeCommand.getBeanOName();
            MBeanServerConnection conn = this.context.getServer();
            Object[] parms = this.getOpArguments().toArray();
            String[] sig = new String[this.getOpSignature().size()];
            sig = this.getOpSignature().toArray(sig);
            this.operationResult = conn.invoke(on, this.operationName, parms, sig);
            this.displayResult();
        }
        catch (Exception e) {
            throw new CommandException("Failed to invoke \"" + this.operationName + "\" due to: ", (Throwable)e);
        }
    }
}

