/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class ProfileCommand
extends AbstractSleeCommand {
    public ProfileCommand() {
        super("profile", "This command performs operations on JSLEE ProfileProvisioningMBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -l, --list                     Lists components based on passed option:");
        out.println("            --table                Lists profile table names, optionally it takes ProfileSpecificationID as argument, ");
        out.println("                                   if so, names are listed only for tables which ProfileSpecificationID matches.");
        out.println("            --profile              Lists profile IDs by table name,");
        out.println("                                   requires profile table name as argument.");
        out.println("    -c, --create                   Creates component based on passed options. Supported are two sets [ \"--table-name\" & \"--profile-name\" | \"--table-name\" & \"--profile-spec\" ]");
        out.println("            --profile-name         Indicates profile name to be created. It is used in conjunction with \"--table-name\" to create profile in table.");
        out.println("            --table-name           Indicates profile table name. It requires either \"--profile-name\" or \"--profile-spec\".");
        out.println("            --profile-spec         Indicates ProfileSpecification ID used to craete table.");
        out.println("    -r, --remove                   Removes component based on passed options. Requires atleast \"--table-name\" option. Following options are supported:");
        out.println("            --table-name           Indicates table name to be removed. If \"--profile-name\" is also used, only profile is removed from table.");
        out.println("            --profile-name         Indicates profile name of profile to be removed. It is used in conjunction with \"--table-name\".");
        out.println("    -n, --rename                   Renames profile table, based on options. Both are required. Supported options are:");
        out.println("            --current-name         Sets current name of profile table.");
        out.println("            --new-name             Sets new name for profile table.");
        out.println("    -g, --get                      Fetches information regarding profiles and profile tables based on option, exactly one must be present. Supported options:");
        out.println("            --profile-spec         Retrieves ProfileSpecification ID for given table name,");
        out.println("                                   requires profile table name as argument.");
        out.println("arg:");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Get specification ID for table:");
        out.println("" + this.name + " -g --profile-spec=CallControl");
        out.println("");
        out.println("     2. Rename profile table");
        out.println("" + this.name + " -n --curent-name=CallControl --new-name=OldCCTable");
        out.println("");
        out.println("     3. List all tables present:");
        out.println("" + this.name + " -l --table");
        out.println("");
        out.println("     4. List all tables present for specific ProfileSpecificationID");
        out.println("" + this.name + " -l --table=ProfileSpecificationID[name=CallControlProfileCMP,vendor=org.mobicents,version=0.1]");
        out.println("");
        out.println("     5. Create table for specification:");
        out.println("" + this.name + " -c --table-name=NewCallControl --profile-spec=ProfileSpecificationID[name=CallControlProfileCMP,vendor=org.mobicents,version=0.1]");
        out.println("");
        out.println("     6. Create profile in table:");
        out.println("" + this.name + " -c --table-name=NewCallControl --profile-name=newuser");
        out.flush();
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":lcrng";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("list", 0, null, 108), new LongOpt("table", 2, null, 111), new LongOpt("profile", 1, null, 112), new LongOpt("create", 0, null, 99), new LongOpt("profile-name", 1, null, 118), new LongOpt("table-name", 1, null, 98), new LongOpt("profile-spec", 1, null, 109), new LongOpt("remove", 0, null, 114), new LongOpt("rename", 0, null, 110), new LongOpt("current-name", 1, null, 107), new LongOpt("new-name", 1, null, 106), new LongOpt("get", 0, null, 103), new LongOpt("profile-spec", 1, null, 109)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block9: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 99: {
                    this.operation = new CreateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 114: {
                    this.operation = new RemoveOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 110: {
                    this.operation = new RenameOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 103: {
                    this.operation = new GetOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=ProfileProvisioning");
    }

    private class GetOperation
    extends AbstractOperation {
        public static final char profile_name = 'v';
        public static final char profile_spec = 'm';
        public static final char profile = 'x';
        private static final String OPERATION_getDefaultProfile = "getDefaultProfile";
        private static final String OPERATION_getProfile = "getProfile";
        private static final String OPERATION_getProfileSpecification = "getProfileSpecification";
        private String stringProfileSpec_TableName;
        private String stringProfile_TableName;
        private String stringProfileName_Name;

        public GetOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block7: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 118: {
                        this.stringProfileName_Name = opts.getOptarg();
                        continue block7;
                    }
                    case 109: {
                        this.stringProfileSpec_TableName = opts.getOptarg();
                        continue block7;
                    }
                    case 120: {
                        this.stringProfile_TableName = opts.getOptarg();
                        continue block7;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringProfileSpec_TableName == null && this.stringProfile_TableName == null || this.stringProfileSpec_TableName != null && this.stringProfile_TableName != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--profile\" or \"--profile-spec\" to be present");
            }
            if (this.stringProfileSpec_TableName != null) {
                this.operationName = OPERATION_getProfileSpecification;
                super.addArg((Object)this.stringProfileSpec_TableName, String.class, false);
            } else if (this.stringProfileName_Name == null) {
                this.operationName = OPERATION_getDefaultProfile;
                super.addArg((Object)this.stringProfile_TableName, String.class, false);
            } else {
                this.operationName = OPERATION_getProfile;
                super.addArg((Object)this.stringProfile_TableName, String.class, false);
                super.addArg((Object)this.stringProfileName_Name, String.class, false);
            }
        }
    }

    private class RenameOperation
    extends AbstractOperation {
        public static final char current_name = 'k';
        public static final char new_name = 'j';
        private static final String OPERATION_renameProfileTable = "renameProfileTable";
        private String stringCurrentTableName;
        private String stringNewTableName;

        public RenameOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_renameProfileTable;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block6: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 107: {
                        this.stringCurrentTableName = opts.getOptarg();
                        continue block6;
                    }
                    case 106: {
                        this.stringNewTableName = opts.getOptarg();
                        continue block6;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringCurrentTableName == null && this.stringNewTableName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects both \"--current-name\" and \"--new-spec\" to be present");
            }
            super.addArg((Object)this.stringCurrentTableName, String.class, false);
            super.addArg((Object)this.stringNewTableName, String.class, false);
        }

        protected String prepareResultText() {
            return "Profile table renamed.";
        }
    }

    private class RemoveOperation
    extends AbstractOperation {
        public static final char table_name = 'b';
        public static final char profile_name = 'v';
        private static final String OPERATION_removeProfile = "removeProfile";
        private static final String OPERATION_removeProfileTable = "removeProfileTable";
        private String stringTableName;
        private String stringProfileName;

        public RemoveOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block6: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 98: {
                        this.stringTableName = opts.getOptarg();
                        continue block6;
                    }
                    case 118: {
                        this.stringProfileName = opts.getOptarg();
                        continue block6;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringTableName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects \"--profile-table\" to be present");
            }
            super.addArg((Object)this.stringTableName, String.class, false);
            if (this.stringProfileName == null) {
                this.operationName = OPERATION_removeProfileTable;
            } else {
                this.operationName = OPERATION_removeProfile;
                super.addArg((Object)this.stringProfileName, String.class, false);
            }
        }

        protected String prepareResultText() {
            if (this.operationName.equals(OPERATION_removeProfile)) {
                return "Profile removed.";
            }
            return "Profile Table removed.";
        }
    }

    private class CreateOperation
    extends AbstractOperation {
        public static final char table_name = 'b';
        public static final char profile_name = 'v';
        public static final char profile_spec = 'm';
        private static final String OPERATION_createProfile = "createProfile";
        private static final String OPERATION_createProfileTable = "createProfileTable";
        private String stringTableName;
        private String stringProfileName;
        private String stringProfileSpec;

        public CreateOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block9: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 98: {
                        this.stringTableName = opts.getOptarg();
                        continue block9;
                    }
                    case 118: {
                        this.stringProfileName = opts.getOptarg();
                        continue block9;
                    }
                    case 109: {
                        this.stringProfileSpec = opts.getOptarg();
                        continue block9;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringProfileSpec == null && this.stringProfileName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--profile-name\" or \"--profile-spec\" to be present");
            }
            if (this.stringProfileSpec != null && this.stringProfileName != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--profile-name\" or \"--profile-spec\" to be present");
            }
            if (this.stringTableName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects \"--profile-table\" to be present");
            }
            if (this.stringProfileName != null) {
                this.operationName = OPERATION_createProfile;
                super.addArg((Object)this.stringTableName, String.class, false);
                super.addArg((Object)this.stringProfileName, String.class, false);
            } else {
                this.operationName = OPERATION_createProfileTable;
                try {
                    super.addArg((Object)this.stringProfileSpec, ProfileSpecificationID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse ProfileSpecificationID: \"" + this.stringProfileSpec + "\"", (Throwable)e);
                }
                super.addArg((Object)this.stringTableName, String.class, false);
            }
        }

        protected String prepareResultText() {
            if (this.operationName.equals(OPERATION_createProfile)) {
                return "Profile created.";
            }
            return "Profile Table created: " + this.operationResult;
        }
    }

    private class ListOperation
    extends AbstractOperation {
        public static final char table = 'o';
        public static final char profile = 'p';
        private static final String OPERATION_getProfileTables = "getProfileTables";
        private static final String OPERATION_getProfiles = "getProfiles";

        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--table\" or \"--profile\"!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 111: {
                        this.operationName = OPERATION_getProfileTables;
                        String optArg = opts.getOptarg();
                        if (optArg == null) break;
                        try {
                            this.addArg((Object)optArg, ProfileSpecificationID.class, true);
                            break;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse ProfileSpecificationID: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 112: {
                        this.operationName = OPERATION_getProfiles;
                        String optArg = opts.getOptarg();
                        this.addArg((Object)optArg, String.class, false);
                        break;
                    }
                    default: {
                        throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
                    }
                }
                if (this.operationName != null) continue;
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--table\" or \"--profile\"!");
            }
        }
    }
}

