/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class ProfileEditCommand
extends AbstractSleeCommand {
    private ObjectName PROFILE_PROVISIONING_MBEAN;
    private static final String OPERATION_DEFAULT_GET = "getDefaultProfile";
    private static final String OPERATION_GET = "getProfile";
    private ObjectName specificObjectName;
    private String profileTableName;
    private String profileName;
    private MBeanInfo beanInfo;

    public ProfileEditCommand() {
        super("profile.edit", "This command performs operations on JSLEE Profile MBean like: javax.slee.profile:type=Profile,profileTableName=CallControl,profileName=");
        try {
            this.PROFILE_PROVISIONING_MBEAN = new ObjectName("javax.slee.management:name=ProfileProvisioning");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <profileTableName> <profileName> <-operation[[arg] | [--option[=arg]]]*>");
        out.println();
        out.println("operation:");
        out.println("    -l, --list                     Returns list of available attributes and information associated with each.");
        out.println("    -d, --dirty                    Returns indication if profile is dirty. Does not require argument.");
        out.println("    -w, --write                    Returns indication if profile is in write mode. Does not require argument.");
        out.println("    -e, --edit                     Marks profile as editable. Without this op any other will fail. Does not require argument.");
        out.println("    -c, --commit                   Commits changes done to profile. Can be invoked only after \"-e\". Does not require argument.");
        out.println("    -r, --restore                  Revokes changes done to profile. Can be invoked only after \"-e\". Does not require argument.");
        out.println("    -o, --close                    De-registers MBean. Does not require argument.");
        out.println("    -g, --get                      Returns value of profile attribute. Requires attribute name, ie. : \"voiceMailEnabled\".");
        out.println("    -s, --set                      Sets value of profile attribute. Supports mandatory options:.");
        out.println("         --name                    Specifies name of profile attribute. Requires attribute name as parameter.");
        out.println("         --separator               Specifies separator for parsing profile attribute value and creating arrays. Does not require separator as parameter if profile attribute value is not array.");
        out.println("         --value                   Specifies string representation of profile attribute value. Requires value as parameter.");
        out.println("                                   Command tries locally registered JMX Editor to parse value and optimize call, if editor is not found");
        out.println("                                   it dispatches call in hope that server side has better luck.");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Check if profile has been edited:");
        out.println("" + this.name + " CallControl mobile.user -w");
        out.println("");
        out.println("     2. Check if any changes were introduced to profile:");
        out.println("" + this.name + " CallControl mobile.user -d");
        out.println("");
        out.println("     3. Start editing:");
        out.println("" + this.name + " CallControl mobile.user -e");
        out.println("");
        out.println("     4. Set attribute:");
        out.println("" + this.name + " CallControl mobile.user -s --name=userPhone --value=sip:ala@ma.kota:5090");
        out.println("");
        out.println("     5. Set attribute with array:");
        out.println("" + this.name + " CallControl mobile.user -s --name=users --separator=\";\" --value=\"Bob;Alice;John\"");
        out.println("");
        out.println("     6. Commit changes:");
        out.println("" + this.name + " CallControl mobile.user -c");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return this.specificObjectName;
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = "-:ldwecrog:s";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("noprefix", 0, null, 4096), new LongOpt("list", 0, null, 108), new LongOpt("dirty", 0, null, 100), new LongOpt("write", 0, null, 119), new LongOpt("edit", 0, null, 101), new LongOpt("commit", 0, null, 99), new LongOpt("restore", 0, null, 114), new LongOpt("close", 0, null, 111), new LongOpt("get", 1, null, 103), new LongOpt("set", 0, null, 115), new LongOpt("name", 1, null, 110), new LongOpt("separator", 2, null, 112), new LongOpt("value", 2, null, 118)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int nonOptArgIndex = 0;
        block19: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 4096: {
                    continue block19;
                }
                case 1: {
                    switch (nonOptArgIndex) {
                        case 0: {
                            this.profileTableName = getopt.getOptarg();
                            ++nonOptArgIndex;
                            continue block19;
                        }
                        case 1: {
                            this.profileName = getopt.getOptarg();
                            ++nonOptArgIndex;
                            continue block19;
                        }
                    }
                    throw new CommandException("Command: \"" + this.getName() + "\" expects at most two non opt arguments!");
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 100: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "isProfileDirty");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 119: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "isProfileWriteable");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 101: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "editProfile");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 99: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "commitProfile");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 114: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "restoreProfile");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 111: {
                    this.operation = new SimpleInvokeOperation(this.context, this.log, this, "closeProfile");
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 103: {
                    this.operation = new GetAttributeOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
                case 115: {
                    this.operation = new SetAttributeOperation(this.context, this.log, this);
                    this.prepareCommand();
                    this.operation.buildOperation(getopt, args);
                    continue block19;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private void prepareCommand() throws CommandException {
        String[] sig;
        Object[] parms;
        String getOperationName;
        if (this.profileTableName == null) {
            throw new CommandException("Command: \"" + this.getName() + "\", expects atleast \"-t\" to specify table name!");
        }
        MBeanServerConnection server = this.context.getServer();
        if (this.profileName == null) {
            getOperationName = OPERATION_DEFAULT_GET;
            parms = new Object[]{this.profileTableName};
            sig = new String[]{"java.lang.String"};
        } else {
            getOperationName = OPERATION_GET;
            parms = new Object[]{this.profileTableName, this.profileName};
            sig = new String[]{"java.lang.String", "java.lang.String"};
        }
        try {
            this.specificObjectName = (ObjectName)server.invoke(this.PROFILE_PROVISIONING_MBEAN, getOperationName, parms, sig);
        }
        catch (Exception e) {
            if (this.operation.getOperationName().equals("commitProfile")) {
                try {
                    String profileBeanName = "javax.slee.profile:profileName=" + this.profileName;
                    profileBeanName = profileBeanName + ",profileTableName=" + this.profileTableName;
                    profileBeanName = profileBeanName + ",type=Profile";
                    this.specificObjectName = new ObjectName(profileBeanName);
                }
                catch (Exception ce) {
                    throw new CommandException("Command: \"" + this.getName() + "\" failed to commit bean name for specified profile.", (Throwable)ce);
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\" failed to obtain bean name for specified table name and profile. Table or profile does not exist.", (Throwable)e);
        }
        try {
            this.beanInfo = server.getMBeanInfo(this.specificObjectName);
        }
        catch (Exception e) {
            throw new CommandException("Command: \"" + this.getName() + "\" failed to obtain bean name for specified table name and profile.", (Throwable)e);
        }
    }

    private MBeanAttributeInfo findAttribute(String attr_name, MBeanAttributeInfo[] attribute_info) {
        for (int i = 0; i < attribute_info.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = attribute_info[i];
            if (!mBeanAttributeInfo.getName().equals(attr_name)) continue;
            return mBeanAttributeInfo;
        }
        return null;
    }

    private class SetAttributeOperation
    extends AbstractOperation {
        public static final char name = 'n';
        public static final char separator = 'p';
        public static final char value = 'v';
        private String attributeName;
        private String valueSeparator;
        private String stringAttributeValue;
        private ProfileEditCommand editCommand;

        public SetAttributeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.editCommand = (ProfileEditCommand)sleeCommand;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block17: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 110: {
                        this.attributeName = opts.getOptarg();
                        continue block17;
                    }
                    case 112: {
                        this.valueSeparator = opts.getOptarg();
                        continue block17;
                    }
                    case 118: {
                        this.stringAttributeValue = opts.getOptarg();
                        continue block17;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.attributeName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requiers \"--name\".");
            }
            MBeanAttributeInfo info = ProfileEditCommand.this.findAttribute(this.attributeName, this.editCommand.beanInfo.getAttributes());
            this.operationName = "set" + info.getName();
            if (this.valueSeparator != null) {
                Class<?> valueClazz;
                try {
                    Class<?> arrayClazz = Class.forName(info.getType());
                    if (!arrayClazz.isArray()) {
                        throw new CommandException("Attribute type is not array and separator is not used.");
                    }
                    valueClazz = arrayClazz.getComponentType();
                }
                catch (ClassNotFoundException e) {
                    throw new CommandException("Class is not found for attribute type.");
                }
                if (this.valueSeparator.length() > 1) {
                    throw new CommandException("Separator must contains only single character.");
                }
                String delims = "[" + this.valueSeparator + "]";
                String[] tokens = this.stringAttributeValue.split(delims);
                Object array = Array.newInstance(valueClazz, tokens.length);
                for (int i = 0; i < tokens.length; ++i) {
                    try {
                        if (valueClazz.isPrimitive()) {
                            throw new CommandException("Arrays with primitive types are not supported now.");
                        }
                        if (valueClazz.isPrimitive()) continue;
                        Address value = null;
                        if (valueClazz.getName().equals("javax.slee.Address")) {
                            try {
                                int delimerSize = 2;
                                int delimiter = tokens[i].indexOf(": ");
                                if (delimiter == -1) {
                                    delimerSize = 1;
                                    delimiter = tokens[i].indexOf(":");
                                }
                                if (delimiter == -1) {
                                    throw new IllegalArgumentException("Address arg should be \"address plan as string\" + \": \" + \"address as string\"");
                                }
                                String addressPlan = tokens[i].substring(0, delimiter);
                                String address = tokens[i].substring(delimiter + delimerSize);
                                value = new Address(AddressPlan.fromString((String)addressPlan), address);
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException(ex.getMessage(), ex);
                            }
                        } else {
                            Constructor<?> con = valueClazz.getConstructor(String.class);
                            if (con != null) {
                                value = (Address)con.newInstance(tokens[i]);
                            }
                        }
                        Array.set(array, i, value);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new CommandException("Value getting has problem: " + ex.getMessage());
                    }
                }
                try {
                    super.addArg(array, info.getType(), false);
                }
                catch (CommandException ce) {}
            } else {
                try {
                    super.addArg((Object)this.stringAttributeValue, info.getType(), true);
                }
                catch (CommandException ce) {
                    super.addArg((Object)this.stringAttributeValue, info.getType(), false);
                }
            }
        }
    }

    private class GetAttributeOperation
    extends AbstractOperation {
        private ProfileEditCommand editCommand;

        public GetAttributeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.editCommand = (ProfileEditCommand)sleeCommand;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String attributeName = opts.getOptarg();
            MBeanAttributeInfo info = ProfileEditCommand.this.findAttribute(attributeName, this.editCommand.beanInfo.getAttributes());
            if (info == null) {
                throw new CommandException("Attribute: " + attributeName + ", does not exist in bean!");
            }
            if (!info.isReadable()) {
                throw new CommandException("Attribute: " + attributeName + ", is not readable!");
            }
            this.operationName = info.isIs() ? "is" + attributeName : "get" + attributeName;
        }
    }

    private class SimpleInvokeOperation
    extends AbstractOperation {
        public SimpleInvokeOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand, String operationName) {
            super(context, log, sleeCommand);
            this.operationName = operationName;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }
    }

    private class ListOperation
    extends AbstractOperation {
        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
        }

        public void invoke() throws CommandException {
            try {
                this.displayResult();
            }
            catch (Exception e) {
                throw new CommandException("Failed to invoke \"" + this.operationName + "\" due to: ", (Throwable)e);
            }
        }

        public void displayResult() {
            if (!this.context.isQuiet()) {
                HashSet<String> notDisplayed = new HashSet<String>();
                notDisplayed.add("ProfileDirty");
                notDisplayed.add("ProfileWriteable");
                String resultText = null;
                PrintWriter out = this.context.getWriter();
                if (ProfileEditCommand.this.beanInfo != null) {
                    MBeanAttributeInfo[] infos;
                    for (MBeanAttributeInfo info : infos = ProfileEditCommand.this.beanInfo.getAttributes()) {
                        if (notDisplayed.contains(info.getName())) continue;
                        out.println();
                        out.println("Desc : " + info.getDescription());
                        out.println("Name : " + info.getName());
                        out.println("Type : " + info.getType());
                        out.println("r/w  : " + info.isReadable() + "/" + info.isWritable());
                        out.println("isIs : " + info.isIs());
                    }
                } else {
                    resultText = "'success'";
                    out.println(resultText);
                }
                out.flush();
            }
        }
    }
}

