/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.management.NotificationSource;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class AlarmCommand
extends AbstractSleeCommand {
    public AlarmCommand() {
        super("alarm", "This command performs operations on JSLEE AlarmMBean. ");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -c, --clear                    Clears alarm which meets criteria. Option \"--id\" or \"--nsrc\" must be present. Following options are supported:");
        out.println("            --id                   Specifies ID of alarm to be cleared. This option MUST NOT be used with any other options.");
        out.println("                                   Expects parameter of String type.");
        out.println("            --nsrc                 Specifies Notification source for which alarms will be cleared. It can be used in conjunction with \"--type\".");
        out.println("                                   Expects parameter of NotificationSource type.");
        out.println("            --type                 Type of alarm which will be cleared. It can be used in conjunction with \"--nsrc\".");
        out.println("                                   Expects parameter of String type.");
        out.println("    -l, --list                     Fetches list(id) of active alarms. If \"--nsrc\" option is used, alarm Ids are fetched for this Notification source.");
        out.println("            --nsrc                 Notification source for which alarms Ids are fetched, its not mandatory.");
        out.println("                                   Expects parameter of NotificationSource type.");
        out.println("    -d, --descriptor               Fetches descriptor of alarm, if passed argument is an array of alarm ids, it will return array of descriptors.");
        out.println("                                   Expects parameter of String or array of Strings.");
        out.println("    -a, --active                   Checks if alarm with matching id is active.");
        out.println("                                   Expects parameter of String type. Passed argument must be id of alarm.");
        out.println();
        out.println("arg:");
        out.println("");
        out.println("    NotificationSource:    ProfileTableNotification[table=xxx]");
        out.println("    AlarmId array:         alarmId1;alarmId2");
        out.println("");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Check if alarm with specific id is active or not:");
        out.println("" + this.name + " -a415f719e-3a3d-42b4-acc1-4e84706f031a");
        out.println("" + this.name + " --active=415f719e-3a3d-42b4-acc1-4e84706f031a");
        out.println("");
        out.println("     2. List ids of active alarms:");
        out.println("" + this.name + " -l");
        out.println("");
        out.println("     3. List ids of active alarms originating from specific notification source:");
        out.println("" + this.name + " -l --nsrc=RAEntityNotification[entity=LabRA]");
        out.println("");
        out.println("     4. Clear all alarms of certain type originating from certain notification source:");
        out.println("" + this.name + " -c --nsrc=RAEntityNotification[entity=LabRA] --type=application.trivial.com.org.net");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=Alarm");
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":cd:a:l";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("list", 0, null, 108), new LongOpt("nsrc", 1, null, 122), new LongOpt("descriptor", 1, null, 100), new LongOpt("active", 1, null, 97), new LongOpt("clear", 0, null, 99), new LongOpt("nsrc", 1, null, 118), new LongOpt("type", 1, null, 98), new LongOpt("id", 1, null, 120)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block8: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 99: {
                    this.operation = new ClearAlarmsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 108: {
                    this.operation = new ListAlarmsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 100: {
                    this.operation = new GetDescriptorOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
                case 97: {
                    this.operation = new IsActiveOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block8;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class ClearAlarmsOperation
    extends AbstractOperation {
        private static final String OPERATION_clearAlarms = "clearAlarms";
        private static final String OPERATION_clearAlarm = "clearAlarm";
        public static final char nsrc = 'v';
        public static final char type = 'b';
        public static final char id = 'x';
        private String stringID;
        private String stringNsrc;
        private String stringType;

        public ClearAlarmsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block9: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 118: {
                        this.stringNsrc = opts.getOptarg();
                        this.operationName = OPERATION_clearAlarms;
                        continue block9;
                    }
                    case 98: {
                        this.stringType = opts.getOptarg();
                        this.operationName = OPERATION_clearAlarms;
                        continue block9;
                    }
                    case 120: {
                        this.stringID = opts.getOptarg();
                        this.operationName = OPERATION_clearAlarm;
                        continue block9;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringID == null && this.stringNsrc == null || this.stringID != null && this.stringNsrc != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--nsrc\" or \"--id\" to be present");
            }
            if (this.stringID != null) {
                if (this.stringID.contains(";")) {
                    throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
                }
                this.addArg((Object)this.stringID, String.class, false);
            } else {
                if (this.stringNsrc.contains(";")) {
                    throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
                }
                try {
                    this.addArg((Object)this.stringNsrc, NotificationSource.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse NotificationSource: \"" + this.stringNsrc + "\"", (Throwable)e);
                }
                if (this.stringType != null && this.stringType.contains(";")) {
                    throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
                }
                this.addArg((Object)this.stringType, String.class, false);
            }
        }

        protected String prepareResultText() {
            if (this.operationName.equals(OPERATION_clearAlarm)) {
                Boolean b = (Boolean)this.operationResult;
                if (b.booleanValue()) {
                    return "Alarm has been cleared.";
                }
                return "Alarm has not been cleared.";
            }
            return "Number of Alarms cleared: " + this.operationResult;
        }
    }

    private class ListAlarmsOperation
    extends AbstractOperation {
        public static final char nsrc = 'z';
        private static final String OPERATION_getAlarms = "getAlarms";

        public ListAlarmsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getAlarms;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code = opts.getopt();
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                }
                case -1: {
                    break;
                }
                case 122: {
                    String optArg = opts.getOptarg();
                    if (optArg.contains(";")) {
                        throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
                    }
                    try {
                        this.addArg((Object)optArg, NotificationSource.class, true);
                        break;
                    }
                    catch (Exception e) {
                        throw new CommandException("Failed to parse NotificationSource: \"" + optArg + "\"", (Throwable)e);
                    }
                }
                default: {
                    throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
                }
            }
        }

        protected String prepareResultText() {
            if (this.operationResult == null) {
                return "No Alarms present";
            }
            String[] alarms = (String[])this.operationResult;
            if (alarms.length == 0) {
                return "No Alarms present";
            }
            return super.prepareResultText();
        }
    }

    private class GetDescriptorOperation
    extends AbstractOperation {
        private static final String OPERATION_getDescriptors = "getDescriptors";
        private static final String OPERATION_getDescriptor = "getDescriptor";

        public GetDescriptorOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                this.addArg((Object)optArg.split(";"), String[].class, false);
                this.operationName = OPERATION_getDescriptors;
            } else {
                this.operationName = OPERATION_getDescriptor;
                this.addArg((Object)optArg, String.class, false);
            }
        }
    }

    private class IsActiveOperation
    extends AbstractOperation {
        private static final String OPERATION_isActive = "isActive";

        public IsActiveOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_isActive;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
            }
            this.addArg((Object)optArg, String.class, false);
        }

        protected String prepareResultText() {
            Boolean b = (Boolean)this.operationResult;
            if (b.booleanValue()) {
                return "Alarm is active.";
            }
            return "Alarm is inactive.";
        }
    }
}

