/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jsleex;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class TimerCommand
extends AbstractSleeCommand {
    public TimerCommand() {
        super("timer", "This command performs operations on Restcomm TimerFacilityConfiguration MBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -t, --threads                   Performs operation on number of threads in timer facility. Exactly one of following options must be present:");
        out.println("            --get                   Returns number of currently used threads. Does not require argument.");
        out.println("            --set                   Sets number of threads, requires argument which is integer greater than zero.");
        out.flush();
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.mobicents.slee:name=TimerFacilityConfiguration");
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":t";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("list", 0, null, 108), new LongOpt("set", 1, null, 115), new LongOpt("get", 0, null, 103)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block5: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 116: {
                    this.operation = new ThreadsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block5;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class ThreadsOperation
    extends AbstractOperation {
        public static final char set = 's';
        public static final char get = 'g';
        private static final String OPERATION_setTimerThreads = "setTimerThreads";
        private static final String OPERATION_getTimerThreads = "getTimerThreads";

        public ThreadsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block8: while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 115: {
                        this.operationName = OPERATION_setTimerThreads;
                        String optArg = opts.getOptarg();
                        try {
                            this.addArg((Object)Integer.parseInt(optArg), Integer.TYPE, false);
                            continue block8;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 103: {
                        this.operationName = OPERATION_getTimerThreads;
                        continue block8;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.operationName == null) {
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
            }
        }
    }
}

